/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobRef;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.uws.server.JobExecutor;
import ca.nrc.cadc.uws.server.JobManager;
import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistence;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.server.JobPersistenceUtil;
import ca.nrc.cadc.uws.server.JobPhaseException;
import ca.nrc.cadc.uws.server.SyncOutput;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJobManager
implements JobManager {
    private static final Logger log = Logger.getLogger(SimpleJobManager.class);
    protected JobPersistence jobPersistence;
    protected JobExecutor jobExecutor;
    protected Long maxExecDuration = 3600L;
    protected Long maxQuote = 3600L;
    protected Long maxDestruction = 604800L;

    public SimpleJobManager() {
    }

    public SimpleJobManager(JobPersistence jobPersistence, JobExecutor jobExecutor) {
        this.jobPersistence = jobPersistence;
        this.jobExecutor = jobExecutor;
    }

    @Override
    public void terminate() throws InterruptedException {
        if (this.jobPersistence != null) {
            this.jobPersistence.terminate();
        }
        if (this.jobExecutor != null) {
            this.jobExecutor.terminate();
        }
    }

    @Override
    public void setJobExecutor(JobExecutor je) {
        this.jobExecutor = je;
    }

    @Override
    public void setJobPersistence(JobPersistence jp) {
        this.jobPersistence = jp;
    }

    public void setMaxExecDuration(Long maxExecDuration) {
        this.maxExecDuration = maxExecDuration;
    }

    public void setMaxDestruction(Long maxDestruction) {
        this.maxDestruction = maxDestruction;
    }

    public void setMaxQuote(Long maxQuote) {
        this.maxQuote = maxQuote;
    }

    @Override
    public void abort(String jobID) throws JobNotFoundException, JobPersistenceException, JobPhaseException, TransientException {
        Job job = this.jobPersistence.get(jobID);
        this.doAuthorizationCheck(job);
        this.jobExecutor.abort(job);
    }

    @Override
    public Job create(Job job) throws JobPersistenceException, TransientException {
        job.setExecutionPhase(ExecutionPhase.PENDING);
        JobPersistenceUtil.constrainDestruction(job, 1L, this.maxDestruction);
        JobPersistenceUtil.constrainDuration(job, 1L, this.maxExecDuration);
        JobPersistenceUtil.constrainQuote(job, 1L, this.maxQuote);
        return this.jobPersistence.put(job);
    }

    @Override
    public void delete(String jobID) throws JobNotFoundException, JobPersistenceException, TransientException {
        Job job = this.jobPersistence.get(jobID);
        this.doAuthorizationCheck(job);
        this.jobPersistence.delete(jobID);
    }

    @Override
    public void execute(String jobID) throws JobNotFoundException, JobPersistenceException, JobPhaseException, TransientException {
        Job job = this.jobPersistence.get(jobID);
        this.doAuthorizationCheck(job);
        this.execute(job);
    }

    @Override
    public void execute(Job job) throws JobNotFoundException, JobPersistenceException, JobPhaseException, TransientException {
        this.jobExecutor.execute(job);
    }

    @Override
    public void execute(String jobID, SyncOutput output) throws JobNotFoundException, JobPersistenceException, JobPhaseException, TransientException {
        Job job = this.jobPersistence.get(jobID);
        this.doAuthorizationCheck(job);
        this.jobPersistence.getDetails(job);
        this.execute(job, output);
    }

    @Override
    public void execute(Job job, SyncOutput output) throws JobNotFoundException, JobPersistenceException, JobPhaseException, TransientException {
        this.jobExecutor.execute(job, output);
    }

    @Override
    public Job get(String jobID) throws JobNotFoundException, JobPersistenceException, TransientException {
        Job job = this.jobPersistence.get(jobID);
        this.doAuthorizationCheck(job);
        this.jobPersistence.getDetails(job);
        return job;
    }

    @Override
    public Iterator<JobRef> iterator(String appname) throws JobPersistenceException, TransientException {
        return this.jobPersistence.iterator(appname);
    }

    @Override
    public Iterator<JobRef> iterator(String appname, List<ExecutionPhase> phases) throws JobPersistenceException, TransientException {
        return this.jobPersistence.iterator(appname, phases);
    }

    @Override
    public Iterator<JobRef> iterator(String appname, List<ExecutionPhase> phases, Date after, Integer last) throws JobPersistenceException, TransientException {
        return this.jobPersistence.iterator(appname, phases, after, last);
    }

    @Override
    public void update(String jobID, Date destruction, Long duration, Date quote) throws JobNotFoundException, JobPersistenceException, JobPhaseException, TransientException {
        log.debug("update: " + jobID + "," + destruction + "," + duration + "," + quote);
        Job job = this.jobPersistence.get(jobID);
        this.doAuthorizationCheck(job);
        if (!ExecutionPhase.PENDING.equals((Object)job.getExecutionPhase())) {
            throw new JobPhaseException("cannot update job control details when phase=" + (Object)((Object)job.getExecutionPhase()));
        }
        if (destruction != null) {
            job.setDestructionTime(destruction);
        }
        if (duration != null) {
            job.setExecutionDuration(duration);
        }
        if (quote != null) {
            job.setQuote(quote);
        }
        JobPersistenceUtil.constrainDestruction(job, 1L, this.maxDestruction);
        JobPersistenceUtil.constrainDuration(job, 1L, this.maxExecDuration);
        JobPersistenceUtil.constrainQuote(job, 1L, this.maxQuote);
        this.jobPersistence.put(job);
    }

    @Override
    public void update(String jobID, List<Parameter> params) throws JobNotFoundException, JobPersistenceException, JobPhaseException, TransientException {
        log.debug("update: " + jobID + "," + this.toString(params));
        if (params == null || params.size() == 0) {
            return;
        }
        Job job = this.jobPersistence.get(jobID);
        this.doAuthorizationCheck(job);
        if (!ExecutionPhase.PENDING.equals((Object)job.getExecutionPhase())) {
            throw new JobPhaseException("cannot update job control details when phase=" + (Object)((Object)job.getExecutionPhase()));
        }
        this.jobPersistence.addParameters(jobID, params);
    }

    private String toString(List list) {
        if (list == null) {
            return "null";
        }
        return "List[" + list.size() + "]";
    }

    protected void doAuthorizationCheck(Job job) throws AccessControlException {
        log.debug("doAuthorizationCheck: " + job.getID() + "," + job.getOwnerID());
        if (job.ownerSubject == null) {
            return;
        }
        AccessControlContext acContext = AccessController.getContext();
        Subject caller = Subject.getSubject(acContext);
        if (caller != null) {
            Set<Principal> ownerPrincipals = job.ownerSubject.getPrincipals();
            Set<Principal> callerPrincipals = caller.getPrincipals();
            for (Principal oPrin : ownerPrincipals) {
                for (Principal cPrin : callerPrincipals) {
                    log.debug("doAuthorizationCheck: " + oPrin + " vs " + cPrin);
                    if (!AuthenticationUtil.equals(oPrin, cPrin)) continue;
                    return;
                }
            }
        }
        throw new AccessControlException("permission denied");
    }
}

