/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.auth.RunnableAction;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.server.AbstractExecutor;
import ca.nrc.cadc.uws.server.JobRunner;
import ca.nrc.cadc.uws.server.JobUpdater;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

public class ThreadPoolExecutor
extends AbstractExecutor {
    private static final Logger log = Logger.getLogger(ThreadPoolExecutor.class);
    private final Map<String, CurrentJob> currentJobs = new HashMap<String, CurrentJob>();
    private java.util.concurrent.ThreadPoolExecutor threadPool;
    private String poolName;
    private Subject poolSubject;

    public ThreadPoolExecutor(JobUpdater jobUpdater, Class jobRunnerClass, int poolSize) {
        super(jobUpdater, jobRunnerClass);
        this.init(poolSize, ThreadPoolExecutor.class.getSimpleName());
    }

    public ThreadPoolExecutor(JobUpdater jobUpdater, Class jobRunnerClass, int poolSize, String poolName) {
        super(jobUpdater, jobRunnerClass);
        this.init(poolSize, poolName);
    }

    public void terminate() throws InterruptedException {
        log.info("shutting down ThreadPool...");
        this.threadPool.shutdown();
        this.threadPool.awaitTermination(120L, TimeUnit.SECONDS);
        log.info("shutting down ThreadPool... [OK]");
    }

    private void init(int poolSize, String poolName) {
        if (poolName == null) {
            throw new IllegalArgumentException("poolName cannot be null");
        }
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be > 0");
        }
        this.poolName = poolName + "-";
        this.threadPool = new java.util.concurrent.ThreadPoolExecutor(poolSize, poolSize, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeAsync(Job job, JobRunner jobRunner) {
        AccessControlContext acContext = AccessController.getContext();
        Subject caller = Subject.getSubject(acContext);
        final CurrentJob cj = new CurrentJob(job, jobRunner, caller);
        Map<String, CurrentJob> map = this.currentJobs;
        synchronized (map) {
            this.currentJobs.put(job.getID(), cj);
        }
        cj.future = Subject.doAs(this.poolSubject, new PrivilegedAction<Future>(){

            @Override
            public Future run() {
                return ThreadPoolExecutor.this.threadPool.submit(cj);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void abortJob(String jobID) {
        Map<String, CurrentJob> map = this.currentJobs;
        synchronized (map) {
            CurrentJob r = this.currentJobs.remove(jobID);
            if (r != null) {
                if (r.future != null) {
                    r.future.cancel(true);
                }
                this.threadPool.remove(r.runnable);
            }
        }
    }

    public final class CurrentJob
    implements Runnable {
        public Job job;
        public JobRunner runnable;
        private Future future;
        private Subject subject;

        CurrentJob(Job job, JobRunner runnable, Subject subject) {
            this.job = job;
            this.runnable = runnable;
            this.subject = subject;
        }

        public int hashCode() {
            return this.job.getID().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof CurrentJob) {
                CurrentJob cj = (CurrentJob)o;
                return this.job.getID().equals(cj.job.getID());
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.subject == null) {
                this.runnable.run();
            } else {
                Subject.doAs(this.subject, new RunnableAction(this.runnable));
            }
            Map map = ThreadPoolExecutor.this.currentJobs;
            synchronized (map) {
                ThreadPoolExecutor.this.currentJobs.remove(this.job.getID());
            }
        }
    }

    private class DaemonThreadFactory
    implements ThreadFactory {
        private int num = 1;

        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(ThreadPoolExecutor.this.poolName + Integer.toString(this.num++));
            log.debug("created: " + t.getName());
            t.setDaemon(true);
            return t;
        }
    }
}

