/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.web.restlet;

import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.server.JobPhaseException;
import ca.nrc.cadc.uws.web.restlet.InvalidActionException;
import ca.nrc.cadc.uws.web.restlet.InvalidResourceException;
import java.security.AccessControlException;
import org.apache.log4j.Logger;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.service.StatusService;

public class UWSStatusService
extends StatusService {
    private static final Logger LOGGER = Logger.getLogger(UWSStatusService.class);

    public UWSStatusService(boolean enabled) {
        super(enabled);
    }

    public Status getStatus(Throwable throwable, Request request, Response response) {
        if (RuntimeException.class.equals(throwable.getClass()) && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        StringBuilder sb = new StringBuilder();
        if (throwable.getCause() != null) {
            sb.append(throwable.getCause().getMessage());
        } else {
            sb.append(throwable.getMessage());
        }
        sb.append("\n");
        response.setEntity(sb.toString(), MediaType.TEXT_PLAIN);
        if (throwable instanceof JobNotFoundException) {
            return Status.CLIENT_ERROR_NOT_FOUND;
        }
        if (throwable instanceof JobPersistenceException) {
            return Status.SERVER_ERROR_INTERNAL;
        }
        if (throwable instanceof JobPhaseException) {
            return Status.CLIENT_ERROR_BAD_REQUEST;
        }
        if (throwable instanceof AccessControlException) {
            return new Status(Status.CLIENT_ERROR_FORBIDDEN, throwable.getMessage());
        }
        if (throwable instanceof InvalidResourceException || throwable.getCause() instanceof InvalidResourceException) {
            return Status.CLIENT_ERROR_NOT_FOUND;
        }
        if (throwable instanceof InvalidActionException || throwable.getCause() instanceof InvalidActionException) {
            return Status.CLIENT_ERROR_METHOD_NOT_ALLOWED;
        }
        LOGGER.error("unexpected Throwable", throwable);
        return super.getStatus(throwable, request, response);
    }
}

