/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.web.restlet.resources;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.io.ByteLimitExceededException;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobListWriter;
import ca.nrc.cadc.uws.JobRef;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.web.restlet.RestletJobCreator;
import ca.nrc.cadc.uws.web.restlet.resources.UWSResource;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;

public class AsynchResource
extends UWSResource {
    private static final Logger LOGGER = Logger.getLogger(AsynchResource.class);
    private DateFormat dateFormat = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);

    @Post
    public void accept(final Representation entity) {
        Subject subject = this.getSubject();
        if (subject == null) {
            this.doAccept(entity);
        } else {
            Subject.doAs(subject, new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AsynchResource.this.doAccept(entity);
                    return null;
                }
            });
        }
    }

    private void doAccept(Representation entity) {
        try {
            RestletJobCreator jobCreator = new RestletJobCreator(this.getInlineContentHandler());
            Job job = jobCreator.create(entity);
            job.setRequestPath(this.getRequestPath());
            job.setRemoteIP(this.getRemoteIP());
            Job persistedJob = this.getJobManager().create(job);
            this.redirectSeeOther(this.getHostPart() + this.getRequestPath() + "/" + persistedJob.getID());
        }
        catch (ByteLimitExceededException ex) {
            String errorMessage = "XML document exceeds " + ex.getLimit() + " bytes";
            LOGGER.info("Exception caught in doAccept: " + errorMessage);
            this.generateErrorRepresentation(Status.CLIENT_ERROR_REQUEST_ENTITY_TOO_LARGE, errorMessage);
        }
        catch (TransientException t) {
            this.generateRetryRepresentation(t);
        }
        catch (Exception ex) {
            LOGGER.error("Exception caught in doAccept: " + ex);
            this.generateErrorRepresentation(Status.CLIENT_ERROR_BAD_REQUEST, ex.getMessage());
        }
    }

    protected void buildXML(final Document document) throws IOException {
        Subject subject = this.getSubject();
        if (subject == null) {
            this.doBuildXML(document);
        }
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    AsynchResource.this.doBuildXML(document);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new IOException(e.getCause());
        }
    }

    private void doBuildXML(Document document) throws IOException {
        Form query = this.getQuery();
        String[] phases = query.getValuesArray("PHASE", true);
        String after = query.getFirstValue("AFTER", true);
        String last = query.getFirstValue("LAST", true);
        try {
            Subject caller = AuthenticationUtil.getCurrentSubject();
            AuthMethod am = AuthenticationUtil.getAuthMethod(caller);
            if (am == null || AuthMethod.ANON.equals((Object)am)) {
                this.generateErrorRepresentation(Status.CLIENT_ERROR_FORBIDDEN, "anonymous job listing not permitted");
            }
            ArrayList<ExecutionPhase> phaseList = new ArrayList<ExecutionPhase>();
            for (String es : phases) {
                try {
                    phaseList.add(ExecutionPhase.toValue(es));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("invalid parameter: PHASE=" + es);
                }
            }
            String path = this.getRequestPath();
            int i = path.indexOf(47, 2);
            String appname = path.substring(0, i + 1);
            Integer lastInt = null;
            if (last != null) {
                try {
                    lastInt = Integer.parseInt(last);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("invalid parameter: LAST=" + last);
                }
            }
            Date afterDate = null;
            if (after != null) {
                try {
                    afterDate = this.dateFormat.parse(after);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("invalid parameter: AFTER=" + after);
                }
            }
            Iterator<JobRef> jobs = this.getJobManager().iterator(appname, phaseList, afterDate, lastInt);
            JobListWriter jobListWriter = new JobListWriter();
            Element root = jobListWriter.getRootElement(jobs);
            document.setRootElement(root);
        }
        catch (IllegalArgumentException ex) {
            String msg = ex.getMessage();
            LOGGER.debug(msg);
            this.generateErrorRepresentation(Status.CLIENT_ERROR_BAD_REQUEST, msg);
        }
        catch (UnsupportedOperationException e) {
            throw new AccessControlException("permission denied: " + e.getMessage());
        }
        catch (TransientException e) {
            LOGGER.error(e);
            this.generateErrorRepresentation(Status.SERVER_ERROR_SERVICE_UNAVAILABLE, "Transient error.");
        }
        catch (JobPersistenceException e) {
            LOGGER.error("persistence fail", e);
            this.generateErrorRepresentation(Status.SERVER_ERROR_INTERNAL, "Internal error.");
        }
    }
}

