/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.web.restlet.resources;

import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobAttribute;
import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.web.restlet.resources.UWSResource;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.restlet.data.Form;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;

public abstract class BaseJobResource
extends UWSResource {
    private static final Logger LOGGER = Logger.getLogger(UWSResource.class);
    protected String jobID;
    protected String jobList;
    protected Job job;
    protected String protocol;

    protected void doInit() {
        super.doInit();
        this.jobID = (String)this.getRequest().getAttributes().get("jobID");
        String path = this.getRequestPath();
        int i = path.indexOf(this.jobID);
        this.jobList = path.substring(0, i - 1);
        this.protocol = this.getProtocol().getSchemeName();
        LOGGER.debug("doInit: jobID=" + this.jobID + ", jobList=" + this.jobList + ", protocol=" + this.protocol);
    }

    @Get
    public Representation represent() {
        Subject subject = this.getSubject();
        if (subject == null) {
            return this.doRepresent();
        }
        return (Representation)Subject.doAs(subject, new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return BaseJobResource.this.doRepresent();
            }
        });
    }

    private Representation doRepresent() {
        try {
            if (this.job == null) {
                this.job = this.getJobManager().get(this.jobID);
                this.job.setProtocol(this.protocol);
            }
            return super.represent();
        }
        catch (TransientException t) {
            return this.generateRetryRepresentation(t);
        }
        catch (JobPersistenceException ex) {
            throw new RuntimeException(ex);
        }
        catch (JobNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void redirectToJobList() {
        String url = this.getHostPart() + this.jobList;
        LOGGER.debug("redirectToJobList: " + url);
        this.redirectSeeOther(url);
    }

    protected void redirectToJob() {
        String url = this.getHostPart() + this.jobList + "/" + this.jobID;
        LOGGER.debug("redirectToJob: " + url);
        this.redirectSeeOther(url);
    }

    protected boolean jobIsActive(ExecutionPhase executionPhase) {
        return executionPhase.equals((Object)ExecutionPhase.QUEUED) || executionPhase.equals((Object)ExecutionPhase.EXECUTING);
    }

    protected boolean jobHasRun(ExecutionPhase executionPhase) {
        return executionPhase.equals((Object)ExecutionPhase.COMPLETED) || executionPhase.equals((Object)ExecutionPhase.ERROR) || executionPhase.equals((Object)ExecutionPhase.ABORTED);
    }

    protected boolean jobIsPending(ExecutionPhase executionPhase) {
        return executionPhase.equals((Object)ExecutionPhase.PENDING);
    }

    protected boolean jobModificationAllowed(Form form, ExecutionPhase executionPhase) {
        String phase = form.getFirstValue(JobAttribute.EXECUTION_PHASE.getAttributeName().toUpperCase());
        return this.jobIsPending(executionPhase) || this.getRequestPath().endsWith("phase") && StringUtil.hasLength(phase) && phase.equals("ABORT");
    }
}

