/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.web.restlet.resources;

import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.web.restlet.InvalidResourceException;
import ca.nrc.cadc.uws.web.restlet.resources.BaseJobResource;
import java.io.IOException;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jdom2.Document;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;

public class ErrorResource
extends BaseJobResource {
    @Get
    public Representation represent() {
        Subject subject = this.getSubject();
        if (subject == null) {
            return this.doRepresent();
        }
        return (Representation)Subject.doAs(subject, new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return ErrorResource.this.doRepresent();
            }
        });
    }

    private Representation doRepresent() {
        try {
            this.job = this.getJobManager().get(this.jobID);
            ErrorSummary errorSummary = this.job.getErrorSummary();
            if (errorSummary == null) {
                throw new InvalidResourceException("not found: " + this.jobID + "/error");
            }
            if (errorSummary.getDocumentURL() == null) {
                String summaryMessage = errorSummary.getSummaryMessage();
                StringRepresentation representation = new StringRepresentation((CharSequence)summaryMessage);
                representation.setMediaType(MediaType.TEXT_PLAIN);
                return representation;
            }
            this.redirectSeeOther(errorSummary.getDocumentURL().toExternalForm());
            return null;
        }
        catch (TransientException t) {
            return this.generateRetryRepresentation(t);
        }
        catch (JobPersistenceException ex) {
            throw new RuntimeException(ex);
        }
        catch (JobNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void buildXML(Document document) throws IOException {
    }
}

