/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.web.restlet.resources;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.uws.server.JobManager;
import ca.nrc.cadc.uws.web.InlineContentHandler;
import ca.nrc.cadc.uws.web.restlet.RestletPrincipalExtractor;
import ca.nrc.cadc.uws.web.restlet.UWSAsyncApplication;
import ca.nrc.cadc.uws.web.restlet.WebRepresentationException;
import ca.nrc.cadc.uws.web.restlet.representation.JDOMRepresentation;
import ca.nrc.cadc.uws.web.restlet.validators.JobFormValidatorImpl;
import ca.nrc.cadc.uws.web.validators.FormValidator;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.restlet.Request;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.ServerResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UWSResource
extends ServerResource {
    private static final Logger LOGGER = Logger.getLogger(UWSResource.class);
    private static final String CERTIFICATE_REQUEST_ATTRIBUTE_NAME = "org.restlet.https.clientCertificates";
    private Subject subject;
    protected FormValidator formValidator;

    protected UWSResource() {
        LOGGER.debug("CONSTRUCTOR: " + ((Object)((Object)this)).getClass().getName());
    }

    protected void doInit() {
        super.doInit();
        Request request = this.getRequest();
        this.subject = AuthenticationUtil.getSubject(new RestletPrincipalExtractor(request));
        LOGGER.debug(this.subject);
    }

    @Get
    public Representation represent() {
        try {
            Document document = new Document();
            this.buildXML(document);
            return new JDOMRepresentation(MediaType.TEXT_XML, document);
        }
        catch (IOException e) {
            this.setExisting(false);
            LOGGER.error("Unable to create XML Document.");
            throw new WebRepresentationException("Unable to create XML Document.", e);
        }
    }

    protected void generateErrorRepresentation(Map<String, String> errors) {
        StringBuilder errorMessage = new StringBuilder(128);
        errorMessage.append("Errors found during Job Creation: \n");
        for (Map.Entry<String, String> error : errors.entrySet()) {
            errorMessage.append("\n");
            errorMessage.append(error.getKey());
            errorMessage.append(": ");
            errorMessage.append(error.getValue());
        }
        this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        this.getResponse().setEntity((Representation)new StringRepresentation((CharSequence)errorMessage.toString()));
    }

    protected void generateErrorRepresentation(Status status, String errorMsg) {
        StringBuilder sb = new StringBuilder();
        sb.append(errorMsg);
        if (!errorMsg.endsWith("\n")) {
            sb.append("\n");
        }
        this.getResponse().setStatus(status);
        this.getResponse().setEntity((Representation)new StringRepresentation((CharSequence)sb.toString()));
    }

    protected Representation generateRetryRepresentation(TransientException t) {
        StringBuilder errorMessage = new StringBuilder(128);
        errorMessage.append("Service Busy");
        this.getResponse().setStatus(Status.SERVER_ERROR_SERVICE_UNAVAILABLE);
        GregorianCalendar retryTime = new GregorianCalendar();
        LOGGER.debug("After transient exception, setting retry-after to be " + t.getRetryDelay() + " seconds.");
        ((Calendar)retryTime).add(13, t.getRetryDelay());
        this.getResponse().setRetryAfter(retryTime.getTime());
        return new StringRepresentation((CharSequence)errorMessage.toString());
    }

    protected Map<String, String> validate(Form form) {
        JobFormValidatorImpl validator = new JobFormValidatorImpl(form);
        return validator.validate();
    }

    protected abstract void buildXML(Document var1) throws IOException;

    protected String getHostPart() {
        StringBuilder elementURI = new StringBuilder(128);
        Reference ref = this.getRequest().getResourceRef();
        elementURI.append(ref.getSchemeProtocol().getSchemeName());
        elementURI.append("://");
        elementURI.append(ref.getHostDomain());
        int p = ref.getHostPort();
        if (p != -1) {
            elementURI.append(":").append(p);
        }
        return elementURI.toString();
    }

    protected String getRequestPath() {
        String path = this.getRequest().getOriginalRef().getPath().trim();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected String getRemoteIP() {
        return this.getRequest().getClientInfo().getAddress();
    }

    protected Subject getSubject() {
        return this.subject;
    }

    protected JobManager getJobManager() {
        return (JobManager)this.getContextAttribute(UWSAsyncApplication.UWS_JOB_MANAGER);
    }

    protected InlineContentHandler getInlineContentHandler() {
        InlineContentHandler handler = null;
        Class c = (Class)this.getContextAttribute(UWSAsyncApplication.UWS_INLINE_CONTENT_HANDLER);
        if (c != null) {
            try {
                handler = (InlineContentHandler)c.newInstance();
                LOGGER.debug("inline content handler: " + handler.getClass().getName());
            }
            catch (Throwable t) {
                LOGGER.error("Unable to create inline content handler ", t);
            }
        }
        return handler;
    }

    protected Object getContextAttribute(String key) {
        return this.getContext().getAttributes().get(key);
    }

    protected String getRequestAttribute(String attributeName) {
        return (String)this.getRequestAttributes().get(attributeName);
    }

    public FormValidator getFormValidator() {
        return this.formValidator;
    }

    public void setFormValidator(FormValidator formValidator) {
        this.formValidator = formValidator;
    }
}

