/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos;

import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.DataNode;
import ca.nrc.cadc.vos.LinkNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeParsingException;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.StructuredDataNode;
import ca.nrc.cadc.vos.UnstructuredDataNode;
import ca.nrc.cadc.vos.VOS;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.View;
import ca.nrc.cadc.vos.XmlProcessor;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeReader
implements XmlProcessor {
    private static final Logger log = Logger.getLogger(NodeReader.class);
    protected Map<String, String> schemaMap;
    protected Namespace xsiNamespace;

    public NodeReader() {
        this(true);
    }

    public NodeReader(boolean enableSchemaValidation) {
        if (enableSchemaValidation) {
            String vospaceSchemaUrl20 = XmlUtil.getResourceUrlString("VOSpace-2.0.xsd", NodeReader.class);
            log.debug("vospaceSchemaUrl20: " + vospaceSchemaUrl20);
            String vospaceSchemaUrl21 = XmlUtil.getResourceUrlString("VOSpace-2.1.xsd", NodeReader.class);
            log.debug("vospaceSchemaUrl21: " + vospaceSchemaUrl21);
            String xlinkSchemaUrl = XmlUtil.getResourceUrlString("XLINK.xsd", NodeReader.class);
            log.debug("xlinkSchemaUrl: " + xlinkSchemaUrl);
            if (vospaceSchemaUrl20 == null) {
                throw new RuntimeException("failed to load VOSpace-2.0.xsd from classpath");
            }
            if (vospaceSchemaUrl21 == null) {
                throw new RuntimeException("failed to load VOSpace-2.1.xsd from classpath");
            }
            if (xlinkSchemaUrl == null) {
                throw new RuntimeException("failed to load XLINK.xsd from classpath");
            }
            this.schemaMap = new HashMap<String, String>();
            this.schemaMap.put("http://www.ivoa.net/xml/VOSpace/v2.0", vospaceSchemaUrl20);
            this.schemaMap.put("http://www.ivoa.net/xml/VOSpace/v2.1", vospaceSchemaUrl21);
            this.schemaMap.put("http://www.w3.org/1999/xlink", xlinkSchemaUrl);
            log.debug("schema validation enabled");
        } else {
            log.debug("schema validation disabled");
        }
        this.xsiNamespace = Namespace.getNamespace("http://www.w3.org/2001/XMLSchema-instance");
    }

    public Node read(String xml) throws NodeParsingException {
        if (xml == null) {
            throw new IllegalArgumentException("XML must not be null");
        }
        try {
            return this.read(new StringReader(xml));
        }
        catch (IOException ioe) {
            String error = "Error reading XML: " + ioe.getMessage();
            throw new NodeParsingException(error, ioe);
        }
    }

    public Node read(InputStream in) throws IOException, NodeParsingException {
        if (in == null) {
            throw new IOException("stream closed");
        }
        try {
            return this.read(new InputStreamReader(in, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported");
        }
    }

    public Node read(Reader reader) throws NodeParsingException, IOException {
        Node ret;
        int version;
        block16: {
            Document document;
            if (reader == null) {
                throw new IllegalArgumentException("reader must not be null");
            }
            try {
                document = XmlUtil.buildDocument(reader, this.schemaMap);
            }
            catch (JDOMException jde) {
                String error = "XML failed schema validation: " + jde.getMessage();
                throw new NodeParsingException(error, jde);
            }
            Element root = document.getRootElement();
            Namespace namespace = root.getNamespace();
            if ("http://www.ivoa.net/xml/VOSpace/v2.0".equals(namespace.getURI())) {
                version = 20;
            } else if ("http://www.ivoa.net/xml/VOSpace/v2.1".equals(namespace.getURI())) {
                version = 21;
            } else {
                throw new IllegalArgumentException("unexpected VOSpace namespace: " + namespace.getURI());
            }
            log.debug("node namespace uri: " + namespace.getURI());
            log.debug("node namespace prefix: " + namespace.getPrefix());
            String uri = root.getAttributeValue("uri");
            if (uri == null) {
                String error = "uri attribute not found in root element";
                throw new NodeParsingException(error);
            }
            log.debug("node uri: " + uri);
            String xsiType = root.getAttributeValue("type", this.xsiNamespace);
            if (xsiType == null) {
                String error = "xsi:type attribute not found in node element " + uri;
                throw new NodeParsingException(error);
            }
            String[] types = xsiType.split(":");
            String type = types[1];
            log.debug("node type: " + type);
            ret = null;
            try {
                if (type.equals(ContainerNode.class.getSimpleName())) {
                    ret = this.buildContainerNode(root, namespace, uri);
                    break block16;
                }
                if (type.equals(DataNode.class.getSimpleName())) {
                    ret = this.buildDataNode(root, namespace, uri);
                    break block16;
                }
                if (type.equals(UnstructuredDataNode.class.getSimpleName())) {
                    ret = this.buildUnstructuredDataNode(root, namespace, uri);
                    break block16;
                }
                if (type.equals(LinkNode.class.getSimpleName())) {
                    ret = this.buildLinkNode(root, namespace, uri);
                    break block16;
                }
                if (type.equals(StructuredDataNode.class.getSimpleName())) {
                    ret = this.buildStructuredDataNode(root, namespace, uri);
                    break block16;
                }
                throw new NodeParsingException("unsupported node type " + type);
            }
            catch (URISyntaxException e) {
                throw new NodeParsingException("invalid uri in xml: " + e.getMessage());
            }
        }
        ret.version = version;
        return ret;
    }

    protected Node buildLinkNode(Element el, Namespace namespace, String uri) throws NodeParsingException, URISyntaxException {
        LinkNode node;
        VOSURI vosuri;
        Element target = el.getChild("target", namespace);
        if (target == null) {
            String error = "target element not found in node element";
            throw new NodeParsingException(error);
        }
        log.debug("node target: " + target.getText());
        try {
            vosuri = new VOSURI(uri);
        }
        catch (URISyntaxException e) {
            String error = "invalid node uri " + uri;
            throw new NodeParsingException(error, e);
        }
        try {
            node = new LinkNode(vosuri, new URI(target.getText()));
        }
        catch (URISyntaxException e) {
            String error = "invalid node target " + target.getText();
            throw new NodeParsingException(error, e);
        }
        node.setProperties(this.getProperties(el, namespace));
        return node;
    }

    protected Node buildContainerNode(Element el, Namespace namespace, String uri) throws NodeParsingException, URISyntaxException {
        ContainerNode node;
        try {
            node = new ContainerNode(new VOSURI(uri));
        }
        catch (URISyntaxException e) {
            String error = "invalid node uri " + uri;
            throw new NodeParsingException(error, e);
        }
        node.setProperties(this.getProperties(el, namespace));
        Element nodes = el.getChild("nodes", namespace);
        if (nodes == null) {
            String error = "nodes element not found in node";
            throw new NodeParsingException(error);
        }
        List<Element> nodesList = nodes.getChildren("node", namespace);
        for (Element childNode : nodesList) {
            String childNodeUri = childNode.getAttributeValue("uri");
            if (childNodeUri == null) {
                String error = "uri attribute not found in nodes node element";
                throw new NodeParsingException(error);
            }
            String xsiType = childNode.getAttributeValue("type", this.xsiNamespace);
            if (xsiType == null) {
                String error = "xsi:type attribute not found in node element " + uri;
                throw new NodeParsingException(error);
            }
            String[] types = xsiType.split(":");
            String type = types[1];
            log.debug("node type: " + type);
            if (type.equals(ContainerNode.class.getSimpleName())) {
                node.getNodes().add(this.buildContainerNode(childNode, namespace, childNodeUri));
            } else if (type.equals(DataNode.class.getSimpleName())) {
                node.getNodes().add(this.buildDataNode(childNode, namespace, childNodeUri));
            } else if (type.equals(LinkNode.class.getSimpleName())) {
                node.getNodes().add(this.buildLinkNode(childNode, namespace, childNodeUri));
            } else {
                throw new NodeParsingException("unsupported node type " + type);
            }
            log.debug("added child node: " + childNodeUri);
        }
        return node;
    }

    protected void setDataNodeAttributes(DataNode node, Element el, Namespace namespace) throws NodeParsingException, URISyntaxException {
        boolean isBusy;
        String busy = el.getAttributeValue("busy");
        if (busy == null) {
            String error = "busy element not found in DataNode";
            throw new NodeParsingException(error);
        }
        boolean bl = isBusy = busy.equalsIgnoreCase("true");
        if (isBusy) {
            node.setBusy(VOS.NodeBusyState.busyWithWrite);
        } else {
            node.setBusy(VOS.NodeBusyState.notBusy);
        }
        log.debug("busy: " + isBusy);
        node.setProperties(this.getProperties(el, namespace));
        node.accepts().addAll(this.getViewURIs(el, namespace, "accepts"));
        node.provides().addAll(this.getViewURIs(el, namespace, "provides"));
    }

    protected Node buildDataNode(Element el, Namespace namespace, String uri) throws NodeParsingException, URISyntaxException {
        DataNode node;
        try {
            node = new DataNode(new VOSURI(uri));
        }
        catch (URISyntaxException e) {
            String error = "invalid node uri " + uri;
            throw new NodeParsingException(error, e);
        }
        this.setDataNodeAttributes(node, el, namespace);
        return node;
    }

    protected Node buildUnstructuredDataNode(Element el, Namespace namespace, String uri) throws NodeParsingException, URISyntaxException {
        UnstructuredDataNode node;
        try {
            node = new UnstructuredDataNode(new VOSURI(uri));
        }
        catch (URISyntaxException e) {
            String error = "invalid node uri " + uri;
            throw new NodeParsingException(error, e);
        }
        this.setDataNodeAttributes(node, el, namespace);
        return node;
    }

    protected Node buildStructuredDataNode(Element el, Namespace namespace, String uri) throws NodeParsingException, URISyntaxException {
        StructuredDataNode node;
        try {
            node = new StructuredDataNode(new VOSURI(uri));
        }
        catch (URISyntaxException e) {
            String error = "invalid node uri " + uri;
            throw new NodeParsingException(error, e);
        }
        this.setDataNodeAttributes(node, el, namespace);
        return node;
    }

    protected List<NodeProperty> getProperties(Element el, Namespace namespace) throws NodeParsingException {
        Element properties = el.getChild("properties", namespace);
        if (properties == null) {
            String error = "properties element not found";
            throw new NodeParsingException(error);
        }
        ArrayList<NodeProperty> set = new ArrayList<NodeProperty>();
        List<Element> propertyList = properties.getChildren("property", namespace);
        for (Element property : propertyList) {
            String propertyUri = property.getAttributeValue("uri");
            if (propertyUri == null) {
                String error = "uri attribute not found in property element " + property;
                throw new NodeParsingException(error);
            }
            String xsiNil = property.getAttributeValue("nil", this.xsiNamespace);
            boolean markedForDeletion = false;
            if (xsiNil != null) {
                markedForDeletion = xsiNil.equalsIgnoreCase("true");
            }
            String text = property.getText();
            if (markedForDeletion) {
                text = "";
            }
            NodeProperty nodeProperty = new NodeProperty(propertyUri, text);
            String readOnly = property.getAttributeValue("readOnly");
            if (readOnly != null) {
                nodeProperty.setReadOnly(readOnly.equalsIgnoreCase("true"));
            }
            nodeProperty.setMarkedForDeletion(markedForDeletion);
            set.add(nodeProperty);
        }
        return set;
    }

    protected List<URI> getViewURIs(Element root, Namespace namespace, String parent) throws NodeParsingException, URISyntaxException {
        ArrayList<URI> list = new ArrayList<URI>();
        Element parentElement = root.getChild(parent, namespace);
        if (parentElement == null) {
            return list;
        }
        List<Element> uriList = parentElement.getChildren("view", namespace);
        for (Element view : uriList) {
            String viewUri = view.getAttributeValue("uri");
            if (viewUri == null) {
                String error = "uri attribute not found in " + parent + " view element";
                throw new NodeParsingException(error);
            }
            log.debug(parent + "view uri: " + viewUri);
            list.add(new URI(viewUri));
        }
        return list;
    }

    protected List<View> getViews(Element root, Namespace namespace, String parent) throws NodeParsingException {
        Element parentElement = root.getChild(parent, namespace);
        if (parentElement == null) {
            String error = parent + " element not found in node";
            throw new NodeParsingException(error);
        }
        ArrayList<View> list = new ArrayList<View>();
        List<Element> viewList = parentElement.getChildren("view", namespace);
        for (Element view : viewList) {
            String viewUri = view.getAttributeValue("uri");
            if (viewUri == null) {
                String error = "uri attribute not found in " + parent + " view element";
                throw new NodeParsingException(error);
            }
            log.debug(parent + "view uri: " + viewUri);
            String original = view.getAttributeValue("original");
            if (original != null) {
                boolean isOriginal = original.equalsIgnoreCase("true");
                log.debug(parent + " view original: " + isOriginal);
            }
            List<Element> paramList = view.getChildren("param", namespace);
            for (Element param : paramList) {
                String paramUri = param.getAttributeValue("uri");
                if (paramUri == null) {
                    String error = "param uri attribute not found in accepts view element";
                    throw new NodeParsingException(error);
                }
                log.debug("accepts view param uri: " + paramUri);
            }
        }
        return list;
    }
}

