/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos;

import ca.nrc.cadc.util.StringBuilderWriter;
import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.DataNode;
import ca.nrc.cadc.vos.LinkNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.StructuredDataNode;
import ca.nrc.cadc.vos.UnstructuredDataNode;
import ca.nrc.cadc.vos.VOS;
import ca.nrc.cadc.vos.XmlProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class NodeWriter
implements XmlProcessor {
    protected static Namespace xsiNamespace = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static Logger log = Logger.getLogger(NodeWriter.class);
    private String stylesheetURL = null;
    private Namespace vosNamespace;

    public NodeWriter() {
        this("http://www.ivoa.net/xml/VOSpace/v2.0");
    }

    public NodeWriter(String vospaceNamespace) {
        this.vosNamespace = Namespace.getNamespace("vos", vospaceNamespace);
    }

    public void setStylesheetURL(String stylesheetURL) {
        this.stylesheetURL = stylesheetURL;
    }

    public String getStylesheetURL() {
        return this.stylesheetURL;
    }

    public void write(Node node, OutputStream out) throws IOException {
        OutputStreamWriter outWriter;
        try {
            outWriter = new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported", e);
        }
        this.write(node, (Writer)outWriter);
    }

    public void write(Node node, StringBuilder builder) throws IOException {
        this.write(node, (Writer)new StringBuilderWriter(builder));
    }

    public void write(Node node, Writer writer) throws IOException {
        long start = System.currentTimeMillis();
        Element root = this.getRootElement(node);
        this.write(root, writer);
        long end = System.currentTimeMillis();
        log.debug("Write elapsed time: " + (end - start) + "ms");
    }

    protected Element getRootElement(Node node) {
        Element root = this.getNodeElement(node);
        root.addNamespaceDeclaration(xsiNamespace);
        return root;
    }

    protected Element getNodeElement(Node node) {
        Element ret = new Element("node", this.vosNamespace);
        ret.setAttribute("uri", node.getUri().toString());
        ret.setAttribute("type", this.vosNamespace.getPrefix() + ":" + node.getClass().getSimpleName(), xsiNamespace);
        Element props = this.getPropertiesElement(node);
        ret.addContent(props);
        if (node instanceof ContainerNode) {
            ContainerNode cn = (ContainerNode)node;
            ret.addContent(this.getNodesElement(cn));
        } else if (node instanceof DataNode || node instanceof UnstructuredDataNode || node instanceof StructuredDataNode) {
            ret.addContent(this.getAcceptsElement(node));
            ret.addContent(this.getProvidesElement(node));
            DataNode dn = (DataNode)node;
            ret.setAttribute("busy", dn.getBusy().equals((Object)VOS.NodeBusyState.notBusy) ? "false" : "true");
        } else if (node instanceof LinkNode) {
            LinkNode ln = (LinkNode)node;
            Element targetEl = new Element("target", this.vosNamespace);
            targetEl.setText(ln.getTarget().toString());
            ret.addContent(targetEl);
        }
        return ret;
    }

    protected Element getPropertiesElement(Node node) {
        Element ret = new Element("properties", this.vosNamespace);
        for (NodeProperty nodeProperty : node.getProperties()) {
            Element property = new Element("property", this.vosNamespace);
            if (nodeProperty.isMarkedForDeletion()) {
                property.setAttribute(new Attribute("nil", "true", xsiNamespace));
            } else {
                property.setText(nodeProperty.getPropertyValue());
            }
            property.setAttribute("uri", nodeProperty.getPropertyURI());
            property.setAttribute("readOnly", nodeProperty.isReadOnly() ? "true" : "false");
            ret.addContent(property);
        }
        return ret;
    }

    protected Element getAcceptsElement(Node node) {
        Element accepts = new Element("accepts", this.vosNamespace);
        for (URI viewURI : node.accepts()) {
            Element viewElement = new Element("view", this.vosNamespace);
            viewElement.setAttribute("uri", viewURI.toString());
            accepts.addContent(viewElement);
        }
        return accepts;
    }

    protected Element getProvidesElement(Node node) {
        Element provides = new Element("provides", this.vosNamespace);
        for (URI viewURI : node.provides()) {
            Element viewElement = new Element("view", this.vosNamespace);
            viewElement.setAttribute("uri", viewURI.toString());
            provides.addContent(viewElement);
        }
        return provides;
    }

    protected Element getNodesElement(ContainerNode node) {
        Element nodes = new Element("nodes", this.vosNamespace);
        for (Node childNode : node.getNodes()) {
            Element nodeElement = this.getNodeElement(childNode);
            nodes.addContent(nodeElement);
        }
        return nodes;
    }

    protected void write(Element root, Writer writer) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document(root);
        if (this.stylesheetURL != null) {
            HashMap<String, String> instructionMap = new HashMap<String, String>(2);
            instructionMap.put("type", "text/xsl");
            instructionMap.put("href", this.stylesheetURL);
            ProcessingInstruction pi = new ProcessingInstruction("xml-stylesheet", instructionMap);
            document.getContent().add(0, pi);
        }
        outputter.output(document, writer);
    }
}

