/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.client;

import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.net.HttpDownload;
import ca.nrc.cadc.net.HttpRequestProperty;
import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.HttpUpload;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.net.OutputStreamWrapper;
import ca.nrc.cadc.net.event.TransferListener;
import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.uws.ErrorSummary;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobReader;
import ca.nrc.cadc.vos.Direction;
import ca.nrc.cadc.vos.Transfer;
import ca.nrc.cadc.vos.client.ClientRecursiveSetNode;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientTransfer
implements Runnable {
    private static Logger log = Logger.getLogger(ClientTransfer.class);
    private static final long POLL_INTERVAL = 100L;
    private SSLSocketFactory sslSocketFactory;
    private URL jobURL;
    private Transfer transfer;
    private boolean monitorAsync;
    private boolean schemaValidation;
    private File localFile;
    private OutputStreamWrapper wrapper;
    private List<HttpRequestProperty> httpRequestProperties;
    private int maxRetries;
    private TransferListener transListener;
    private Throwable throwable;
    private ExecutionPhase phase;
    private ErrorSummary error;

    private ClientTransfer() {
    }

    ClientTransfer(URL jobURL, Transfer transfer, boolean schemaValidation) {
        this.httpRequestProperties = new ArrayList<HttpRequestProperty>();
        this.jobURL = jobURL;
        this.transfer = transfer;
        this.monitorAsync = false;
        this.schemaValidation = schemaValidation;
    }

    public URL getJobURL() {
        return this.jobURL;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public ExecutionPhase getPhase() throws IOException {
        if (this.phase != null) {
            return this.phase;
        }
        Job job = this.getJob();
        ExecutionPhase ep = job.getExecutionPhase();
        if (ExecutionPhase.ABORTED.equals((Object)ep) || ExecutionPhase.COMPLETED.equals((Object)ep) || ExecutionPhase.ERROR.equals((Object)ep)) {
            this.phase = ep;
        }
        return ep;
    }

    public ErrorSummary getServerError() throws IOException {
        if (this.error != null) {
            return this.error;
        }
        Job job = this.getJob();
        this.error = job.getErrorSummary();
        return this.error;
    }

    private Job getJob() throws IOException {
        if (this.transfer.isQuickTransfer()) {
            throw new IllegalStateException("No job information available for quick transfers");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpDownload get = new HttpDownload(this.jobURL, out);
            this.runHttpTransfer(get);
            if (get.getThrowable() != null) {
                throw new RuntimeException("Unable to get Job because " + get.getThrowable().getLocalizedMessage());
            }
            JobReader jobReader = null;
            if (this.schemaValidation) {
                HashMap<String, String> extraSchemas = new HashMap<String, String>();
                String xsdFile = XmlUtil.getResourceUrlString("VOSpace-2.0.xsd", ClientRecursiveSetNode.class);
                extraSchemas.put("http://www.ivoa.net/xml/VOSpace/v2.0", xsdFile);
                xsdFile = XmlUtil.getResourceUrlString("VOSpace-2.1.xsd", ClientRecursiveSetNode.class);
                extraSchemas.put("http://www.ivoa.net/xml/VOSpace/v2.1", xsdFile);
                jobReader = new JobReader(extraSchemas);
            } else {
                jobReader = new JobReader(false);
            }
            return jobReader.read(new StringReader(new String(out.toByteArray(), "UTF-8")));
        }
        catch (ParseException ex) {
            throw new RuntimeException("failed to parse job from " + this.jobURL, ex);
        }
        catch (JDOMException ex) {
            throw new RuntimeException("failed to parse job from " + this.jobURL, ex);
        }
        catch (MalformedURLException bug) {
            throw new RuntimeException("BUG: failed to create error url", bug);
        }
    }

    public void setFile(File file) {
        if (Direction.pullFromVoSpace.equals(this.transfer.getDirection()) || Direction.pushToVoSpace.equals(this.transfer.getDirection())) {
            this.localFile = file;
            return;
        }
        throw new IllegalStateException("cannot specify a local File for transfer direction " + this.transfer.getDirection());
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setOutputStreamWrapper(OutputStreamWrapper wrapper) {
        if (Direction.pushToVoSpace.equals(this.transfer.getDirection())) {
            this.wrapper = wrapper;
            return;
        }
        throw new IllegalStateException("cannot specify an OutputStreamWrapper for transfer direction " + this.transfer.getDirection());
    }

    public void setTransferListener(TransferListener transListener) {
        this.transListener = transListener;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRequestProperty(String header, String value) {
        this.httpRequestProperties.add(new HttpRequestProperty(header, value));
    }

    public void setMonitor(boolean enabled) {
        this.monitorAsync = enabled;
    }

    @Override
    public void run() {
        log.debug("start: " + this.transfer);
        try {
            this.runTransfer();
        }
        catch (Throwable t) {
            this.throwable = t;
        }
        log.debug("done: " + this.transfer);
    }

    public void runTransfer() throws IOException, InterruptedException, RuntimeException {
        try {
            if (Direction.pullFromVoSpace.equals(this.transfer.getDirection())) {
                this.checkProtocols();
                this.doDownload();
            } else if (Direction.pushToVoSpace.equals(this.transfer.getDirection())) {
                this.checkProtocols();
                this.doUpload();
            } else {
                this.doServerTransfer();
            }
        }
        catch (JDOMException ex) {
            throw new RuntimeException("failed to parse transfer document", ex);
        }
        catch (ParseException ex) {
            throw new RuntimeException("failed to parse transfer document", ex);
        }
    }

    private void checkProtocols() throws IOException, JDOMException, ParseException {
        if (this.transfer.getProtocols() == null || this.transfer.getProtocols().size() == 0) {
            log.debug("Found zero protocols in returned transfer, checking job for error details.");
            Job job = this.getJob();
            if (job.getExecutionPhase().equals((Object)ExecutionPhase.ERROR) && job.getErrorSummary() != null) {
                throw new RuntimeException("Transfer Failure: " + job.getErrorSummary().getSummaryMessage());
            }
            throw new IllegalStateException("Job with no protocol endpoints received for job " + job.getID());
        }
    }

    private List<URL> findGetEndpoint() throws MalformedURLException {
        List<String> ret = this.transfer.getAllEndpoints();
        if (ret.isEmpty()) {
            throw new RuntimeException("failed to find a usable endpoint URL");
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String urlStr : ret) {
            urls.add(new URL(urlStr));
        }
        return urls;
    }

    private URL findPutEndpoint() throws MalformedURLException {
        String ret = this.transfer.getEndpoint();
        if (ret == null) {
            throw new RuntimeException("failed to find a usable endpoint URL");
        }
        return new URL(ret);
    }

    private void doUpload() throws IOException {
        URL url = this.findPutEndpoint();
        log.debug(url);
        if (this.localFile == null && this.wrapper == null) {
            throw new IllegalStateException("cannot perform upload without a File or OutputStreamWrapper");
        }
        HttpUpload upload = null;
        upload = this.localFile != null ? new HttpUpload(this.localFile, url) : new HttpUpload(this.wrapper, url);
        log.debug("calling HttpUpload.setRequestProperties with " + this.httpRequestProperties.size() + " props");
        upload.setRequestProperties(this.httpRequestProperties);
        upload.setMaxRetries(this.maxRetries);
        if (this.transListener != null) {
            upload.setTransferListener(this.transListener);
        }
        this.runHttpTransfer(upload);
        if (upload.getThrowable() != null) {
            if (upload.getThrowable() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)upload.getThrowable();
            }
            try {
                throw new IOException("failed to upload file", upload.getThrowable());
            }
            catch (NoSuchMethodError e) {
                throw new IOException("failed to upload file: " + upload.getThrowable().getMessage());
            }
        }
    }

    private void doDownload() throws IOException, MalformedURLException {
        List<URL> urls = this.findGetEndpoint();
        if (urls.size() == 0) {
            throw new IllegalArgumentException("No endpoint found");
        }
        HttpTransfer firstDownload = null;
        if (this.localFile == null) {
            throw new IllegalStateException("cannot perform download without a local File");
        }
        for (URL url : urls) {
            log.debug(url);
            HttpDownload download = new HttpDownload(url, this.localFile);
            if (firstDownload == null) {
                firstDownload = download;
            }
            download.setOverwrite(true);
            download.setRequestProperties(this.httpRequestProperties);
            download.setMaxRetries(this.maxRetries);
            if (this.transListener != null) {
                download.setTransferListener(this.transListener);
            }
            this.runHttpTransfer(download);
            if (download.getThrowable() != null) continue;
            this.localFile = download.getFile();
            return;
        }
        throw new IOException("failed to download file", firstDownload.getThrowable());
    }

    private void doServerTransfer() throws IOException, InterruptedException {
        try {
            URL phaseURL = new URL(this.jobURL.toExternalForm() + "/phase");
            String parameters = "PHASE=RUN";
            HttpURLConnection connection = (HttpURLConnection)phaseURL.openConnection();
            if (connection instanceof HttpsURLConnection) {
                this.initHTTPS((HttpsURLConnection)connection);
            }
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Length", "" + Integer.toString(parameters.getBytes().length));
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setInstanceFollowRedirects(false);
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(parameters.getBytes("UTF-8"));
            outputStream.close();
            int responseCode = connection.getResponseCode();
            String responseMessage = connection.getResponseMessage();
            String errorBody = NetUtil.getErrorBody(connection);
            if (StringUtil.hasText(errorBody)) {
                responseMessage = responseMessage + ": " + errorBody;
            }
            switch (responseCode) {
                case 200: 
                case 303: {
                    break;
                }
                case 500: {
                    throw new RuntimeException(responseMessage);
                }
                case 401: {
                    throw new AccessControlException(responseMessage);
                }
                case 404: {
                    throw new IllegalArgumentException(responseMessage);
                }
                default: {
                    throw new RuntimeException("unexpected failure mode: " + responseMessage + "(" + responseCode + ")");
                }
            }
            if (this.monitorAsync) {
                while (this.phase == null) {
                    Thread.sleep(100L);
                    this.getPhase();
                }
            }
        }
        catch (MalformedURLException bug) {
            throw new RuntimeException("BUG: failed to create phase url", bug);
        }
    }

    protected void runHttpTransfer(HttpTransfer transfer) {
        if (this.sslSocketFactory != null) {
            transfer.setSSLSocketFactory(this.sslSocketFactory);
        }
        transfer.run();
        if (transfer.getSSLSocketFactory() != null) {
            this.sslSocketFactory = transfer.getSSLSocketFactory();
        }
    }

    private void initHTTPS(HttpsURLConnection sslConn) {
        if (this.sslSocketFactory == null) {
            log.debug("initHTTPS: lazy init");
            AccessControlContext ac = AccessController.getContext();
            Subject s = Subject.getSubject(ac);
            this.sslSocketFactory = SSLUtil.getSocketFactory(s);
        }
        if (this.sslSocketFactory != null && sslConn != null) {
            log.debug("setting SSLSocketFactory on " + sslConn.getClass().getName());
            sslConn.setSSLSocketFactory(this.sslSocketFactory);
        }
    }
}

