/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server;

import ca.nrc.cadc.auth.IdentityManager;
import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.db.DBUtil;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.profiler.Profiler;
import ca.nrc.cadc.util.CaseInsensitiveStringComparator;
import ca.nrc.cadc.util.FileMetadata;
import ca.nrc.cadc.util.HexUtil;
import ca.nrc.cadc.util.Log4jInit;
import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.DataNode;
import ca.nrc.cadc.vos.LinkNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.VOS;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.server.NodeID;
import ca.nrc.cadc.vos.server.NodeMapper;
import ca.nrc.cadc.vos.server.NodePropertyMapper;
import ca.nrc.cadc.vos.server.NodeSizePropagation;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDAO {
    private static Logger log = Logger.getLogger(NodeDAO.class);
    private static final int CHILD_BATCH_SIZE = 1000;
    static final String NODE_TYPE_DATA = "D";
    static final String NODE_TYPE_CONTAINER = "C";
    static final String NODE_TYPE_LINK = "L";
    private static final int NODE_NAME_COLUMN_SIZE = 256;
    private static final int NODE_PROPERTY_COLUMN_SIZE = 700;
    protected DataSource dataSource;
    protected NodeSchema nodeSchema;
    protected String authority;
    protected IdentityManager identManager;
    protected String deletedNodePath;
    protected JdbcTemplate jdbc;
    private DataSourceTransactionManager transactionManager;
    private DefaultTransactionDefinition defaultTransactionDef;
    private DefaultTransactionDefinition dirtyReadTransactionDef;
    private TransactionStatus transactionStatus;
    private NodePutStatementCreator adminStatementCreator;
    int numTxnStarted = 0;
    int numTxnCommitted = 0;
    private DateFormat dateFormat;
    private Calendar cal;
    private Map<Object, Subject> identityCache = new HashMap<Object, Subject>();
    private Profiler prof = new Profiler(NodeDAO.class);
    private static String[] NODE_COLUMNS;
    private static Set<String> coreProps;

    public NodeDAO(DataSource dataSource, NodeSchema nodeSchema, String authority, IdentityManager identManager, String deletedNodePath) {
        this.dataSource = dataSource;
        this.nodeSchema = nodeSchema;
        this.authority = authority;
        this.identManager = identManager;
        this.deletedNodePath = deletedNodePath;
        this.defaultTransactionDef = new DefaultTransactionDefinition();
        this.defaultTransactionDef.setIsolationLevel(4);
        this.dirtyReadTransactionDef = new DefaultTransactionDefinition();
        this.dirtyReadTransactionDef.setIsolationLevel(1);
        this.jdbc = new JdbcTemplate(dataSource);
        this.transactionManager = new DataSourceTransactionManager(dataSource);
        this.dateFormat = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
        this.cal = Calendar.getInstance(DateUtil.UTC);
    }

    protected String getNodeTableName() {
        return this.nodeSchema.nodeTable;
    }

    protected String getNodePropertyTableName() {
        return this.nodeSchema.propertyTable;
    }

    protected void startTransaction() {
        if (this.transactionStatus != null) {
            throw new IllegalStateException("transaction already in progress");
        }
        log.debug("startTransaction");
        this.transactionStatus = this.transactionManager.getTransaction(this.defaultTransactionDef);
        log.debug("startTransaction: OK");
        ++this.numTxnStarted;
    }

    protected void commitTransaction() {
        if (this.transactionStatus == null) {
            throw new IllegalStateException("no transaction in progress");
        }
        log.debug("commitTransaction");
        this.transactionManager.commit(this.transactionStatus);
        this.transactionStatus = null;
        log.debug("commit: OK");
        ++this.numTxnCommitted;
    }

    protected void rollbackTransaction() {
        if (this.transactionStatus == null) {
            throw new IllegalStateException("no transaction in progress");
        }
        log.debug("rollbackTransaction");
        this.transactionManager.rollback(this.transactionStatus);
        this.transactionStatus = null;
        log.debug("rollback: OK");
    }

    protected void expectPersistentNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        if (node.appData == null) {
            throw new IllegalArgumentException("node is not a persistent node: " + node.getUri().getPath());
        }
    }

    public Node getPath(String path) throws TransientException {
        log.debug("SB: PATH I am searching: " + path);
        return this.getPath(path, false);
    }

    public Node getPath(String path, boolean allowPartialPath) throws TransientException {
        log.debug("getPath: " + path);
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        NodePathStatementCreator npsc = new NodePathStatementCreator(path.split("/"), this.getNodeTableName(), this.getNodePropertyTableName(), allowPartialPath);
        TransactionStatus dirtyRead = null;
        try {
            dirtyRead = this.transactionManager.getTransaction(this.dirtyReadTransactionDef);
            this.prof.checkpoint("TransactionManager.getTransaction");
            Node ret = (Node)this.jdbc.query((PreparedStatementCreator)npsc, (ResultSetExtractor)new NodePathExtractor());
            this.prof.checkpoint("NodePathStatementCreator");
            this.transactionManager.commit(dirtyRead);
            dirtyRead = null;
            this.prof.checkpoint("commit.NodePathStatementCreator");
            this.loadSubjects(ret);
            Node node = ret;
            return node;
        }
        catch (CannotCreateTransactionException ex) {
            log.error("failed to create transaction: " + path, ex);
            dirtyRead = null;
            if (DBUtil.isTransientDBException(ex)) {
                throw new TransientException("failed to get node: " + path, ex);
            }
            throw new RuntimeException("failed to get node: " + path, ex);
        }
        catch (Throwable t) {
            if (dirtyRead != null) {
                try {
                    log.error("rollback dirtyRead for node: " + path, t);
                    this.transactionManager.rollback(dirtyRead);
                    dirtyRead = null;
                    this.prof.checkpoint("rollback.NodePathStatementCreator");
                }
                catch (Throwable oops) {
                    log.error("failed to dirtyRead rollback transaction", oops);
                }
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to get node " + path, t);
            }
            throw new RuntimeException("failed to get node: " + path, t);
        }
        finally {
            if (dirtyRead != null) {
                try {
                    log.warn("put: BUG - dirtyRead transaction still open in finally... calling rollback");
                    this.transactionManager.rollback(dirtyRead);
                }
                catch (Throwable oops) {
                    log.error("failed to rollback dirtyRead transaction in finally", oops);
                }
            }
        }
    }

    public void getProperties(Node node) throws TransientException {
        log.debug("getProperties: " + node.getUri().getPath() + ", " + node.getClass().getSimpleName());
        this.expectPersistentNode(node);
        log.debug("getProperties: " + node.getUri().getPath() + ", " + node.getClass().getSimpleName());
        String sql = this.getSelectNodePropertiesByID(node);
        log.debug("getProperties: " + sql);
        TransactionStatus dirtyRead = null;
        try {
            dirtyRead = this.transactionManager.getTransaction(this.dirtyReadTransactionDef);
            this.prof.checkpoint("TransactionManager.getTransaction");
            List props = this.jdbc.query(sql, (RowMapper)new NodePropertyMapper());
            node.getProperties().addAll(props);
            this.prof.checkpoint("getProperties");
            this.transactionManager.commit(dirtyRead);
            dirtyRead = null;
            this.prof.checkpoint("commit.getProperties");
        }
        catch (CannotCreateTransactionException ex) {
            log.error("failed to create transaction: " + node.getUri().getPath(), ex);
            dirtyRead = null;
            if (DBUtil.isTransientDBException(ex)) {
                throw new TransientException("failed to get node: " + node.getUri().getPath(), ex);
            }
            throw new RuntimeException("failed to get node: " + node.getUri().getPath(), ex);
        }
        catch (Throwable t) {
            log.error("rollback dirtyRead for node: " + node.getUri().getPath(), t);
            try {
                this.transactionManager.rollback(dirtyRead);
                dirtyRead = null;
                this.prof.checkpoint("rollback.getProperties");
            }
            catch (Throwable oops) {
                log.error("failed to dirtyRead rollback transaction", oops);
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to get node: " + node.getUri().getPath(), t);
            }
            throw new RuntimeException("failed to get node: " + node.getUri().getPath(), t);
        }
        finally {
            if (dirtyRead != null) {
                try {
                    log.warn("put: BUG - dirtyRead transaction still open in finally... calling rollback");
                    this.transactionManager.rollback(dirtyRead);
                }
                catch (Throwable oops) {
                    log.error("failed to rollback dirtyRead transaction in finally", oops);
                }
            }
        }
    }

    public void getChild(ContainerNode parent, String name) throws TransientException {
        log.debug("getChild: " + parent.getUri().getPath() + ", " + name);
        this.expectPersistentNode(parent);
        String sql = this.getSelectChildNodeSQL(parent);
        log.debug("getChild: " + sql);
        TransactionStatus dirtyRead = null;
        try {
            dirtyRead = this.transactionManager.getTransaction(this.dirtyReadTransactionDef);
            this.prof.checkpoint("TransactionManager.getTransaction");
            List nodes = this.jdbc.query(sql, new Object[]{name}, (RowMapper)new NodeMapper(this.authority, parent.getUri().getPath()));
            this.prof.checkpoint("getSelectChildNodeSQL");
            this.transactionManager.commit(dirtyRead);
            dirtyRead = null;
            this.prof.checkpoint("commit.getSelectChildNodeSQL");
            if (nodes.size() > 1) {
                throw new IllegalStateException("BUG - found " + nodes.size() + " child nodes named " + name + " for container " + parent.getUri().getPath());
            }
            this.loadSubjects(nodes);
            this.addChildNodes(parent, nodes);
        }
        catch (CannotCreateTransactionException ex) {
            log.error("failed to create transaction: " + parent.getUri().getPath(), ex);
            if (DBUtil.isTransientDBException(ex)) {
                throw new TransientException("failed to get node: " + parent.getUri().getPath(), ex);
            }
            throw new RuntimeException("failed to get node: " + parent.getUri().getPath(), ex);
        }
        catch (Throwable t) {
            log.error("rollback dirtyRead for node: " + parent.getUri().getPath(), t);
            try {
                this.transactionManager.rollback(dirtyRead);
                dirtyRead = null;
                this.prof.checkpoint("rollback.getSelectChildNodeSQL");
            }
            catch (Throwable oops) {
                log.error("failed to dirtyRead rollback transaction", oops);
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to get node: " + parent.getUri().getPath(), t);
            }
            throw new RuntimeException("failed to get node: " + parent.getUri().getPath(), t);
        }
        finally {
            if (dirtyRead != null) {
                try {
                    log.warn("put: BUG - dirtyRead transaction still open in finally... calling rollback");
                    this.transactionManager.rollback(dirtyRead);
                }
                catch (Throwable oops) {
                    log.error("failed to rollback dirtyRead transaction in finally", oops);
                }
            }
        }
    }

    public void getChildren(ContainerNode parent) throws TransientException {
        log.debug("getChildren: " + parent.getUri().getPath() + ", " + parent.getClass().getSimpleName());
        this.getChildren(parent, null, null);
    }

    public void getChildren(ContainerNode parent, VOSURI start, Integer limit) throws TransientException {
        log.debug("getChildren: " + parent.getUri().getPath() + ", " + parent.getClass().getSimpleName());
        this.expectPersistentNode(parent);
        Object[] args = null;
        args = start != null ? new Object[]{start.getName()} : new Object[]{};
        String sql = this.getSelectNodesByParentSQL(parent, limit, start != null);
        log.debug("getChildren: " + sql);
        TransactionStatus dirtyRead = null;
        try {
            dirtyRead = this.transactionManager.getTransaction(this.dirtyReadTransactionDef);
            this.prof.checkpoint("TransactionManager.getTransaction");
            List nodes = this.jdbc.query(sql, args, (RowMapper)new NodeMapper(this.authority, parent.getUri().getPath()));
            this.prof.checkpoint("getSelectNodesByParentSQL");
            this.transactionManager.commit(dirtyRead);
            dirtyRead = null;
            this.prof.checkpoint("commit.getSelectNodesByParentSQL");
            this.loadSubjects(nodes);
            this.addChildNodes(parent, nodes);
        }
        catch (CannotCreateTransactionException ex) {
            log.error("failed to create transaction: " + parent.getUri().getPath(), ex);
            if (DBUtil.isTransientDBException(ex)) {
                throw new TransientException("failed to get node: " + parent.getUri().getPath(), ex);
            }
            throw new RuntimeException("failed to get node: " + parent.getUri().getPath(), ex);
        }
        catch (Throwable t) {
            log.error("rollback dirtyRead for node: " + parent.getUri().getPath(), t);
            try {
                this.transactionManager.rollback(dirtyRead);
                dirtyRead = null;
                this.prof.checkpoint("rollback.getSelectNodesByParentSQL");
            }
            catch (Throwable oops) {
                log.error("failed to dirtyRead rollback transaction", oops);
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to get node: " + parent.getUri().getPath(), t);
            }
            throw new RuntimeException("failed to get node: " + parent.getUri().getPath(), t);
        }
        finally {
            if (dirtyRead != null) {
                try {
                    log.warn("put: BUG - dirtyRead transaction still open in finally... calling rollback");
                    this.transactionManager.rollback(dirtyRead);
                }
                catch (Throwable oops) {
                    log.error("failed to rollback dirtyRead transaction in finally", oops);
                }
            }
        }
    }

    private void addChildNodes(ContainerNode parent, List<Node> nodes) {
        if (parent.getNodes().isEmpty()) {
            for (Node n : nodes) {
                log.debug("adding child to list: " + n.getUri().getPath());
                parent.getNodes().add(n);
                n.setParent(parent);
            }
        } else {
            ArrayList<Node> existingChildren = new ArrayList<Node>(parent.getNodes().size());
            existingChildren.addAll(parent.getNodes());
            for (Node n : nodes) {
                if (!existingChildren.contains(n)) {
                    log.debug("adding child to list: " + n.getUri().getPath());
                    n.setParent(parent);
                    parent.getNodes().add(n);
                    continue;
                }
                log.debug("child already in list, not adding: " + n.getUri().getPath());
            }
        }
    }

    private void loadSubjects(List<Node> nodes) {
        for (Node n : nodes) {
            this.loadSubjects(n);
        }
    }

    private void loadSubjects(Node node) {
        if (node == null || node.appData == null) {
            return;
        }
        NodeID nid = (NodeID)node.appData;
        if (nid.owner != null) {
            return;
        }
        Subject s = this.identityCache.get(nid.ownerObject);
        if (s == null) {
            log.debug("lookup subject for owner=" + nid.ownerObject);
            s = this.identManager.toSubject(nid.ownerObject);
            this.prof.checkpoint("IdentityManager.toSubject");
            this.identityCache.put(nid.ownerObject, s);
        } else {
            log.debug("found cached subject for owner=" + nid.ownerObject);
        }
        nid.owner = s;
        String owner = this.identManager.toOwnerString(nid.owner);
        if (owner != null) {
            node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#creator", owner));
        }
        for (ContainerNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            this.loadSubjects(parent);
        }
    }

    public Node put(Node node, Subject creator) throws TransientException {
        log.debug("put: " + node.getUri().getPath() + ", " + node.getClass().getSimpleName());
        if (node.getParent() != null && node.getParent().appData == null) {
            throw new IllegalArgumentException("parent of node is not a persistent node: " + node.getUri().getPath());
        }
        if (node.appData != null) {
            throw new UnsupportedOperationException("update of existing node not supported; try updateProperties");
        }
        if (node.getName().length() > 256) {
            throw new IllegalArgumentException("length of node name exceeds limit (256): " + node.getName());
        }
        try {
            NodeID nodeID = new NodeID();
            nodeID.owner = creator;
            nodeID.ownerObject = this.identManager.toOwner(creator);
            node.appData = nodeID;
            this.startTransaction();
            this.prof.checkpoint("start.NodePutStatementCreator");
            NodePutStatementCreator npsc = new NodePutStatementCreator(this.nodeSchema, false);
            npsc.setValues(node, null);
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            this.jdbc.update((PreparedStatementCreator)npsc, keyHolder);
            nodeID.id = new Long(keyHolder.getKey().longValue());
            this.prof.checkpoint("NodePutStatementCreator");
            for (NodeProperty prop : node.getProperties()) {
                if (prop.getPropertyValue() != null && prop.getPropertyValue().length() > 700) {
                    throw new IllegalArgumentException("length of node property value exceeds limit (700): " + prop.getPropertyURI());
                }
                if (!this.usePropertyTable(prop.getPropertyURI())) continue;
                PropertyStatementCreator ppsc = new PropertyStatementCreator(this.nodeSchema, nodeID, prop, false);
                this.jdbc.update(ppsc);
                this.prof.checkpoint("PropertyStatementCreator");
            }
            this.commitTransaction();
            this.prof.checkpoint("commit.NodePutStatementCreator");
            node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#creator", this.identManager.toOwnerString(creator)));
            if (node instanceof ContainerNode) {
                node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#length", Long.toString(0L)));
            }
            Node node2 = node;
            return node2;
        }
        catch (CannotCreateTransactionException ex) {
            log.error("failed to create transaction: " + node.getUri().getPath(), ex);
            if (DBUtil.isTransientDBException(ex)) {
                throw new TransientException("failed to get node: " + node.getUri().getPath(), ex);
            }
            throw new RuntimeException("failed to get node: " + node.getUri().getPath(), ex);
        }
        catch (Throwable t) {
            log.error("rollback for node: " + node.getUri().getPath(), t);
            try {
                this.rollbackTransaction();
                this.prof.checkpoint("rollback.NodePutStatementCreator");
            }
            catch (Throwable oops) {
                log.error("failed to rollback transaction", oops);
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to persist node: " + node.getUri(), t);
            }
            throw new RuntimeException("failed to persist node: " + node.getUri(), t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("put: BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    public void delete(Node node) throws TransientException {
        log.debug("delete: " + node.getUri().getPath() + ", " + node.getClass().getSimpleName());
        this.expectPersistentNode(node);
        try {
            if (node instanceof ContainerNode) {
                ContainerNode dest = (ContainerNode)this.getPath(this.deletedNodePath);
                String idName = NodeDAO.getNodeID(node) + "-" + node.getName();
                node.setName(idName);
                this.move(node, dest);
            } else {
                this.startTransaction();
                this.prof.checkpoint("start.delete");
                String sql = this.getUpdateLockSQL(node);
                this.jdbc.update(sql);
                this.prof.checkpoint("getUpdateLockSQL");
                if (node instanceof DataNode) {
                    sql = this.getSelectContentLengthSQL(node);
                    Long sizeDifference = this.jdbc.queryForLong(sql);
                    this.prof.checkpoint("getSelectContentLengthSQL");
                    this.deleteNode(node, true);
                    sql = this.getApplySizeDiffSQL(node.getParent(), sizeDifference, false);
                    log.debug(sql);
                    this.jdbc.update(sql);
                    this.prof.checkpoint("getApplySizeDiffSQL");
                } else if (node instanceof LinkNode) {
                    this.deleteNode(node, false);
                } else {
                    throw new RuntimeException("BUG - unsupported node type: " + node.getClass());
                }
                this.commitTransaction();
                this.prof.checkpoint("commit.delete");
            }
            log.debug("Node deleted: " + node.getUri().getPath());
        }
        catch (CannotCreateTransactionException ex) {
            log.error("failed to create transaction: " + node.getUri().getPath(), ex);
            if (DBUtil.isTransientDBException(ex)) {
                throw new TransientException("failed to get node: " + node.getUri().getPath(), ex);
            }
            throw new RuntimeException("failed to get node: " + node.getUri().getPath(), ex);
        }
        catch (IllegalStateException ex) {
            log.debug(ex.toString());
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                    this.prof.checkpoint("rollback.delete");
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            throw ex;
        }
        catch (Throwable t) {
            log.error("delete rollback for node: " + node.getUri().getPath(), t);
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                    this.prof.checkpoint("rollback.delete");
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to delete " + node.getUri().getPath(), t);
            }
            throw new RuntimeException("failed to delete " + node.getUri().getPath(), t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("delete - BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    private void deleteNode(Node node, boolean notBusyOnly) {
        String sql = this.getDeleteNodePropertiesSQL(node);
        log.debug(sql);
        this.jdbc.update(sql);
        this.prof.checkpoint("getDeleteNodePropertiesSQL");
        sql = this.getDeleteNodeSQL(node, notBusyOnly);
        log.debug(sql);
        int count = this.jdbc.update(sql);
        this.prof.checkpoint("getDeleteNodeSQL");
        if (count == 0) {
            throw new IllegalStateException("node busy or path changed during delete: " + node.getUri());
        }
    }

    public void setBusyState(DataNode node, VOS.NodeBusyState curState, VOS.NodeBusyState newState) throws TransientException {
        log.debug("setBusyState: " + node.getUri().getPath() + ", " + (Object)((Object)curState) + " -> " + (Object)((Object)newState));
        this.expectPersistentNode(node);
        try {
            this.startTransaction();
            this.prof.checkpoint("start.getSetBusyStateSQL");
            String sql = this.getSetBusyStateSQL(node, curState, newState);
            log.debug(sql);
            int num = this.jdbc.update(sql);
            this.prof.checkpoint("getSetBusyStateSQL");
            if (num != 1) {
                throw new IllegalStateException("setBusyState " + (Object)((Object)curState) + " -> " + (Object)((Object)newState) + " failed: " + node.getUri());
            }
            this.commitTransaction();
            this.prof.checkpoint("commit.getSetBusyStateSQL");
        }
        catch (CannotCreateTransactionException ex) {
            log.error("failed to create transaction: " + node.getUri().getPath(), ex);
            if (DBUtil.isTransientDBException(ex)) {
                throw new TransientException("failed to get node: " + node.getUri().getPath(), ex);
            }
            throw new RuntimeException("failed to get node: " + node.getUri().getPath(), ex);
        }
        catch (IllegalStateException ex) {
            log.debug(ex.toString());
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                    this.prof.checkpoint("rollback.getSetBusyStateSQL");
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            throw ex;
        }
        catch (Throwable t) {
            log.error("Delete rollback for node: " + node.getUri().getPath(), t);
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                    this.prof.checkpoint("rollback.getSetBusyStateSQL");
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to updateNodeMetadata " + node.getUri().getPath(), t);
            }
            throw new RuntimeException("failed to updateNodeMetadata " + node.getUri().getPath(), t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("delete - BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    public void updateNodeMetadata(DataNode node, FileMetadata meta, boolean strict) throws TransientException {
        log.debug("updateNodeMetadata: " + node.getUri().getPath());
        this.expectPersistentNode(node);
        try {
            this.startTransaction();
            this.prof.checkpoint("start.DataNodeUpdateStatementCreator");
            Date lastModified = null;
            if (strict) {
                String lastModStr = node.getPropertyValue("ivo://ivoa.net/vospace/core#date");
                lastModified = this.dateFormat.parse(lastModStr);
            }
            DataNodeUpdateStatementCreator dnup = new DataNodeUpdateStatementCreator(NodeDAO.getNodeID(node), meta.getContentLength(), meta.getMd5Sum(), lastModified);
            int num = this.jdbc.update(dnup);
            this.prof.checkpoint("DataNodeUpdateStatementCreator");
            log.debug("updateMetadata, rows updated: " + num);
            if (strict && num != 1) {
                throw new IllegalStateException("Node has different lastModified value.");
            }
            String trans = this.getSetBusyStateSQL(node, VOS.NodeBusyState.busyWithWrite, VOS.NodeBusyState.notBusy);
            log.debug(trans);
            num = this.jdbc.update(trans);
            this.prof.checkpoint("getSetBusyStateSQL");
            if (num != 1) {
                throw new IllegalStateException("updateFileMetadata requires a node with busyState=W: " + node.getUri());
            }
            ArrayList<NodeProperty> props = new ArrayList<NodeProperty>();
            NodeProperty np = this.findOrCreate(node, "ivo://ivoa.net/vospace/core#encoding", meta.getContentEncoding());
            if (np != null) {
                props.add(np);
            }
            if ((np = this.findOrCreate(node, "ivo://ivoa.net/vospace/core#type", meta.getContentType())) != null) {
                props.add(np);
            }
            this.doUpdateProperties(node, props);
            this.commitTransaction();
            this.prof.checkpoint("commit.DataNodeUpdateStatementCreator");
        }
        catch (IllegalStateException ex) {
            log.debug(ex.toString());
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                    this.prof.checkpoint("rollback.DataNodeUpdateStatementCreator");
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            throw ex;
        }
        catch (Throwable t) {
            log.error("updateNodeMetadata rollback for node: " + node.getUri().getPath(), t);
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                    this.prof.checkpoint("rollback.DataNodeUpdateStatementCreator");
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to updateNodeMetadata " + node.getUri().getPath(), t);
            }
            throw new RuntimeException("failed to updateNodeMetadata " + node.getUri().getPath(), t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("delete - BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    private NodeProperty findOrCreate(Node node, String uri, String value) {
        NodeProperty np = node.findProperty(uri);
        if (np == null && value == null) {
            return null;
        }
        if (value == null) {
            np.setMarkedForDeletion(true);
        } else if (np == null) {
            np = new NodeProperty(uri, value);
        } else {
            np.setValue(value);
        }
        return np;
    }

    public Node updateProperties(Node node, List<NodeProperty> properties) throws TransientException {
        log.debug("updateProperties: " + node.getUri().getPath() + ", " + node.getClass().getSimpleName());
        this.expectPersistentNode(node);
        try {
            this.startTransaction();
            this.prof.checkpoint("start.updateProperties");
            Node ret = this.doUpdateProperties(node, properties);
            this.commitTransaction();
            this.prof.checkpoint("commit.updateProperties");
            Node node2 = ret;
            return node2;
        }
        catch (Throwable t) {
            log.error("Update rollback for node: " + node.getUri().getPath(), t);
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                    this.prof.checkpoint("rollback.updateProperties");
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to update properties:  " + node.getUri().getPath(), t);
            }
            throw new RuntimeException("failed to update properties:  " + node.getUri().getPath(), t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("updateProperties - BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    private Node doUpdateProperties(Node node, List<NodeProperty> properties) {
        NodeID nodeID = (NodeID)node.appData;
        ArrayList<PropertyStatementCreator> updates = new ArrayList<PropertyStatementCreator>();
        for (NodeProperty prop : properties) {
            boolean propTable = this.usePropertyTable(prop.getPropertyURI());
            NodeProperty cur = node.findProperty(prop.getPropertyURI());
            log.debug("updateProperties: " + prop + " vs. " + cur);
            if (cur != null) {
                if (prop.isMarkedForDeletion()) {
                    if (propTable) {
                        log.debug("doUpdateNode " + prop.getPropertyURI() + " to be deleted from NodeProperty");
                        PropertyStatementCreator ppsc = new PropertyStatementCreator(this.nodeSchema, nodeID, prop);
                        updates.add(ppsc);
                    } else {
                        log.debug("doUpdateNode " + prop.getPropertyURI() + " to be set to null in Node");
                    }
                    boolean rm = node.getProperties().remove(prop);
                    log.debug("removed " + prop.getPropertyURI() + " from node: " + rm);
                    continue;
                }
                String currentValue = cur.getPropertyValue();
                if (!currentValue.equals(prop.getPropertyValue())) {
                    if (prop.getPropertyValue() != null && prop.getPropertyValue().length() > 700) {
                        throw new IllegalArgumentException("length of node property value exceeds limit (700): " + prop.getPropertyURI());
                    }
                    log.debug("doUpdateNode " + prop.getPropertyURI() + ": " + currentValue + " != " + prop.getPropertyValue());
                    if (propTable) {
                        log.debug("doUpdateNode " + prop.getPropertyURI() + " to be updated in NodeProperty");
                        PropertyStatementCreator ppsc = new PropertyStatementCreator(this.nodeSchema, nodeID, prop, true);
                        updates.add(ppsc);
                    } else {
                        log.debug("doUpdateNode " + prop.getPropertyURI() + " to be updated in Node");
                    }
                    cur.setValue(prop.getPropertyValue());
                    continue;
                }
                log.debug("Value unchanged, not updating node property: " + prop.getPropertyURI());
                continue;
            }
            if (prop.isMarkedForDeletion()) continue;
            if (prop.getPropertyValue() != null && prop.getPropertyValue().length() > 700) {
                throw new IllegalArgumentException("length of node property value exceeds limit (700): " + prop.getPropertyURI());
            }
            if (propTable) {
                log.debug("doUpdateNode " + prop.getPropertyURI() + " to be inserted into NodeProperty");
                PropertyStatementCreator ppsc = new PropertyStatementCreator(this.nodeSchema, nodeID, prop);
                updates.add(ppsc);
            } else {
                log.debug("doUpdateNode " + prop.getPropertyURI() + " to be inserted into Node");
            }
            node.getProperties().add(prop);
        }
        NodePutStatementCreator npsc = new NodePutStatementCreator(this.nodeSchema, true);
        npsc.setValues(node, null);
        this.jdbc.update(npsc);
        this.prof.checkpoint("NodePutStatementCreator");
        for (PropertyStatementCreator psc : updates) {
            this.jdbc.update(psc);
            this.prof.checkpoint("PropertyStatementCreator");
        }
        return node;
    }

    public void move(Node src, ContainerNode dest) throws TransientException {
        log.debug("move: " + src.getUri() + " to " + dest.getUri() + " as " + src.getName());
        this.expectPersistentNode(src);
        this.expectPersistentNode(dest);
        if (src instanceof ContainerNode) {
            if (src.getParent() == null || src.getParent().getUri().isRoot()) {
                throw new IllegalArgumentException("Cannot move a root container.");
            }
            Long srcNodeID = NodeDAO.getNodeID(src);
            Long targetNodeID = null;
            for (ContainerNode target = dest; target != null && !target.getUri().isRoot(); target = target.getParent()) {
                targetNodeID = NodeDAO.getNodeID(target);
                if (!targetNodeID.equals(srcNodeID)) continue;
                throw new IllegalArgumentException("Cannot move to a contained sub-node.");
            }
        }
        try {
            this.startTransaction();
            this.prof.checkpoint("start.move");
            String sql = this.getUpdateLockSQL(src);
            this.jdbc.update(sql);
            this.prof.checkpoint("getUpdateLockSQL");
            Long contentLength = new Long(0L);
            if (!(src instanceof LinkNode)) {
                sql = this.getSelectContentLengthSQL(src);
                contentLength = this.jdbc.queryForLong(sql);
                this.prof.checkpoint("getSelectContentLengthSQL");
            }
            ContainerNode srcParent = src.getParent();
            src.setParent(dest);
            NodePutStatementCreator putStatementCreator = new NodePutStatementCreator(this.nodeSchema, true);
            putStatementCreator.setValues(src, null);
            int count = this.jdbc.update(putStatementCreator);
            this.prof.checkpoint("NodePutStatementCreator");
            if (count == 0) {
                throw new IllegalStateException("src node busy: " + src.getUri());
            }
            if (!(src instanceof LinkNode)) {
                String sql1 = this.getApplySizeDiffSQL(srcParent, contentLength, false);
                String sql2 = this.getApplySizeDiffSQL(dest, contentLength, true);
                if (srcParent.getParent() == null || !src.getParent().equals(dest)) {
                    if (dest.getParent() != null && dest.getParent().equals(srcParent)) {
                        String swap = sql1;
                        sql1 = sql2;
                        sql2 = swap;
                    } else if (NodeDAO.getNodeID(srcParent) > NodeDAO.getNodeID(dest)) {
                        String swap = sql1;
                        sql1 = sql2;
                        sql2 = swap;
                    }
                }
                log.debug(sql1);
                this.jdbc.update(sql1);
                this.prof.checkpoint("getApplySizeDiffSQL");
                log.debug(sql2);
                this.jdbc.update(sql2);
                this.prof.checkpoint("getApplySizeDiffSQL");
            }
            this.commitTransaction();
            this.prof.checkpoint("commit.move");
        }
        catch (IllegalStateException ex) {
            log.debug(ex.toString());
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                    this.prof.checkpoint("rollback.move");
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            throw ex;
        }
        catch (Throwable t) {
            log.error("move rollback for node: " + src.getUri().getPath(), t);
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                    this.prof.checkpoint("rollback.move");
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            if (t instanceof IllegalStateException) {
                throw (IllegalStateException)t;
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to move:  " + src.getUri().getPath(), t);
            }
            throw new RuntimeException("failed to move:  " + src.getUri().getPath(), t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("move - BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    public void copy(Node src, ContainerNode dest) throws TransientException {
        log.debug("copy: " + src.getUri() + " to " + dest.getUri() + " as " + src.getName());
        throw new UnsupportedOperationException("Copy not implemented.");
    }

    private int commitBatch(String name, int batchSize, int count, boolean dryrun) {
        return this.commitBatch(name, batchSize, count, dryrun, false);
    }

    private int commitBatch(String name, int batchSize, int count, boolean dryrun, boolean force) {
        if (!dryrun && (count >= batchSize || force)) {
            this.commitTransaction();
            log.info(name + " batch committed: " + count);
            count = 0;
            this.startTransaction();
        }
        return count;
    }

    void delete(Node node, int batchSize, boolean dryrun) throws TransientException {
        log.debug("delete: " + node.getUri().getPath() + "," + batchSize);
        this.expectPersistentNode(node);
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be positive");
        }
        try {
            this.adminStatementCreator = new NodePutStatementCreator(this.nodeSchema, true);
            if (!dryrun) {
                this.startTransaction();
            }
            int count = this.deleteNode(node, batchSize, 0, dryrun);
            if (!dryrun) {
                this.commitTransaction();
                log.info("delete batch committed: " + count);
            }
        }
        catch (Throwable t) {
            log.error("chown rollback for node: " + node.getUri().getPath(), t);
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to delete:  " + node.getUri().getPath(), t);
            }
            throw new RuntimeException("failed to delete:  " + node.getUri().getPath(), t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("chown - BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    private int deleteNode(Node node, int batchSize, int count, boolean dryrun) {
        log.debug("deleteNode: " + node.getClass().getSimpleName() + " " + node.getUri().getPath());
        if (node instanceof ContainerNode) {
            ContainerNode cn = (ContainerNode)node;
            count = this.deleteChildren(cn, batchSize, count, dryrun);
        }
        String sql = this.getDeleteNodePropertiesSQL(node);
        log.debug(sql);
        if (!dryrun) {
            count += this.jdbc.update(sql);
        }
        sql = this.getDeleteNodeSQL(node, false);
        log.debug(sql);
        if (!dryrun) {
            int num = this.jdbc.update(sql);
            if (num == 0) {
                throw new IllegalStateException("node busy or path changed during delete: " + node.getUri());
            }
            count += num;
        }
        count = this.commitBatch("delete", batchSize, count, dryrun);
        return count;
    }

    private int deleteChildren(ContainerNode container, int batchSize, int count, boolean dryrun) {
        String sql = this.getSelectNodesByParentSQL(container, 1000, false);
        log.debug(sql);
        NodeMapper mapper = new NodeMapper(this.authority, container.getUri().getPath());
        List children = this.jdbc.query(sql, new Object[0], (RowMapper)mapper);
        Object[] args = new Object[1];
        boolean foundChildren = false;
        while (children.size() > 0) {
            foundChildren = true;
            Node cur = null;
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                Node child;
                cur = child = (Node)iterator.next();
                child.setParent(container);
                count = this.deleteNode(child, batchSize, count, dryrun);
                count = this.commitBatch("delete", batchSize, count, dryrun);
            }
            sql = this.getSelectNodesByParentSQL(container, 1000, true);
            log.debug(sql);
            args[0] = cur.getName();
            children = this.jdbc.query(sql, args, (RowMapper)mapper);
            children.remove(cur);
        }
        if (foundChildren) {
            count = this.commitBatch("delete", batchSize, count, dryrun, true);
        }
        return count;
    }

    void chown(Node node, Subject newOwner, boolean recursive, int batchSize, boolean dryrun) throws TransientException {
        log.debug("chown: " + node.getUri().getPath() + ", " + newOwner + ", " + recursive + "," + batchSize);
        this.expectPersistentNode(node);
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be positive");
        }
        try {
            Object newOwnerObj = this.identManager.toOwner(newOwner);
            this.adminStatementCreator = new NodePutStatementCreator(this.nodeSchema, true);
            if (!dryrun) {
                this.startTransaction();
            }
            int count = this.chownNode(node, newOwnerObj, recursive, batchSize, 0, dryrun);
            if (!dryrun) {
                this.commitTransaction();
            }
            log.debug("chown batch committed: " + count);
        }
        catch (Throwable t) {
            log.error("chown rollback for node: " + node.getUri().getPath(), t);
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to chown:  " + node.getUri().getPath(), t);
            }
            throw new RuntimeException("failed to chown:  " + node.getUri().getPath(), t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("chown - BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    private int chownNode(Node node, Object newOwnerObject, boolean recursive, int batchSize, int count, boolean dryrun) {
        this.adminStatementCreator.setValues(node, newOwnerObject);
        if (!dryrun) {
            count += this.jdbc.update(this.adminStatementCreator);
        }
        count = this.commitBatch("chown", batchSize, count, dryrun);
        if (recursive && node instanceof ContainerNode) {
            count = this.chownChildren((ContainerNode)node, newOwnerObject, batchSize, count, dryrun);
        }
        return count;
    }

    private int chownChildren(ContainerNode container, Object newOwnerObj, int batchSize, int count, boolean dryrun) {
        String sql = null;
        sql = this.getSelectNodesByParentSQL(container, 1000, false);
        NodeMapper mapper = new NodeMapper(this.authority, container.getUri().getPath());
        List children = this.jdbc.query(sql, new Object[0], (RowMapper)mapper);
        Object[] args = new Object[1];
        while (children.size() > 0) {
            Node cur = null;
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                Node child;
                cur = child = (Node)iterator.next();
                child.setParent(container);
                count = this.chownNode(child, newOwnerObj, true, batchSize, count, dryrun);
            }
            sql = this.getSelectNodesByParentSQL(container, 1000, true);
            args[0] = cur.getName();
            children = this.jdbc.query(sql, args, (RowMapper)mapper);
            children.remove(cur);
        }
        return count;
    }

    List<NodeSizePropagation> getOutstandingPropagations(int limit) {
        try {
            String sql = this.getFindOutstandingPropagationsSQL(limit);
            log.debug("getOutstandingPropagations (limit " + limit + "): " + sql);
            NodeSizePropagationExtractor propagationExtractor = new NodeSizePropagationExtractor();
            List propagations = (List)this.jdbc.query(sql, (ResultSetExtractor)propagationExtractor);
            return propagations;
        }
        catch (Throwable t) {
            String message = "getOutstandingPropagations failed: " + t.getMessage();
            log.error(message, t);
            throw new RuntimeException(message, t);
        }
    }

    void applyPropagation(NodeSizePropagation propagation) throws TransientException {
        log.debug("applyPropagation: " + propagation);
        try {
            String[] propagationSQL;
            this.startTransaction();
            for (String sql : propagationSQL = this.getApplyDeltaSQL(propagation)) {
                log.debug(sql);
                int rowsUpdated = this.jdbc.update(sql);
                if (rowsUpdated == 1) continue;
                throw new RuntimeException("node structure changed, aborting on transation: " + sql);
            }
            this.commitTransaction();
            log.debug("applyPropagation committed.");
        }
        catch (Throwable t) {
            log.error("applyPropagation rollback", t);
            if (this.transactionStatus != null) {
                try {
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction", oops);
                }
            }
            if (DBUtil.isTransientDBException(t)) {
                throw new TransientException("failed to apply propagation.", t);
            }
            throw new RuntimeException("failed to apply propagation.", t);
        }
        finally {
            if (this.transactionStatus != null) {
                try {
                    log.warn("applyPropagation - BUG - transaction still open in finally... calling rollback");
                    this.rollbackTransaction();
                }
                catch (Throwable oops) {
                    log.error("failed to rollback transaction in finally", oops);
                }
            }
        }
    }

    protected static Long getNodeID(Node node) {
        if (node == null || node.appData == null) {
            return null;
        }
        if (node.appData instanceof NodeID) {
            return ((NodeID)node.appData).getID();
        }
        return null;
    }

    protected String getSelectChildNodeSQL(ContainerNode parent) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT nodeID");
        for (String col : NODE_COLUMNS) {
            sb.append(",");
            sb.append(col);
        }
        sb.append(" FROM ");
        sb.append(this.getNodeTableName());
        Long nid = NodeDAO.getNodeID(parent);
        if (nid != null) {
            sb.append(" WHERE parentID = ");
            sb.append(NodeDAO.getNodeID(parent));
        } else {
            sb.append(" WHERE parentID IS NULL");
        }
        sb.append(" AND name = ?");
        return sb.toString();
    }

    protected String getSelectNodesByParentSQL(ContainerNode parent, Integer limit, boolean withStart) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT nodeID");
        for (String col : NODE_COLUMNS) {
            sb.append(",");
            sb.append(col);
        }
        sb.append(" FROM ");
        sb.append(this.getNodeTableName());
        Long nid = NodeDAO.getNodeID(parent);
        if (nid != null) {
            sb.append(" WHERE parentID = ");
            sb.append(NodeDAO.getNodeID(parent));
        } else {
            sb.append(" WHERE parentID IS NULL");
        }
        if (withStart) {
            sb.append(" AND name >= ?");
        }
        if (withStart || limit != null) {
            sb.append(" ORDER BY name");
        }
        if (limit != null) {
            if (this.nodeSchema.limitWithTop) {
                sb.replace(0, 6, "SELECT TOP " + limit);
            } else {
                sb.append(" LIMIT ");
                sb.append(limit);
            }
        }
        return sb.toString();
    }

    protected String getSelectNodePropertiesByID(Node node) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT propertyURI, propertyValue FROM ");
        sb.append(this.getNodePropertyTableName());
        sb.append(" WHERE nodeID = ");
        sb.append(NodeDAO.getNodeID(node));
        return sb.toString();
    }

    protected String getDeleteNodeSQL(Node node, boolean notBusyOnly) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getNodeTableName());
        sb.append(" WHERE nodeID = ");
        sb.append(NodeDAO.getNodeID(node));
        sb.append(" AND parentID = ");
        sb.append(NodeDAO.getNodeID(node.getParent()));
        if (notBusyOnly) {
            sb.append(" AND busyState = '");
            sb.append(VOS.NodeBusyState.notBusy.getValue());
            sb.append("'");
        }
        return sb.toString();
    }

    protected String getDeleteNodePropertiesSQL(Node node) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(this.getNodePropertyTableName());
        sb.append(" WHERE nodeID = ");
        sb.append(NodeDAO.getNodeID(node));
        return sb.toString();
    }

    protected String getSetBusyStateSQL(DataNode node, VOS.NodeBusyState curState, VOS.NodeBusyState newState) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getNodeTableName());
        sb.append(" SET busyState='");
        sb.append(newState.getValue());
        sb.append("', lastModified='");
        Date now = new Date();
        NodeDAO.setPropertyValue(node, "ivo://ivoa.net/vospace/core#date", this.dateFormat.format(now), true);
        sb.append(this.dateFormat.format(now));
        sb.append("'");
        sb.append(" WHERE nodeID = ");
        sb.append(NodeDAO.getNodeID(node));
        sb.append(" AND busyState='");
        sb.append(curState.getValue());
        sb.append("'");
        return sb.toString();
    }

    protected String getApplySizeDiffSQL(ContainerNode dest, long size, boolean increment) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getNodeTableName());
        sb.append(" SET delta = coalesce(delta, 0) ");
        if (increment) {
            sb.append("+ ");
        } else {
            sb.append("- ");
        }
        sb.append(size);
        sb.append(" WHERE nodeID = ");
        sb.append(NodeDAO.getNodeID(dest));
        return sb.toString();
    }

    protected String[] getApplyDeltaSQL(NodeSizePropagation propagation) {
        ArrayList<String> sql = new ArrayList<String>();
        Date now = new Date();
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getNodeTableName());
        if (NODE_TYPE_DATA.equals(propagation.getChildType())) {
            sb.append(" SET type = '");
            sb.append(NODE_TYPE_DATA);
            sb.append("'");
        } else if (NODE_TYPE_CONTAINER.equals(propagation.getChildType())) {
            sb.append(" SET contentLength = coalesce(contentLength, 0) + coalesce(delta, 0),");
            sb.append(" lastModified = '");
            sb.append(this.dateFormat.format(now));
            sb.append("'");
        } else {
            throw new IllegalStateException("Wrong node type for delta application.");
        }
        sb.append(" WHERE nodeID = ");
        sb.append(propagation.getChildID());
        if (propagation.getParentID() == null) {
            sb.append(" AND parentID IS NULL");
        } else {
            sb.append(" AND parentID = ");
            sb.append(propagation.getParentID());
        }
        sql.add(sb.toString());
        if (propagation.getParentID() != null) {
            sb = new StringBuilder();
            sb.append("UPDATE ");
            sb.append(this.getNodeTableName());
            sb.append(" SET delta = coalesce(delta, 0) + ");
            sb.append("(SELECT coalesce(delta, 0) FROM ");
            sb.append(this.getNodeTableName());
            sb.append(" WHERE nodeID = ");
            sb.append(propagation.getChildID());
            sb.append("), lastModified = '");
            sb.append(this.dateFormat.format(now));
            sb.append("'");
            sb.append(" WHERE nodeID = ");
            sb.append(propagation.getParentID());
            sql.add(sb.toString());
        }
        sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getNodeTableName());
        sb.append(" SET delta = 0");
        sb.append(" WHERE nodeID = ");
        sb.append(propagation.getChildID());
        if (propagation.getParentID() == null) {
            sb.append(" AND parentID IS NULL");
        } else {
            sb.append(" AND parentID = ");
            sb.append(propagation.getParentID());
        }
        sql.add(sb.toString());
        return sql.toArray(new String[0]);
    }

    protected String[] getRootUpdateLockSQL(Node n1, Node n2) {
        Node root1 = n1;
        Node root2 = null;
        while (root1.getParent() != null) {
            root1 = root1.getParent();
        }
        if (n2 != null) {
            root2 = n2;
            while (root2.getParent() != null) {
                root2 = root2.getParent();
            }
        }
        return this.getUpdateLockSQL(root1, root2);
    }

    protected String[] getUpdateLockSQL(Node n1, Node n2) {
        Node[] nodes = null;
        Long id1 = NodeDAO.getNodeID(n1);
        Long id2 = null;
        if (n2 != null) {
            id2 = NodeDAO.getNodeID(n2);
        }
        nodes = n2 == null || id1.compareTo(id2) == 0 ? new Node[]{n1} : (id1.compareTo(id2) < 0 ? new Node[]{n1, n2} : new Node[]{n2, n1});
        String[] ret = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ret[i] = this.getUpdateLockSQL(nodes[i]);
        }
        return ret;
    }

    protected String getUpdateLockSQL(Node node) {
        Long id = NodeDAO.getNodeID(node);
        String type = NodeDAO.getNodeType(node);
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getNodeTableName());
        sb.append(" SET type='");
        sb.append(type);
        sb.append("' WHERE nodeID = ");
        sb.append(id);
        return sb.toString();
    }

    protected String getMoveNodeSQL(Node src, ContainerNode dest, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        sb.append(this.getNodeTableName());
        sb.append(" SET parentID = ");
        sb.append(NodeDAO.getNodeID(dest));
        sb.append(", name = '");
        sb.append(name);
        sb.append("' WHERE nodeID = ");
        sb.append(NodeDAO.getNodeID(src));
        return sb.toString();
    }

    protected String getFindOutstandingPropagationsSQL(int limit) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT");
        sb.append(" nodeID, type, parentID FROM ");
        sb.append(this.getNodeTableName());
        if (this.nodeSchema.deltaIndexName != null) {
            sb.append(" (INDEX ");
            sb.append(this.nodeSchema.deltaIndexName);
            sb.append(")");
        }
        sb.append(" WHERE delta != 0");
        sb.append(" AND type IN ('");
        sb.append(NODE_TYPE_DATA);
        sb.append("', '");
        sb.append(NODE_TYPE_CONTAINER);
        sb.append("')");
        if (this.nodeSchema.limitWithTop) {
            sb.replace(0, 6, "SELECT TOP " + limit);
        } else {
            sb.append(" LIMIT ");
            sb.append(limit);
        }
        return sb.toString();
    }

    protected String getSelectContentLengthSQL(Node node) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT coalesce(contentLength, 0) - coalesce(delta, 0) FROM ");
        sb.append(this.getNodeTableName());
        sb.append(" WHERE nodeID = ");
        sb.append(NodeDAO.getNodeID(node));
        return sb.toString();
    }

    private static String getNodeType(Node node) {
        if (node instanceof DataNode) {
            return NODE_TYPE_DATA;
        }
        if (node instanceof ContainerNode) {
            return NODE_TYPE_CONTAINER;
        }
        if (node instanceof LinkNode) {
            return NODE_TYPE_LINK;
        }
        throw new UnsupportedOperationException("unable to persist node type: " + node.getClass().getName());
    }

    private static String getBusyState(Node node) {
        DataNode dn;
        if (node instanceof DataNode && (dn = (DataNode)node).getBusy() != null) {
            return dn.getBusy().getValue();
        }
        return VOS.NodeBusyState.notBusy.getValue();
    }

    private static void setPropertyValue(Node node, String uri, String value, boolean readOnly) {
        NodeProperty cur = node.findProperty(uri);
        if (cur == null) {
            cur = new NodeProperty(uri, value);
            node.getProperties().add(cur);
        } else {
            cur.setValue(value);
        }
        cur.setReadOnly(readOnly);
    }

    private boolean usePropertyTable(String uri) {
        if (coreProps == null) {
            TreeSet<String> core = new TreeSet<String>(new CaseInsensitiveStringComparator());
            core.add("ivo://ivoa.net/vospace/core#ispublic");
            core.add("ivo://cadc.nrc.ca/vospace/core#islocked");
            core.add("ivo://ivoa.net/vospace/core#creator");
            core.add("ivo://ivoa.net/vospace/core#length");
            core.add("ivo://ivoa.net/vospace/core#type");
            core.add("ivo://ivoa.net/vospace/core#encoding");
            core.add("ivo://ivoa.net/vospace/core#MD5");
            core.add("ivo://ivoa.net/vospace/core#date");
            core.add("ivo://ivoa.net/vospace/core#groupread");
            core.add("ivo://ivoa.net/vospace/core#groupwrite");
            coreProps = core;
        }
        return !coreProps.contains(uri);
    }

    static {
        Log4jInit.setLevel("ca.nrc.cadc.vos", Level.DEBUG);
        NODE_COLUMNS = new String[]{"parentID", "name", "type", "busyState", "isPublic", "isLocked", "ownerID", "creatorID", "groupRead", "groupWrite", "lastModified", "contentType", "contentEncoding", "link", "contentLength", "contentMD5"};
    }

    private class NodeSizePropagationExtractor
    implements ResultSetExtractor {
        private NodeSizePropagationExtractor() {
        }

        public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
            ArrayList<NodeSizePropagation> propagations = new ArrayList<NodeSizePropagation>(rs.getFetchSize());
            NodeSizePropagation propagation = null;
            while (rs.next()) {
                Object parentObject;
                int col = 1;
                long childID = rs.getLong(col++);
                String childType = rs.getString(col++);
                Long parentID = null;
                if ((parentObject = rs.getObject(col++)) != null) {
                    Number parentNumber = (Number)parentObject;
                    parentID = new Long(parentNumber.longValue());
                }
                propagation = new NodeSizePropagation(childID, childType, parentID);
                propagations.add(propagation);
            }
            return propagations;
        }
    }

    private class NodePathExtractor
    implements ResultSetExtractor {
        private int columnsPerNode = NodeDAO.access$700().length + 1;

        public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
            boolean done = false;
            Node ret = null;
            Node root = null;
            String curPath = "";
            int numColumns = rs.getMetaData().getColumnCount();
            while (!done && rs.next()) {
                if (root == null) {
                    log.debug("reading path from row 1");
                    int col = 1;
                    Node cur = null;
                    while (!done && col < numColumns) {
                        log.debug("readNode at " + col + ", path=" + curPath);
                        Node n = this.readNode(rs, col, curPath);
                        if (n == null) {
                            done = true;
                            continue;
                        }
                        ret = n;
                        log.debug("readNode: " + n.getUri());
                        curPath = n.getUri().getPath();
                        col += this.columnsPerNode;
                        if (root == null) {
                            root = cur = n;
                            continue;
                        }
                        ((ContainerNode)cur).getNodes().add(n);
                        n.setParent((ContainerNode)cur);
                        cur = n;
                    }
                    continue;
                }
                log.warn("found extra rows, expected only 0 or 1");
            }
            return ret;
        }

        private Node readNode(ResultSet rs, int col, String basePath) throws SQLException {
            VOSURI vos;
            Object o;
            Long parentID = null;
            if ((o = rs.getObject(col++)) != null) {
                Number n = (Number)o;
                parentID = new Long(n.longValue());
            }
            String name = rs.getString(col++);
            String type = rs.getString(col++);
            String busyString = this.getString(rs, col++);
            boolean isPublic = rs.getBoolean(col++);
            boolean isLocked = rs.getBoolean(col++);
            Object ownerObject = rs.getObject(col++);
            String owner = null;
            Object creatorObject = rs.getObject(col++);
            String groupRead = this.getString(rs, col++);
            String groupWrite = this.getString(rs, col++);
            Timestamp lastModified = rs.getTimestamp(col++, NodeDAO.this.cal);
            String contentType = this.getString(rs, col++);
            String contentEncoding = this.getString(rs, col++);
            String linkStr = this.getString(rs, col++);
            Long contentLength = null;
            if ((o = rs.getObject(col++)) != null) {
                Number n = (Number)o;
                contentLength = new Long(n.longValue());
            }
            log.debug("readNode: contentLength = " + contentLength);
            Object contentMD5 = rs.getObject(col++);
            Long nodeID = null;
            o = rs.getObject(col++);
            if (o != null) {
                Number n = (Number)o;
                nodeID = new Long(n.longValue());
            }
            String path = basePath + "/" + name;
            try {
                vos = new VOSURI(new URI("vos", NodeDAO.this.authority, path, null, null));
            }
            catch (URISyntaxException bug) {
                throw new RuntimeException("BUG - failed to create vos URI", bug);
            }
            Node node = null;
            if (nodeID != null) {
                if (NodeDAO.NODE_TYPE_CONTAINER.equals(type)) {
                    node = new ContainerNode(vos);
                } else if (NodeDAO.NODE_TYPE_DATA.equals(type)) {
                    node = new DataNode(vos);
                    ((DataNode)node).setBusy(VOS.NodeBusyState.getStateFromValue(busyString));
                } else if (NodeDAO.NODE_TYPE_LINK.equals(type)) {
                    URI link;
                    try {
                        link = new URI(linkStr);
                    }
                    catch (URISyntaxException bug) {
                        throw new RuntimeException("BUG - failed to create link URI", bug);
                    }
                    node = new LinkNode(vos, link);
                } else {
                    throw new IllegalStateException("Unknown node database type: " + type);
                }
                NodeID nid = new NodeID();
                nid.id = nodeID;
                nid.ownerObject = ownerObject;
                node.appData = nid;
                if (contentType != null) {
                    node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#type", contentType));
                }
                if (contentEncoding != null) {
                    node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#encoding", contentEncoding));
                }
                if (contentLength != null) {
                    node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#length", contentLength.toString()));
                } else {
                    node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#length", "0"));
                }
                if (contentMD5 != null && contentMD5 instanceof byte[]) {
                    byte[] md5 = (byte[])contentMD5;
                    if (md5.length < 16) {
                        byte[] tmp = md5;
                        md5 = new byte[16];
                        System.arraycopy(tmp, 0, md5, 0, tmp.length);
                    }
                    String contentMD5String = HexUtil.toHex(md5);
                    node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#MD5", contentMD5String));
                }
                if (lastModified != null) {
                    node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#date", NodeDAO.this.dateFormat.format(lastModified)));
                }
                if (groupRead != null) {
                    node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#groupread", groupRead));
                }
                if (groupWrite != null) {
                    node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#groupwrite", groupWrite));
                }
                if (owner != null) {
                    node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#creator", owner));
                }
                node.getProperties().add(new NodeProperty("ivo://ivoa.net/vospace/core#ispublic", Boolean.toString(isPublic)));
                if (isLocked) {
                    node.getProperties().add(new NodeProperty("ivo://cadc.nrc.ca/vospace/core#islocked", Boolean.toString(isLocked)));
                }
                for (String propertyURI : VOS.READ_ONLY_PROPERTIES) {
                    int propertyIndex = node.getProperties().indexOf(new NodeProperty(propertyURI, ""));
                    if (propertyIndex == -1) continue;
                    node.getProperties().get(propertyIndex).setReadOnly(true);
                }
            }
            return node;
        }

        private String getString(ResultSet rs, int col) throws SQLException {
            String ret = rs.getString(col);
            if (ret != null && (ret = ret.trim()).length() == 0) {
                ret = null;
            }
            return ret;
        }
    }

    private class NodePathStatementCreator
    implements PreparedStatementCreator {
        private String[] path;
        private String nodeTablename;
        private String propTableName;
        private boolean allowPartialPath;

        public NodePathStatementCreator(String[] path, String nodeTablename, String propTableName, boolean allowPartialPath) {
            this.path = path;
            this.nodeTablename = nodeTablename;
            this.propTableName = propTableName;
            this.allowPartialPath = allowPartialPath;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            String sql = this.getSQL();
            log.debug("SQL: " + sql);
            PreparedStatement ret = conn.prepareStatement(sql);
            for (int i = 0; i < this.path.length; ++i) {
                ret.setString(i + 1, this.path[i]);
            }
            return ret;
        }

        String getSQL() {
            StringBuilder sb = new StringBuilder();
            String acur = null;
            sb.append("SELECT ");
            for (int i = 0; i < this.path.length; ++i) {
                acur = "a" + i;
                if (i > 0) {
                    sb.append(",");
                }
                for (int c = 0; c < NODE_COLUMNS.length; ++c) {
                    if (c > 0) {
                        sb.append(",");
                    }
                    sb.append(acur);
                    sb.append(".");
                    sb.append(NODE_COLUMNS[c]);
                }
                sb.append(",");
                sb.append(acur);
                sb.append(".nodeID");
            }
            sb.append(" FROM ");
            for (int i = 0; i < this.path.length; ++i) {
                String aprev = acur;
                acur = "a" + i;
                if (i > 0) {
                    if (this.allowPartialPath) {
                        sb.append(" LEFT");
                    }
                    sb.append(" JOIN ");
                }
                sb.append(this.nodeTablename);
                sb.append(" AS ");
                sb.append(acur);
                if (i == 0) {
                    sb.append(" JOIN ");
                    sb.append(this.nodeTablename);
                    sb.append(" AS ");
                    sb.append(acur + 0);
                    sb.append(" ON (");
                    sb.append(acur);
                    sb.append(".parentID IS NULL");
                    sb.append(" AND ");
                    sb.append(acur);
                    sb.append(".nodeID=");
                    sb.append(acur + 0);
                    sb.append(".nodeID");
                    sb.append(" AND ");
                    sb.append(acur);
                    sb.append(".name = ? )");
                    continue;
                }
                sb.append(" ON (");
                sb.append(aprev);
                sb.append(".nodeID=");
                sb.append(acur);
                sb.append(".parentID");
                sb.append(" AND ");
                sb.append(acur);
                sb.append(".name = ? )");
            }
            return sb.toString();
        }
    }

    private class NodePutStatementCreator
    implements PreparedStatementCreator {
        private NodeSchema ns;
        private boolean update;
        private Node node = null;
        private Object differentOwner = null;

        public NodePutStatementCreator(NodeSchema ns, boolean update) {
            this.ns = ns;
            this.update = update;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            PreparedStatement prep;
            if (this.update) {
                String sql = this.getUpdateSQL();
                log.debug(sql);
                prep = conn.prepareStatement(sql);
            } else {
                String sql = this.getInsertSQL();
                log.debug(sql);
                prep = conn.prepareStatement(sql, 1);
            }
            this.setValues(prep);
            return prep;
        }

        public void setValues(Node node, Object differentOwner) {
            this.node = node;
            this.differentOwner = differentOwner;
        }

        void setValues(PreparedStatement ps) throws SQLException {
            StringBuilder sb = new StringBuilder();
            int col = 1;
            if (this.node.getParent() != null) {
                long v = NodeDAO.getNodeID(this.node.getParent());
                ps.setLong(col, v);
                sb.append(v);
            } else {
                ps.setNull(col, -5);
                sb.append("null");
            }
            sb.append(",");
            String name = this.node.getName();
            int n = ++col;
            ps.setString(n, name);
            sb.append(name);
            sb.append(",");
            int n2 = ++col;
            ps.setString(n2, NodeDAO.getNodeType(this.node));
            sb.append(NodeDAO.getNodeType(this.node));
            sb.append(",");
            int n3 = ++col;
            ps.setString(n3, VOS.NodeBusyState.notBusy.getValue());
            sb.append(NodeDAO.getBusyState(this.node));
            sb.append(",");
            int n4 = ++col;
            ps.setBoolean(n4, this.node.isPublic());
            NodeDAO.setPropertyValue(this.node, "ivo://ivoa.net/vospace/core#ispublic", Boolean.toString(this.node.isPublic()), false);
            sb.append(this.node.isPublic());
            sb.append(",");
            int n5 = ++col;
            ++col;
            ps.setBoolean(n5, this.node.isLocked());
            if (this.node.isLocked()) {
                NodeDAO.setPropertyValue(this.node, "ivo://cadc.nrc.ca/vospace/core#islocked", Boolean.toString(this.node.isLocked()), false);
            }
            sb.append(this.node.isLocked());
            sb.append(",");
            int ownerDataType = NodeDAO.this.identManager.getOwnerType();
            Object ownerObject = null;
            NodeID nodeID = (NodeID)this.node.appData;
            ownerObject = nodeID.ownerObject;
            if (this.differentOwner != null) {
                ownerObject = this.differentOwner;
            }
            if (ownerObject == null) {
                throw new IllegalStateException("cannot update a node without an owner.");
            }
            ps.setObject(col++, ownerObject, ownerDataType);
            sb.append(ownerObject);
            sb.append(",");
            ps.setObject(col++, nodeID.ownerObject, ownerDataType);
            sb.append(nodeID.ownerObject);
            sb.append(",");
            String pval = this.node.getPropertyValue("ivo://ivoa.net/vospace/core#groupread");
            if (pval != null) {
                ps.setString(col, pval);
            } else {
                ps.setNull(col, 12);
            }
            ++col;
            sb.append(pval);
            sb.append(",");
            pval = this.node.getPropertyValue("ivo://ivoa.net/vospace/core#groupwrite");
            if (pval != null) {
                ps.setString(col, pval);
            } else {
                ps.setNull(col, 12);
            }
            ++col;
            sb.append(pval);
            sb.append(",");
            Date now = new Date();
            NodeDAO.setPropertyValue(this.node, "ivo://ivoa.net/vospace/core#date", NodeDAO.this.dateFormat.format(now), true);
            Timestamp ts = new Timestamp(now.getTime());
            ps.setTimestamp(col, ts, NodeDAO.this.cal);
            ++col;
            sb.append(NodeDAO.this.dateFormat.format(now));
            sb.append(",");
            pval = this.node.getPropertyValue("ivo://ivoa.net/vospace/core#type");
            if (pval != null) {
                ps.setString(col, pval);
            } else {
                ps.setNull(col, 12);
            }
            ++col;
            sb.append(pval);
            sb.append(",");
            pval = this.node.getPropertyValue("ivo://ivoa.net/vospace/core#encoding");
            if (pval != null) {
                ps.setString(col, pval);
            } else {
                ps.setNull(col, 12);
            }
            ++col;
            sb.append(pval);
            sb.append(",");
            log.debug("setValues:" + sb.toString());
            pval = null;
            if (this.node instanceof LinkNode) {
                pval = ((LinkNode)this.node).getTarget().toString();
                ps.setString(col, pval);
            } else {
                ps.setNull(col, -1);
            }
            ++col;
            sb.append(pval);
            sb.append(",");
            if (this.update) {
                ps.setLong(col, NodeDAO.getNodeID(this.node));
                sb.append(",");
                sb.append(NodeDAO.getNodeID(this.node));
            }
            log.debug("setValues: " + sb);
        }

        private String getInsertSQL() {
            int c;
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ");
            sb.append(this.ns.nodeTable);
            sb.append(" (");
            int numCols = NODE_COLUMNS.length - 2;
            for (c = 0; c < numCols; ++c) {
                if (c > 0) {
                    sb.append(",");
                }
                sb.append(NODE_COLUMNS[c]);
            }
            sb.append(") VALUES (");
            for (c = 0; c < numCols; ++c) {
                if (c > 0) {
                    sb.append(",");
                }
                sb.append("?");
            }
            sb.append(")");
            return sb.toString();
        }

        private String getUpdateSQL() {
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE ");
            sb.append(this.ns.nodeTable);
            int numCols = NODE_COLUMNS.length - 2;
            sb.append(" SET ");
            for (int c = 0; c < numCols; ++c) {
                if (c > 0) {
                    sb.append(",");
                }
                sb.append(NODE_COLUMNS[c]);
                sb.append(" = ?");
            }
            sb.append(" WHERE nodeID = ? AND busyState = '");
            sb.append(VOS.NodeBusyState.notBusy.getValue());
            sb.append("'");
            return sb.toString();
        }
    }

    private class PropertyStatementCreator
    implements PreparedStatementCreator {
        private NodeSchema ns;
        private boolean update;
        private NodeID nodeID;
        private NodeProperty prop;

        public PropertyStatementCreator(NodeSchema ns, NodeID nodeID, NodeProperty prop) {
            this(ns, nodeID, prop, false);
        }

        public PropertyStatementCreator(NodeSchema ns, NodeID nodeID, NodeProperty prop, boolean update) {
            this.ns = ns;
            this.nodeID = nodeID;
            this.prop = prop;
            this.update = update;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            String sql = this.prop.isMarkedForDeletion() ? this.getDeleteSQL() : (this.update ? this.getUpdateSQL() : this.getInsertSQL());
            log.debug(sql);
            PreparedStatement prep = conn.prepareStatement(sql);
            this.setValues(prep);
            return prep;
        }

        void setValues(PreparedStatement ps) throws SQLException {
            int col = 1;
            if (this.prop.isMarkedForDeletion()) {
                ps.setLong(col++, this.nodeID.getID());
                ps.setString(col++, this.prop.getPropertyURI());
                log.debug("setValues: " + this.nodeID.getID() + "," + this.prop.getPropertyURI());
            } else if (this.update) {
                ps.setString(col++, this.prop.getPropertyValue());
                ps.setLong(col++, this.nodeID.getID());
                ps.setString(col++, this.prop.getPropertyURI());
                log.debug("setValues: " + this.prop.getPropertyValue() + "," + this.nodeID.getID() + "," + this.prop.getPropertyURI());
            } else {
                ps.setLong(col++, this.nodeID.getID());
                ps.setString(col++, this.prop.getPropertyURI());
                ps.setString(col++, this.prop.getPropertyValue());
                ps.setLong(col++, this.nodeID.getID());
                ps.setString(col++, this.prop.getPropertyURI());
                log.debug("setValues: " + this.nodeID.getID() + "," + this.prop.getPropertyURI() + "," + this.prop.getPropertyValue() + "," + this.nodeID.getID() + "," + this.prop.getPropertyURI());
            }
        }

        public String getSQL() {
            if (this.update) {
                return this.getUpdateSQL();
            }
            return this.getInsertSQL();
        }

        private String getInsertSQL() {
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ");
            sb.append(this.ns.propertyTable);
            sb.append(" (nodeID,propertyURI,propertyValue) SELECT ?, ?, ?");
            sb.append(" WHERE NOT EXISTS (SELECT * FROM ");
            sb.append(this.ns.propertyTable);
            sb.append(" WHERE nodeID=? and propertyURI=?)");
            return sb.toString();
        }

        private String getUpdateSQL() {
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE ");
            sb.append(this.ns.propertyTable);
            sb.append(" SET propertyValue = ?");
            sb.append(" WHERE nodeID = ?");
            sb.append(" AND propertyURI = ?");
            return sb.toString();
        }

        private String getDeleteSQL() {
            StringBuilder sb = new StringBuilder();
            sb.append("DELETE FROM ");
            sb.append(this.ns.propertyTable);
            sb.append(" WHERE nodeID = ?");
            sb.append(" AND propertyURI = ?");
            return sb.toString();
        }
    }

    private class DataNodeUpdateStatementCreator
    implements PreparedStatementCreator {
        private Long len;
        private String md5;
        private Long nodeID;
        private Date lastModified;

        public DataNodeUpdateStatementCreator(Long nodeID, Long len, String md5, Date lastModified) {
            this.nodeID = nodeID;
            this.len = len;
            this.md5 = md5;
            this.lastModified = lastModified;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            StringBuilder sb = new StringBuilder();
            sb.append("UPDATE ");
            sb.append(NodeDAO.this.getNodeTableName());
            sb.append(" SET ");
            sb.append("lastModified = ?, ");
            sb.append("delta = ? - coalesce(contentLength, 0) + coalesce(delta, 0), contentLength = ?, contentMD5 = ?");
            sb.append(" WHERE nodeID = ?");
            if (this.lastModified != null) {
                sb.append(" AND lastModified = ?");
            }
            String sql = sb.toString();
            log.debug(sql);
            sb = new StringBuilder("values: ");
            PreparedStatement prep = conn.prepareStatement(sql);
            int col = 1;
            Date now = new Date();
            Timestamp ts = new Timestamp(now.getTime());
            prep.setTimestamp(col++, ts, NodeDAO.this.cal);
            sb.append(now);
            sb.append(",");
            if (this.len == null) {
                prep.setLong(col++, 0L);
                prep.setNull(col++, -5);
            } else {
                prep.setLong(col++, this.len);
                prep.setLong(col++, this.len);
            }
            sb.append(this.len);
            sb.append(",");
            sb.append(this.len);
            sb.append(",");
            if (this.md5 == null) {
                prep.setNull(col++, -3);
            } else {
                prep.setBytes(col++, HexUtil.toBytes(this.md5));
            }
            sb.append(this.md5);
            sb.append(",");
            prep.setLong(col++, this.nodeID);
            sb.append(this.nodeID);
            if (this.lastModified != null) {
                Timestamp lastModTs = new Timestamp(this.lastModified.getTime());
                prep.setTimestamp(col++, lastModTs, NodeDAO.this.cal);
                sb.append(",");
                sb.append(lastModTs);
            }
            log.debug(sb.toString());
            return prep;
        }
    }

    public static class NodeSchema {
        public String nodeTable;
        public String propertyTable;
        boolean limitWithTop;
        public String deltaIndexName;

        public NodeSchema(String nodeTable, String propertyTable, boolean limitWithTop) {
            this.nodeTable = nodeTable;
            this.propertyTable = propertyTable;
            this.limitWithTop = limitWithTop;
        }
    }
}

