/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server;

import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.util.HexUtil;
import ca.nrc.cadc.util.StringBuilderWriter;
import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.server.AbstractView;
import ca.nrc.cadc.vos.server.RssFeed;
import ca.nrc.cadc.vos.server.RssFeedItem;
import ca.nrc.cadc.vos.server.util.FixedSizeTreeSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.restlet.data.Encoding;
import org.restlet.data.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssView
extends AbstractView {
    private static Logger log = Logger.getLogger(RssView.class);
    private DateFormat dateFormat = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);
    private static final int DEFAULT_MAX_NUMBER_NODES = 10;
    private Element feed;
    private String baseURL;
    StringBuilder xmlString;
    protected int maxNodes = 10;

    public RssView() {
    }

    public RssView(URI uri) {
        super(uri);
    }

    @Override
    public void setNode(Node node, String viewReference, URL requestURL) throws UnsupportedOperationException, TransientException {
        super.setNode(node, viewReference, requestURL);
        if (!(node instanceof ContainerNode)) {
            throw new UnsupportedOperationException("RssView is only for container nodes.");
        }
        if (this.nodePersistence == null) {
            throw new IllegalStateException("NodePersistence must be set.");
        }
        if (this.voSpaceAuthorizer == null) {
            throw new IllegalStateException("VOSpaceAuthorizer must be set.");
        }
        this.baseURL = this.getBaseURL(node, requestURL);
        this.xmlString = new StringBuilder();
        try {
            this.voSpaceAuthorizer.getReadPermission(node);
        }
        catch (AccessControlException e) {
            Element ef = RssFeed.createErrorFeed(node, e.getMessage(), this.baseURL);
            try {
                this.write(ef, new StringBuilderWriter(this.xmlString));
                return;
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        }
        FixedSizeTreeSet<RssFeedItem> nodeSet = new FixedSizeTreeSet<RssFeedItem>();
        nodeSet.setMaxSize(this.maxNodes);
        this.addNodeToFeed((ContainerNode)node, nodeSet);
        this.feed = RssFeed.createFeed(node, nodeSet, this.baseURL);
        try {
            this.write(this.xmlString);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Date getLastModified() {
        return null;
    }

    protected void addNodeToFeed(ContainerNode node, FixedSizeTreeSet set) throws TransientException {
        try {
            set.add(new RssFeedItem(this.getLastModifiedDate(node), node));
            log.debug("added container node to feed: " + node.getName());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.nodePersistence.getChildren(node);
        List<Node> children = node.getNodes();
        for (Node child : children) {
            if (child instanceof ContainerNode) {
                try {
                    this.voSpaceAuthorizer.getReadPermission(child);
                    this.addNodeToFeed((ContainerNode)child, set);
                }
                catch (AccessControlException accessControlException) {}
                continue;
            }
            try {
                set.add(new RssFeedItem(this.getLastModifiedDate(child), child));
                log.debug("added data node to feed: " + child.getName());
            }
            catch (ParseException parseException) {}
        }
    }

    String getBaseURL(Node n, URL r) {
        String nPath = n.getUri().getPath();
        StringBuilder sb = new StringBuilder();
        sb.append(r.getProtocol());
        sb.append("://");
        sb.append(r.getHost());
        if (r.getPort() > 0) {
            sb.append(":");
            sb.append(Integer.toString(r.getPort()));
        }
        String uPath = r.getPath();
        int i = uPath.indexOf(nPath);
        String basePath = uPath.substring(0, i);
        sb.append(basePath);
        return sb.toString();
    }

    public void write(StringBuilder builder) throws IOException {
        this.write(new StringBuilderWriter(builder));
    }

    @Override
    public void write(OutputStream out) throws IOException {
        OutputStreamWriter outWriter;
        try {
            outWriter = new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported", e);
        }
        this.write(new BufferedWriter(outWriter));
    }

    public void write(Writer writer) throws IOException {
        try {
            this.write(this.feed, writer);
        }
        catch (Exception e) {
            log.debug(e);
            Element ef = RssFeed.createErrorFeed(this.node, e.getMessage(), this.baseURL);
            this.write(ef, writer);
        }
    }

    protected void write(Element root, Writer writer) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document();
        root.detach();
        document.setRootElement(root);
        outputter.output(document, writer);
    }

    @Override
    public boolean canAccept(Node node) {
        return false;
    }

    @Override
    public boolean canProvide(Node node) {
        return node instanceof ContainerNode;
    }

    @Override
    public long getContentLength() {
        return this.xmlString.length();
    }

    @Override
    public MediaType getMediaType() {
        return MediaType.APPLICATION_RSS;
    }

    @Override
    public List<Encoding> getEncodings() {
        return new ArrayList<Encoding>(0);
    }

    @Override
    public String getContentMD5() {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] md5hash = new byte[32];
            md.update(this.xmlString.toString().getBytes("iso-8859-1"), 0, this.xmlString.toString().length());
            md5hash = md.digest();
            return HexUtil.toHex(md5hash);
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("Algorithm MD5 not found.", e);
        }
        catch (UnsupportedEncodingException e) {
            log.warn("ISO-8859-1 encoding not found.", e);
        }
        return null;
    }

    private Date getLastModifiedDate(Node node) throws ParseException {
        List<NodeProperty> nodeProperties = node.getProperties();
        String uriDate = null;
        for (NodeProperty nodeProperty : nodeProperties) {
            if (!nodeProperty.getPropertyURI().equals("ivo://ivoa.net/vospace/core#date")) continue;
            uriDate = nodeProperty.getPropertyValue();
        }
        return this.dateFormat.parse(uriDate);
    }
}

