/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server;

import ca.nrc.cadc.vos.server.AbstractView;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Views {
    private static Logger log = Logger.getLogger(Views.class);
    private static final String VIEWS_PROPERTY_FILE = Views.class.getSimpleName();
    private static final String KEY_VIEW_LIST = "views";
    private static final String KEY_VIEW_ALIAS = "alias";
    private static final String KEY_VIEW_URI = "uri";
    private static final String KEY_VIEW_CLASS = "class";
    private static final String KEY_VIEW_ACCEPTS = "accepts";
    private static final String KEY_VIEW_PROVIDES = "provides";
    private static Map<String, Class<AbstractView>> uriViewMap;
    private static Map<String, Class<AbstractView>> aliasViewMap;
    private static List<String> accepts;
    private static List<String> provides;

    public AbstractView getView(String viewReference) throws Exception {
        Class<AbstractView> viewClass = aliasViewMap.get(viewReference);
        URI viewURI = null;
        if (viewClass == null) {
            viewClass = uriViewMap.get(viewReference);
            if (viewClass == null) {
                log.debug("No view found for reference: " + viewReference);
                return null;
            }
            viewURI = new URI(viewReference);
        }
        log.debug("Returning new view of type " + viewClass + " for reference " + viewReference);
        return this.createAbstractView(viewClass, viewURI);
    }

    public AbstractView getView(URI viewURI) throws Exception {
        Class<AbstractView> viewClass = uriViewMap.get(viewURI.toString());
        if (viewClass == null) {
            log.debug("No view found for reference: " + viewURI.toString());
            return null;
        }
        log.debug("Returning new view of type " + viewClass + " for reference " + viewURI.toString());
        return this.createAbstractView(viewClass, viewURI);
    }

    public List<AbstractView> getViews() throws Exception {
        Set<String> viewURIs = uriViewMap.keySet();
        Class<AbstractView> nextViewClass = null;
        AbstractView nextView = null;
        ArrayList<AbstractView> viewList = new ArrayList<AbstractView>();
        for (String viewURI : viewURIs) {
            nextViewClass = uriViewMap.get(viewURI);
            nextView = this.createAbstractView(nextViewClass, new URI(viewURI));
            viewList.add(nextView);
        }
        return viewList;
    }

    private AbstractView createAbstractView(Class<AbstractView> clazz, URI uri) throws Exception {
        if (uri == null) {
            return clazz.newInstance();
        }
        Constructor<AbstractView> constructor = clazz.getConstructor(URI.class);
        return constructor.newInstance(uri);
    }

    public static List<String> accepts() {
        return accepts;
    }

    public static List<String> provides() {
        return provides;
    }

    private static void loadConfiguredViews() {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(VIEWS_PROPERTY_FILE);
        }
        catch (MissingResourceException e) {
            throw new ExceptionInInitializerError("Could not load properties file: " + VIEWS_PROPERTY_FILE + ".properties: " + e.getMessage());
        }
        uriViewMap = new HashMap<String, Class<AbstractView>>();
        aliasViewMap = new HashMap<String, Class<AbstractView>>();
        accepts = new ArrayList<String>();
        provides = new ArrayList<String>();
        accepts.add("ivo://ivoa.net/vospace/core#defaultview");
        provides.add("ivo://ivoa.net/vospace/core#defaultview");
        try {
            String viewNamesString = rb.getString(KEY_VIEW_LIST);
            String[] viewNames = viewNamesString.split(" ");
            log.debug("ViewFactory loading views: " + viewNamesString);
            for (String viewName : viewNames) {
                String viewAlias = rb.getString(viewName + "." + KEY_VIEW_ALIAS);
                String viewURI = rb.getString(viewName + "." + KEY_VIEW_URI);
                String viewClassName = rb.getString(viewName + "." + KEY_VIEW_CLASS);
                Class<?> configClass = Class.forName(viewClassName);
                Object configObject = configClass.newInstance();
                if (!(configObject instanceof AbstractView)) {
                    throw new ExceptionInInitializerError(configClass.getName() + " is not an instance of " + AbstractView.class);
                }
                try {
                    new URI(viewURI);
                }
                catch (URISyntaxException e) {
                    throw new ExceptionInInitializerError("URI reference for " + configClass.getName() + " has an invalid syntax.");
                }
                Class<?> viewClass = configClass;
                if (aliasViewMap.containsKey(viewAlias)) {
                    throw new ExceptionInInitializerError("Duplicate view reference " + viewAlias + " in file " + VIEWS_PROPERTY_FILE + ".properties");
                }
                if (uriViewMap.containsKey(viewURI)) {
                    throw new ExceptionInInitializerError("Duplicate view reference " + viewURI + " in file " + VIEWS_PROPERTY_FILE + ".properties");
                }
                aliasViewMap.put(viewAlias, viewClass);
                log.debug("Mapped alias '" + viewAlias + "' to class " + viewClass);
                uriViewMap.put(viewURI, viewClass);
                log.debug("Mapped URI '" + viewURI + "' to class " + viewClass);
                try {
                    String acceptsValue = rb.getString(viewName + "." + KEY_VIEW_ACCEPTS);
                    if (acceptsValue != null && acceptsValue.trim().equalsIgnoreCase("true")) {
                        accepts.add(viewURI);
                    }
                }
                catch (MissingResourceException acceptsValue) {
                    // empty catch block
                }
                try {
                    String providesValue = rb.getString(viewName + "." + KEY_VIEW_PROVIDES);
                    if (providesValue == null || !providesValue.trim().equalsIgnoreCase("true")) continue;
                    provides.add(viewURI);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            log.error(e);
            throw new ExceptionInInitializerError(e);
        }
    }

    static {
        Views.loadConfiguredViews();
    }
}

