/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server;

import ca.nrc.cadc.util.StringBuilderWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewsWriter {
    protected static Namespace defaultNamespace = Namespace.getNamespace("http://www.ivoa.net/xml/VOSpace/v2.0");
    protected static Namespace vosNamespace = Namespace.getNamespace("vos", "http://www.ivoa.net/xml/VOSpace/v2.0");
    protected static Namespace xsiNamespace = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    private static Logger log = Logger.getLogger(ViewsWriter.class);

    public void write(List<String> accepts, List<String> provides, StringBuilder builder) throws IOException {
        this.write(accepts, provides, new StringBuilderWriter(builder));
    }

    public void write(List<String> accepts, List<String> provides, OutputStream out) throws IOException {
        OutputStreamWriter outWriter;
        try {
            outWriter = new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported", e);
        }
        this.write(accepts, provides, new BufferedWriter(outWriter));
    }

    public void write(List<String> accepts, List<String> provides, Writer writer) throws IOException {
        Element root = this.getRootElement();
        root.addContent(this.getViewsListElement("accepts", accepts));
        root.addContent(this.getViewsListElement("provides", provides));
        this.write(root, writer);
    }

    protected Element getRootElement() {
        Element root = new Element("views", defaultNamespace);
        root.addNamespaceDeclaration(vosNamespace);
        root.addNamespaceDeclaration(xsiNamespace);
        return root;
    }

    protected Element getViewsListElement(String name, List<String> uris) {
        Element viewList = new Element(name, defaultNamespace);
        for (String uri : uris) {
            Element property = new Element("view", defaultNamespace);
            property.setAttribute("uri", uri);
            viewList.addContent(property);
        }
        return viewList;
    }

    protected void write(Element root, Writer writer) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        outputter.output(new Document(root), writer);
    }
}

