/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.web.representation;

import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeWriter;
import ca.nrc.cadc.vos.server.AbstractView;
import ca.nrc.cadc.vos.server.Views;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.restlet.data.MediaType;
import org.restlet.representation.OutputRepresentation;

public class NodeOutputRepresentation
extends OutputRepresentation {
    protected static Logger LOGGER = Logger.getLogger(NodeOutputRepresentation.class);
    private static final int MAX_CHILD_BUFFER = 1000;
    private Node node;
    private NodeWriter nodeWriter;
    private StringBuilder buf;

    public NodeOutputRepresentation(Node node, NodeWriter nodeWriter, MediaType mediaType) {
        super(mediaType);
        this.node = node;
        this.nodeWriter = nodeWriter;
        this.fillAcceptsAndProvides(node);
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.buf != null) {
            OutputStreamWriter w = new OutputStreamWriter(outputStream);
            w.write(this.buf.toString());
            w.close();
        } else {
            this.nodeWriter.write(this.node, outputStream);
        }
    }

    public long getSize() {
        ContainerNode cn;
        if (this.node instanceof ContainerNode && (cn = (ContainerNode)this.node).getNodes().size() > 1000) {
            return -1L;
        }
        if (this.buf != null) {
            return this.buf.length();
        }
        try {
            this.buf = new StringBuilder();
            this.nodeWriter.write(this.node, this.buf);
            LOGGER.debug("buffered node, content-length = " + this.buf.length());
            return this.buf.length();
        }
        catch (IOException ex) {
            LOGGER.error("failed to buffer ");
            return -1L;
        }
    }

    public Date getModificationDate() {
        return null;
    }

    private void fillAcceptsAndProvides(Node node) {
        Views views = new Views();
        try {
            ArrayList<URI> accepts = new ArrayList<URI>();
            ArrayList<URI> provides = new ArrayList<URI>();
            List<AbstractView> viewList = views.getViews();
            for (AbstractView view : viewList) {
                if (view.canAccept(node)) {
                    accepts.add(view.getURI());
                }
                if (!view.canProvide(node)) continue;
                provides.add(view.getURI());
            }
            node.setAccepts(accepts);
            node.setProvides(provides);
        }
        catch (Exception e) {
            LOGGER.error("Could not get view list: " + e.getMessage());
        }
    }
}

