/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.web.restlet.action;

import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeAlreadyExistsException;
import ca.nrc.cadc.vos.NodeFault;
import ca.nrc.cadc.vos.NodeNotFoundException;
import ca.nrc.cadc.vos.NodeNotSupportedException;
import ca.nrc.cadc.vos.NodeParsingException;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.server.web.representation.NodeInputRepresentation;
import ca.nrc.cadc.vos.server.web.representation.NodeOutputRepresentation;
import ca.nrc.cadc.vos.server.web.restlet.action.NodeAction;
import ca.nrc.cadc.vos.server.web.restlet.action.NodeActionResult;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import org.apache.log4j.Logger;
import org.restlet.data.Status;
import org.restlet.representation.Representation;

public class CreateNodeAction
extends NodeAction {
    protected static Logger log = Logger.getLogger(CreateNodeAction.class);

    public Node getClientNode() throws URISyntaxException, NodeParsingException, IOException {
        NodeInputRepresentation nodeInputRepresentation = new NodeInputRepresentation(this.nodeXML, this.vosURI.getPath());
        return nodeInputRepresentation.getNode();
    }

    public Node doAuthorizationCheck() throws AccessControlException, FileNotFoundException, TransientException {
        try {
            VOSURI parentURI = this.vosURI.getParentURI();
            Node node = this.nodePersistence.get(parentURI);
            this.voSpaceAuthorizer.getWritePermission(node);
            return node;
        }
        catch (NodeNotFoundException ex) {
            throw new FileNotFoundException("not found: " + this.vosURI.getURI().toASCIIString());
        }
    }

    public NodeActionResult performNodeAction(Node clientNode, Node serverNode) throws TransientException {
        try {
            if (serverNode instanceof ContainerNode) {
                ContainerNode parent = (ContainerNode)serverNode;
                this.nodePersistence.getChild(parent, clientNode.getName());
                for (Node n : parent.getNodes()) {
                    if (!n.getName().equals(clientNode.getName())) continue;
                    throw new NodeAlreadyExistsException(this.vosURI.getURI().toASCIIString());
                }
                clientNode.setParent(parent);
                Node storedNode = this.nodePersistence.put(clientNode);
                NodeOutputRepresentation nodeOutputRepresentation = new NodeOutputRepresentation(storedNode, this.getNodeWriter(), this.getMediaType());
                return new NodeActionResult((Representation)nodeOutputRepresentation, Status.SUCCESS_OK);
            }
            log.debug("parent is not a container: " + clientNode.getUri().getPath());
            NodeFault nodeFault = NodeFault.ContainerNotFound;
            nodeFault.setMessage(clientNode.getUri().toString());
            return new NodeActionResult(nodeFault);
        }
        catch (NodeAlreadyExistsException e) {
            log.debug("Node already exists: " + clientNode.getUri().getPath(), e);
            NodeFault nodeFault = NodeFault.DuplicateNode;
            nodeFault.setMessage(clientNode.getUri().toString());
            return new NodeActionResult(nodeFault);
        }
        catch (NodeNotSupportedException e) {
            log.debug("Node type not supported: " + clientNode.getUri().getPath(), e);
            NodeFault nodeFault = NodeFault.TypeNotSupported;
            nodeFault.setMessage(clientNode.getUri().toString());
            return new NodeActionResult(nodeFault);
        }
    }
}

