/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.web.restlet.action;

import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeFault;
import ca.nrc.cadc.vos.NodeNotFoundException;
import ca.nrc.cadc.vos.NodeParsingException;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.server.web.restlet.action.NodeAction;
import ca.nrc.cadc.vos.server.web.restlet.action.NodeActionResult;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import org.apache.log4j.Logger;

public class DeleteNodeAction
extends NodeAction {
    private static final Logger log = Logger.getLogger(DeleteNodeAction.class);

    public Node getClientNode() throws URISyntaxException, NodeParsingException, IOException {
        return null;
    }

    public Node doAuthorizationCheck() throws AccessControlException, FileNotFoundException, TransientException {
        try {
            VOSURI parentURI = this.vosURI.getParentURI();
            if (this.vosURI.isRoot() || parentURI.isRoot()) {
                throw new AccessControlException("permission denied");
            }
            Node target = this.nodePersistence.get(this.vosURI);
            log.debug("Checking delete privilege on: " + target.getUri());
            this.voSpaceAuthorizer.getDeletePermission(target);
            return target;
        }
        catch (NodeNotFoundException ex) {
            throw new FileNotFoundException("not found: " + this.vosURI.getURI().toASCIIString());
        }
    }

    public NodeActionResult performNodeAction(Node clientNode, Node serverNode) throws TransientException {
        this.nodePersistence.delete(serverNode);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeFault handleException(FileNotFoundException fnf) throws TransientException {
        if (this.vosURI.isRoot()) {
            return NodeFault.NodeNotFound;
        }
        VOSURI parentURI = this.vosURI.getParentURI();
        if (parentURI.isRoot()) {
            return NodeFault.NodeNotFound;
        }
        try {
            Node target = this.nodePersistence.get(parentURI);
            this.voSpaceAuthorizer.getReadPermission(target);
        }
        catch (NodeNotFoundException nnf) {
            NodeFault nodeFault = NodeFault.ContainerNotFound;
            return nodeFault;
        }
        catch (AccessControlException ac) {
            NodeFault nodeFault = NodeFault.PermissionDenied;
            return nodeFault;
        }
        return NodeFault.NodeNotFound;
    }
}

