/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.web.restlet.action;

import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.LinkingException;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeNotFoundException;
import ca.nrc.cadc.vos.NodeParsingException;
import ca.nrc.cadc.vos.NodeWriter;
import ca.nrc.cadc.vos.VOS;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.server.AbstractView;
import ca.nrc.cadc.vos.server.PathResolver;
import ca.nrc.cadc.vos.server.web.representation.NodeOutputRepresentation;
import ca.nrc.cadc.vos.server.web.representation.ViewRepresentation;
import ca.nrc.cadc.vos.server.web.restlet.action.NodeAction;
import ca.nrc.cadc.vos.server.web.restlet.action.NodeActionResult;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.restlet.data.Reference;
import org.restlet.representation.Representation;

public class GetNodeAction
extends NodeAction {
    protected static Logger log = Logger.getLogger(GetNodeAction.class);

    protected Node getClientNode() throws URISyntaxException, NodeParsingException, IOException {
        return null;
    }

    public Node doAuthorizationCheck() throws AccessControlException, FileNotFoundException, LinkingException, TransientException {
        PathResolver pathResolver = new PathResolver(this.nodePersistence);
        try {
            return pathResolver.resolveWithReadPermissionCheck(this.vosURI, this.partialPathVOSpaceAuthorizer, false);
        }
        catch (NodeNotFoundException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public NodeActionResult performNodeAction(Node clientNode, Node serverNode) throws URISyntaxException, FileNotFoundException, TransientException {
        AbstractView view;
        long end;
        long start;
        if (serverNode instanceof ContainerNode) {
            String startURI = this.queryForm.getFirstValue("uri");
            String pageLimitString = this.queryForm.getFirstValue("limit");
            ContainerNode cn = (ContainerNode)serverNode;
            boolean paginate = false;
            VOSURI startURIObject = null;
            Integer pageLimit = null;
            if (pageLimitString != null) {
                try {
                    pageLimit = new Integer(pageLimitString);
                    paginate = true;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("value for limit must be an integer.");
                }
            }
            if (StringUtil.hasText(startURI)) {
                startURIObject = new VOSURI(startURI);
                if (!this.vosURI.equals(startURIObject.getParentURI())) {
                    throw new IllegalArgumentException("uri parameter not a child of target uri.");
                }
                paginate = true;
            }
            start = System.currentTimeMillis();
            if (cn.getUri().isRoot()) {
                this.nodePersistence.getChildren(cn, startURIObject, null);
                log.debug(String.format("Get children on root returned [%s] nodes with startURI=[%s], pageLimit=[%s].", cn.getNodes().size(), startURI, null));
            } else if (paginate) {
                if (pageLimit != null && pageLimit < 1) {
                    log.debug("Get children not called becauase pageLimit < 1");
                } else {
                    this.nodePersistence.getChildren(cn, startURIObject, pageLimit);
                    log.debug(String.format("Get children returned [%s] nodes with startURI=[%s], pageLimit=[%s].", cn.getNodes().size(), startURI, pageLimit));
                }
            } else {
                this.nodePersistence.getChildren(cn);
                log.debug(String.format("Get children returned [%s] nodes.", cn.getNodes().size()));
            }
            end = System.currentTimeMillis();
            log.debug("nodePersistence.getChildren() elapsed time: " + (end - start) + "ms");
            this.doFilterChildren(cn, pageLimit);
        }
        String detailLevel = this.queryForm.getFirstValue("detail");
        start = System.currentTimeMillis();
        if (!VOS.Detail.min.getValue().equals(detailLevel)) {
            this.nodePersistence.getProperties(serverNode);
        }
        end = System.currentTimeMillis();
        log.debug("nodePersistence.getProperties() elapsed time: " + (end - start) + "ms");
        String viewReference = this.queryForm.getFirstValue("view");
        try {
            view = this.getView();
        }
        catch (Exception ex) {
            log.error("failed to load view: " + viewReference, ex);
            throw new RuntimeException("view was configured but failed to load: " + viewReference);
        }
        if (view == null) {
            NodeWriter nodeWriter = this.getNodeWriter();
            nodeWriter.setStylesheetURL(this.getStylesheetURL());
            if (VOS.Detail.min.getValue().equals(detailLevel)) {
                serverNode.getProperties().clear();
            }
            return new NodeActionResult((Representation)new NodeOutputRepresentation(serverNode, nodeWriter, this.getMediaType()));
        }
        Reference ref = this.request.getOriginalRef();
        URL url = ref.toUrl();
        view.setNode(serverNode, viewReference, url);
        URL redirectURL = view.getRedirectURL();
        if (redirectURL != null) {
            return new NodeActionResult(redirectURL);
        }
        return new NodeActionResult((Representation)new ViewRepresentation(view));
    }

    public String getStylesheetURL() {
        log.debug("Stylesheet Reference is: " + this.stylesheetReference);
        if (this.stylesheetReference != null) {
            String scheme = this.request.getHostRef().getScheme();
            String server = this.request.getHostRef().getHostDomain();
            StringBuilder url = new StringBuilder();
            url.append(scheme);
            url.append("://");
            url.append(server);
            if (!this.stylesheetReference.startsWith("/")) {
                url.append("/");
            }
            url.append(this.stylesheetReference);
            return url.toString();
        }
        return null;
    }

    private void doFilterChildren(ContainerNode node, Integer pageLimit) {
        if (!node.getUri().isRoot()) {
            return;
        }
        ListIterator<Node> iter = node.getNodes().listIterator();
        int nodeCount = 0;
        boolean metLimit = false;
        while (iter.hasNext() && !metLimit) {
            Node n = iter.next();
            try {
                this.voSpaceAuthorizer.getReadPermission(n);
                if (pageLimit == null || ++nodeCount < pageLimit) continue;
                metLimit = true;
            }
            catch (AccessControlException ex) {
                log.debug("doFilterChildren: remove " + n);
                iter.remove();
            }
        }
        if (pageLimit != null && node.getNodes().size() > pageLimit) {
            log.debug("Reducing child list size from " + node.getNodes().size() + " to " + pageLimit + " to meet limit request on root node.");
            node.setNodes(node.getNodes().subList(0, pageLimit));
        }
    }
}

