/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.web.restlet.action;

import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeParsingException;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.VOS;
import ca.nrc.cadc.vos.server.web.representation.NodeInputRepresentation;
import ca.nrc.cadc.vos.server.web.representation.NodeOutputRepresentation;
import ca.nrc.cadc.vos.server.web.restlet.action.NodeAction;
import ca.nrc.cadc.vos.server.web.restlet.action.NodeActionResult;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import org.apache.log4j.Logger;
import org.restlet.representation.Representation;

public class UpdatePropertiesAction
extends NodeAction {
    private static Logger log = Logger.getLogger(UpdatePropertiesAction.class);

    public Node getClientNode() throws URISyntaxException, NodeParsingException, IOException {
        NodeInputRepresentation nodeInputRepresentation = new NodeInputRepresentation(this.nodeXML, this.vosURI.getPath());
        return nodeInputRepresentation.getNode();
    }

    public Node doAuthorizationCheck() throws AccessControlException, FileNotFoundException, TransientException {
        this.voSpaceAuthorizer.setDisregardLocks(true);
        Node node = (Node)this.voSpaceAuthorizer.getWritePermission(this.vosURI.getURI());
        return node;
    }

    public NodeActionResult performNodeAction(Node clientNode, Node serverNode) throws TransientException {
        this.filterPropertiesForUpdate(clientNode);
        this.nodePersistence.getProperties(serverNode);
        Node out = this.nodePersistence.updateProperties(serverNode, clientNode.getProperties());
        return new NodeActionResult((Representation)new NodeOutputRepresentation(out, this.getNodeWriter(), this.getMediaType()));
    }

    private void filterPropertiesForUpdate(Node node) {
        for (String propertyURI : VOS.READ_ONLY_PROPERTIES) {
            int propertyIndex = node.getProperties().indexOf(new NodeProperty(propertyURI, ""));
            if (propertyIndex == -1) continue;
            node.getProperties().remove(propertyIndex);
        }
    }
}

