/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.web.restlet.resource;

import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.uws.util.RestletLogInfo;
import ca.nrc.cadc.vos.NodeFault;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.server.auth.VOSpaceAuthorizer;
import ca.nrc.cadc.vos.server.web.representation.NodeErrorRepresentation;
import ca.nrc.cadc.vos.server.web.restlet.action.CreateNodeAction;
import ca.nrc.cadc.vos.server.web.restlet.action.DeleteNodeAction;
import ca.nrc.cadc.vos.server.web.restlet.action.GetNodeAction;
import ca.nrc.cadc.vos.server.web.restlet.action.NodeAction;
import ca.nrc.cadc.vos.server.web.restlet.action.NodeActionResult;
import ca.nrc.cadc.vos.server.web.restlet.action.UpdatePropertiesAction;
import ca.nrc.cadc.vos.server.web.restlet.resource.BaseResource;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.security.PrivilegedAction;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.restlet.representation.Representation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.Put;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeResource
extends BaseResource
implements PrivilegedAction<Representation> {
    private static Logger LOGGER = Logger.getLogger(NodeResource.class);
    private NodeFault nodeFault;
    private VOSURI vosURI;
    private NodeAction action;
    private RestletLogInfo logInfo;

    @Override
    public void doInit() {
        LOGGER.debug("Enter NodeResource.doInit(): " + this.getMethod());
        try {
            super.doInit();
            String path = (String)this.getRequest().getAttributes().get("nodePath");
            LOGGER.debug("path = " + path);
            LOGGER.debug("prefix = " + this.getVosUriPrefix());
            this.vosURI = path != null ? new VOSURI(this.getVosUriPrefix() + "/" + path) : new VOSURI(this.getVosUriPrefix());
            LOGGER.debug("vosURI = " + this.vosURI);
        }
        catch (URISyntaxException e) {
            String message = "URI not well formed: " + this.vosURI;
            LOGGER.debug(message, e);
            this.nodeFault = NodeFault.InvalidURI;
            this.nodeFault.setMessage(message);
        }
        catch (AccessControlException e) {
            String message = "Access Denied: " + e.getMessage();
            LOGGER.debug(message, e);
            this.nodeFault = NodeFault.PermissionDenied;
            this.nodeFault.setMessage(message);
        }
        catch (UnsupportedOperationException e) {
            String message = "Not supported: " + e.getMessage();
            LOGGER.debug(message, e);
            this.nodeFault = NodeFault.InvalidArgument;
            this.nodeFault.setMessage(message);
        }
        catch (IllegalArgumentException e) {
            String message = "Bad input: " + e.getMessage();
            LOGGER.debug(message, e);
            this.nodeFault = NodeFault.InvalidArgument;
            this.nodeFault.setMessage(message);
        }
        catch (Throwable t) {
            String message = "Internal Error:" + t.getMessage();
            LOGGER.debug(message, t);
            this.nodeFault = NodeFault.InternalFault;
            this.nodeFault.setMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Representation run() {
        Object partialPathVOSpaceAuthorizer;
        LOGGER.debug("Enter NodeResource.run()");
        long start = System.currentTimeMillis();
        long end = -1L;
        StringBuilder message = new StringBuilder();
        try {
            String startMessage = this.logInfo.start();
            LOGGER.info(startMessage);
            if (this.nodeFault != null) {
                this.setStatus(this.nodeFault.getStatus());
                this.logInfo.setSuccess(false);
                this.logInfo.setMessage(this.getErrorMessage(this.nodeFault));
                NodeErrorRepresentation nodeErrorRepresentation = new NodeErrorRepresentation(this.nodeFault);
                return nodeErrorRepresentation;
            }
            VOSpaceAuthorizer voSpaceAuthorizer = new VOSpaceAuthorizer(false);
            partialPathVOSpaceAuthorizer = new VOSpaceAuthorizer(true);
            voSpaceAuthorizer.setNodePersistence(this.getNodePersistence());
            partialPathVOSpaceAuthorizer.setNodePersistence(this.getNodePersistence());
            this.action.setVOSpaceAuthorizer(voSpaceAuthorizer);
            this.action.setPartialPathVOSpaceAuthorizer((VOSpaceAuthorizer)partialPathVOSpaceAuthorizer);
            this.action.setNodePersistence(this.getNodePersistence());
            this.action.setVosURI(this.vosURI);
            this.action.setNodeXML(this.getRequestEntity());
            this.action.setRequest(this.getRequest());
            this.action.setQueryForm(this.getQueryForm());
            this.action.setStylesheetReference(this.getStylesheetReference());
            NodeActionResult result = this.action.run();
            if (result != null) {
                if (result.getNodeFault() != null) {
                    message.append(this.getErrorMessage(result.getNodeFault()));
                    this.logInfo.setSuccess(!result.getNodeFault().isServiceFailure());
                }
                this.setStatus(result.getStatus());
                if (result.getRedirectURL() != null) {
                    if (message.length() > 0) {
                        message.append(" ");
                    }
                    message.append("Redirecting to: " + result.getRedirectURL().toExternalForm());
                    this.getResponse().redirectSeeOther(result.getRedirectURL().toString());
                } else {
                    Representation representation = result.getRepresentation();
                    return representation;
                }
            }
            Representation representation = null;
            return representation;
        }
        catch (TransientException t) {
            LOGGER.debug(t);
            this.logInfo.setSuccess(false);
            if (message.length() > 0) {
                message.append(" ");
            }
            message.append("Transient exception: " + t.getMessage());
            this.setStatus(NodeFault.ServiceBusy.getStatus());
            GregorianCalendar retryTime = new GregorianCalendar();
            LOGGER.debug("After transient exception, setting retry-after to be " + t.getRetryDelay() + " seconds.");
            ((Calendar)retryTime).add(13, t.getRetryDelay());
            this.getResponse().setRetryAfter(retryTime.getTime());
            partialPathVOSpaceAuthorizer = new NodeErrorRepresentation(NodeFault.ServiceBusy);
            return partialPathVOSpaceAuthorizer;
        }
        catch (Throwable t) {
            LOGGER.debug("OOPS", t);
            this.setStatus(NodeFault.InternalFault.getStatus());
            this.logInfo.setSuccess(false);
            if (message.length() > 0) {
                message.append(" ");
            }
            message.append(this.getErrorMessage(NodeFault.InternalFault));
            message.append(": ").append(t.getClass().getSimpleName());
            message.append(": ").append(t.getMessage());
            NodeErrorRepresentation nodeErrorRepresentation = new NodeErrorRepresentation(NodeFault.InternalFault);
            return nodeErrorRepresentation;
        }
        finally {
            end = System.currentTimeMillis();
            this.logInfo.setElapsedTime(end - start);
            this.logInfo.setMessage(message.toString());
            String endMessage = this.logInfo.end();
            LOGGER.info(endMessage);
        }
    }

    private Representation runPrivilegedAction(NodeAction action) {
        this.action = action;
        this.logInfo = new RestletLogInfo(this.getRequest());
        Subject subject = this.getSubject();
        if (subject == null) {
            return this.run();
        }
        this.logInfo.setSubject(subject);
        return Subject.doAs(this.getSubject(), this);
    }

    @Get(value="xml")
    public Representation represent() {
        LOGGER.debug("Enter NodeResource.represent()");
        return this.runPrivilegedAction(new GetNodeAction());
    }

    @Put
    public Representation create(Representation entity) {
        LOGGER.debug("Enter NodeResource.store()");
        return this.runPrivilegedAction(new CreateNodeAction());
    }

    @Post
    public Representation update(Representation entity) {
        LOGGER.debug("Enter NodeResource.accept()");
        return this.runPrivilegedAction(new UpdatePropertiesAction());
    }

    @Delete
    public Representation remove() {
        LOGGER.debug("Enter NodeResource.remove()");
        return this.runPrivilegedAction(new DeleteNodeAction());
    }
}

