/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.AbstractLazyCreationTargetSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;

public class MBeanServerConnectionFactoryBean
implements FactoryBean,
BeanClassLoaderAware,
InitializingBean,
DisposableBean {
    private JMXServiceURL serviceUrl;
    private Map environment;
    private boolean connectOnStartup = true;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private JMXConnector connector;
    private MBeanServerConnection connection;
    private JMXConnectorLazyInitTargetSource connectorTargetSource;

    public void setServiceUrl(String url) throws MalformedURLException {
        this.serviceUrl = new JMXServiceURL(url);
    }

    public void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public void setEnvironmentMap(Map environment) {
        this.environment = environment;
    }

    public void setConnectOnStartup(boolean connectOnStartup) {
        this.connectOnStartup = connectOnStartup;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void afterPropertiesSet() throws IOException {
        if (this.serviceUrl == null) {
            throw new IllegalArgumentException("Property 'serviceUrl' is required");
        }
        if (this.connectOnStartup) {
            this.connect();
        } else {
            this.createLazyConnection();
        }
    }

    private void connect() throws IOException {
        this.connector = JMXConnectorFactory.connect(this.serviceUrl, this.environment);
        this.connection = this.connector.getMBeanServerConnection();
    }

    private void createLazyConnection() {
        this.connectorTargetSource = new JMXConnectorLazyInitTargetSource();
        MBeanServerConnectionLazyInitTargetSource connectionTargetSource = new MBeanServerConnectionLazyInitTargetSource();
        this.connector = (JMXConnector)new ProxyFactory(JMXConnector.class, this.connectorTargetSource).getProxy(this.beanClassLoader);
        this.connection = (MBeanServerConnection)new ProxyFactory(MBeanServerConnection.class, connectionTargetSource).getProxy(this.beanClassLoader);
    }

    public Object getObject() {
        return this.connection;
    }

    public Class getObjectType() {
        return this.connection != null ? this.connection.getClass() : MBeanServerConnection.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws IOException {
        if (this.connectorTargetSource == null || this.connectorTargetSource.isInitialized()) {
            this.connector.close();
        }
    }

    private class JMXConnectorLazyInitTargetSource
    extends AbstractLazyCreationTargetSource {
        private JMXConnectorLazyInitTargetSource() {
        }

        protected Object createObject() throws Exception {
            return JMXConnectorFactory.connect(MBeanServerConnectionFactoryBean.this.serviceUrl, MBeanServerConnectionFactoryBean.this.environment);
        }

        public Class getTargetClass() {
            return class$javax$management$remote$JMXConnector == null ? (class$javax$management$remote$JMXConnector = MBeanServerConnectionFactoryBean.class$("javax.management.remote.JMXConnector")) : class$javax$management$remote$JMXConnector;
        }
    }

    private class MBeanServerConnectionLazyInitTargetSource
    extends AbstractLazyCreationTargetSource {
        private MBeanServerConnectionLazyInitTargetSource() {
        }

        protected Object createObject() throws Exception {
            return MBeanServerConnectionFactoryBean.this.connector.getMBeanServerConnection();
        }

        public Class getTargetClass() {
            return class$javax$management$MBeanServerConnection == null ? (class$javax$management$MBeanServerConnection = MBeanServerConnectionFactoryBean.class$("javax.management.MBeanServerConnection")) : class$javax$management$MBeanServerConnection;
        }
    }
}

