/**
 *
 * @author bertocco
 */
package it.inaf.oats.vospacebackend.exceptions;

import java.util.ResourceBundle;
import java.util.HashMap;
import java.util.Enumeration;

import org.apache.log4j.Logger;

public class ExceptionMessage {
    
    private static HashMap myMessagesProperties = new HashMap<String, String>();
    protected static Logger log = Logger.getLogger(ExceptionMessage.class);
    
    public ExceptionMessage() {
        
        ResourceBundle rb = null; 
        try {
            ResourceBundle.getBundle("it.inaf.oats.vospacebackend.exceptions.exceptionMessages");
        } catch (Exception e) { 
            log.debug("Super unluky! Unable to read exception messages");
            log.debug(e);           
        }
        Enumeration <String> keys = rb.getKeys();
	while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = rb.getString(key);
            myMessagesProperties.put(key, value);
            log.debug("Reading VOSpaceBackend exception messages:");
            log.debug(key + " = " + value);
        }
    }
    
    
    public static String getMessage(String msgKey) {
        
        String excMsg = (String)myMessagesProperties.get(msgKey);
        log.debug("Getting message:");
        log.debug(excMsg);
        return excMsg;
    }
}
