/*
 *
 * @author bertocco
 */
package it.inaf.oats.vospacebackend.implementation;

import java.util.List;

import org.apache.log4j.Logger;
import ca.nrc.cadc.util.PropertiesReader;
import it.inaf.oats.vospacebackend.exceptions.ExceptionMessage;
import it.inaf.oats.vospacebackend.exceptions.VOSpaceBackendException;
import it.inaf.oats.vospacebackend.utils.ConfigReader;

import java.text.MessageFormat;

public class VOSpaceBackImplFactory {
    
    private static final String CONFIG_FILE_NAME = "VOSpace.properties";
    private static final Logger log = Logger.getLogger(VOSpaceBackImplFactory.class);
    private static String VOSpaceBackImplName = new String();
    
    public VOSpaceBackImplFactory() throws VOSpaceBackendException {
        
        ConfigReader myConf = null;
        try {
            myConf = new ConfigReader(CONFIG_FILE_NAME);  
        } catch (Exception e) {
            ExceptionMessage exMsg = new ExceptionMessage();
            log.debug(MessageFormat.format(exMsg.getMessage("UNABLE_TO_READ_PROPERTIES"), CONFIG_FILE_NAME));
            throw new VOSpaceBackendException(                   
               MessageFormat.format(exMsg.getMessage("UNABLE_TO_READ_PROPERTIES"), CONFIG_FILE_NAME));
            
        }
        
        try {       
            this.VOSpaceBackImplName = myConf.getProperty("it.inaf.oats.vospacebackendimplementation.VOSpaceBackendImpl");     
        } catch (Exception e) {     
            ExceptionMessage exMsg = new ExceptionMessage();
            log.debug(MessageFormat.format(
                       exMsg.getMessage("PROPERTY_NOT_FOUND"), 
                                        "it.inaf.oats.vospacebackendimplementation.VOSpaceBackendImpl", 
                                        CONFIG_FILE_NAME));
            throw new VOSpaceBackendException(
               MessageFormat.format(
                       exMsg.getMessage("PROPERTY_NOT_FOUND"), 
                                        "it.inaf.oats.vospacebackendimplementation.VOSpaceBackendImpl", 
                                        CONFIG_FILE_NAME));            
        }
       
    }
    
    public VOSpaceBackend getVOSpaceBackImpl() throws VOSpaceBackendException {
        
        log.debug("Try to get object: " + this.VOSpaceBackImplName);
        return (VOSpaceBackend)this.buildObject(this.VOSpaceBackImplName);
        
    }
    
    private Object buildObject(String myBackendImpl) throws VOSpaceBackendException {
        
        Object result = null;
        try {
            //note that, with this style, the implementation needs to have a
            //no-argument constructor!
            Class implClass = Class.forName(myBackendImpl);
            result = implClass.newInstance();
        } catch (ClassNotFoundException ex) {
            log.debug("CLASS_NOT_FOUND");
            ExceptionMessage exMsg = new ExceptionMessage();
            throw new VOSpaceBackendException(MessageFormat.format(exMsg.getMessage("CLASS_NOT_FOUND"), myBackendImpl));
        } catch (InstantiationException ex) {
            log.debug("UNABLE_TO_INSTANTIATE");
            ExceptionMessage exMsg = new ExceptionMessage();
            throw new VOSpaceBackendException(MessageFormat.format(exMsg.getMessage("UNABLE_TO_INSTANTIATE"), myBackendImpl));
        } catch (IllegalAccessException ex) {
            log.debug("UNABLE_TO_ACCESS");
            ExceptionMessage exMsg = new ExceptionMessage();
            throw new VOSpaceBackendException(MessageFormat.format(exMsg.getMessage("UNABLE_TO_ACCESS"), myBackendImpl));
        }
        return result;
        
    }    
    
}
