/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.IdentityManager;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;

public class X500IdentityManager
implements IdentityManager {
    public int getOwnerType() {
        return 12;
    }

    public Object toOwner(Subject subject) {
        String dn = this.toOwnerString(subject);
        if (dn != null) {
            return AuthenticationUtil.canonizeDistinguishedName(dn);
        }
        return dn;
    }

    public String toOwnerString(Subject subject) {
        if (subject != null) {
            Set<Principal> principals = subject.getPrincipals();
            for (Principal principal : principals) {
                if (!(principal instanceof X500Principal)) continue;
                return principal.getName();
            }
        }
        return null;
    }

    public Subject toSubject(Object owner) {
        String str = (String)owner;
        X500Principal p = new X500Principal(str);
        HashSet<X500Principal> pset = new HashSet<X500Principal>();
        pset.add(p);
        return new Subject(false, pset, new HashSet(), new HashSet());
    }
}

