/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.auth.SSOCookieCredential;
import ca.nrc.cadc.net.HttpRequestProperty;
import ca.nrc.cadc.net.OverwriteChooser;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.net.event.ProgressListener;
import ca.nrc.cadc.net.event.TransferEvent;
import ca.nrc.cadc.net.event.TransferListener;
import ca.nrc.cadc.util.FileMetadata;
import ca.nrc.cadc.util.HexUtil;
import ca.nrc.cadc.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpTransfer
implements Runnable {
    private static Logger log = Logger.getLogger(HttpTransfer.class);
    public static String DEFAULT_USER_AGENT;
    public static final String CADC_CONTENT_LENGTH_HEADER = "X-CADC-Content-Length";
    public static final String CADC_STREAM_HEADER = "X-CADC-Stream";
    public static final String CADC_PARTIAL_READ_HEADER = "X-CADC-Partial-Read";
    public static final String SERVICE_RETRY = "Retry-After";
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int MAX_RETRY_DELAY = 128;
    public static final int DEFAULT_RETRY_DELAY = 30;
    protected int maxRetries = 3;
    protected int retryDelay = 1;
    protected RetryReason retryReason = RetryReason.TRANSIENT;
    protected int numRetries = 0;
    protected int curRetryDelay = 0;
    protected int bufferSize = 8192;
    protected OverwriteChooser overwriteChooser;
    protected ProgressListener progressListener;
    protected TransferListener transferListener;
    protected boolean fireEvents = false;
    protected boolean fireCancelOnce = true;
    protected List<HttpRequestProperty> requestProperties;
    protected String userAgent;
    protected boolean use_nio = false;
    protected boolean go;
    protected Thread thread;
    protected URL remoteURL;
    protected File localFile;
    public String eventID = null;
    public Throwable failure;
    protected boolean followRedirects = false;
    protected URL redirectURL;
    protected int responseCode = -1;
    private SSLSocketFactory sslSocketFactory;

    protected HttpTransfer(boolean followRedirects) {
        this.followRedirects = followRedirects;
        this.go = true;
        this.requestProperties = new ArrayList<HttpRequestProperty>();
        this.userAgent = DEFAULT_USER_AGENT;
        String bsize = null;
        try {
            bsize = System.getProperty(HttpTransfer.class.getName() + ".bufferSize");
            if (bsize != null) {
                int mult = 1;
                String sz = bsize;
                if ((bsize = bsize.trim()).endsWith("k")) {
                    mult = 1024;
                    sz = bsize.substring(0, bsize.length() - 1);
                } else if (bsize.endsWith("m")) {
                    mult = 0x100000;
                    sz = bsize.substring(0, bsize.length() - 1);
                }
                this.bufferSize = mult * Integer.parseInt(sz);
            }
        }
        catch (NumberFormatException warn) {
            log.warn((Object)("invalid buffer size: " + bsize + ", using default " + 8192));
            this.bufferSize = 8192;
        }
        log.debug((Object)("bufferSize: " + this.bufferSize));
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public URL getRedirectURL() {
        return this.redirectURL;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRetry(int maxRetries, int retryDelay, RetryReason reason) {
        this.maxRetries = maxRetries;
        this.retryDelay = retryDelay;
        this.retryReason = reason;
    }

    public URL getURL() {
        return this.remoteURL;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        if (userAgent == null) {
            this.userAgent = DEFAULT_USER_AGENT;
        }
    }

    public void setRequestProperty(String header, String value) {
        this.requestProperties.add(new HttpRequestProperty(header, value));
    }

    public void setRequestProperties(List<HttpRequestProperty> props) {
        if (props != null) {
            log.debug((Object)("add request properties: " + props.size()));
            this.requestProperties.addAll(props);
        }
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setOverwriteChooser(OverwriteChooser overwriteChooser) {
        this.overwriteChooser = overwriteChooser;
    }

    public void setProgressListener(ProgressListener listener) {
        this.progressListener = listener;
        this.fireEvents = this.progressListener != null || this.transferListener != null;
    }

    public void setTransferListener(TransferListener listener) {
        this.transferListener = listener;
        this.fireEvents = this.progressListener != null || this.transferListener != null;
    }

    public int getRetriesPerformed() {
        return this.numRetries;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Throwable getThrowable() {
        return this.failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.fireEvents = false;
        this.go = false;
        HttpTransfer httpTransfer = this;
        synchronized (httpTransfer) {
            if (this.thread != null) {
                log.debug((Object)("terminate(): interrupting " + this.thread.getName()));
                try {
                    this.thread.interrupt();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.fireCancelledEvent();
        this.fireCancelOnce = false;
    }

    protected void checkTransient(int code, String msg, HttpURLConnection conn) throws TransientException {
        if (RetryReason.NONE.equals((Object)this.retryReason)) {
            return;
        }
        boolean trans = false;
        int dt = 0;
        if (code == 503) {
            msg = "server busy";
            String retryAfter = conn.getHeaderField(SERVICE_RETRY);
            log.debug((Object)("got 503 with Retry-After: " + retryAfter));
            if (StringUtil.hasText(retryAfter)) {
                try {
                    dt = Integer.parseInt(retryAfter);
                    trans = true;
                    if (dt > 128) {
                        dt = 128;
                    }
                }
                catch (NumberFormatException nex) {
                    log.warn((Object)("Retry-After after a 503 was not a number: " + retryAfter + ", ignoring"));
                }
            }
        }
        if (RetryReason.TRANSIENT.equals((Object)this.retryReason)) {
            switch (code) {
                case 402: 
                case 408: 
                case 412: 
                case 503: 
                case 504: {
                    trans = true;
                }
            }
        }
        if (RetryReason.ALL.equals((Object)this.retryReason)) {
            trans = true;
        }
        if (trans && this.numRetries < this.maxRetries) {
            if (dt == 0) {
                if (this.curRetryDelay == 0) {
                    this.curRetryDelay = this.retryDelay;
                }
                if (this.curRetryDelay > 0) {
                    dt = this.curRetryDelay;
                    this.curRetryDelay *= 2;
                } else {
                    dt = 30;
                }
            }
            ++this.numRetries;
            throw new TransientException(msg, dt);
        }
    }

    protected void findEventID(HttpURLConnection conn) {
        String eventHeader = null;
        if (this.transferListener != null) {
            eventHeader = this.transferListener.getEventHeader();
        }
        if (eventHeader != null) {
            this.eventID = conn.getHeaderField(eventHeader);
        }
    }

    private void fireCancelledEvent() {
        if (this.fireCancelOnce) {
            TransferEvent e = new TransferEvent((Object)this, this.eventID, this.remoteURL, this.localFile, 6);
            this.fireEvent(e);
        }
    }

    private void fireEvent(TransferEvent e) {
        log.debug((Object)("fireEvent: " + e));
        if (this.transferListener != null) {
            this.transferListener.transferEvent(e);
        }
        if (this.progressListener != null) {
            this.progressListener.transferEvent(e);
        }
    }

    protected void fireEvent(int state) {
        this.fireEvent(this.localFile, state);
    }

    protected void fireEvent(File file, int state) {
        this.fireEvent(file, state, null);
    }

    protected void fireEvent(File file, int state, FileMetadata meta) {
        if (this.fireEvents) {
            TransferEvent e = new TransferEvent((Object)this, this.eventID, this.remoteURL, file, state);
            e.setFileMetadata(meta);
            this.fireEvent(e);
        }
    }

    protected void fireEvent(Throwable t) {
        this.fireEvent(this.localFile, t);
    }

    protected void fireEvent(File file, Throwable t) {
        if (this.fireEvents) {
            TransferEvent e = new TransferEvent((Object)this, this.eventID, this.remoteURL, file, t);
            this.fireEvent(e);
        }
    }

    protected void initHTTPS(HttpsURLConnection sslConn) {
        if (this.sslSocketFactory == null) {
            log.debug((Object)"initHTTPS: lazy init");
            AccessControlContext ac = AccessController.getContext();
            Subject s = Subject.getSubject(ac);
            this.sslSocketFactory = SSLUtil.getSocketFactory(s);
        }
        if (this.sslSocketFactory != null) {
            log.debug((Object)("setting SSLSocketFactory on " + sslConn.getClass().getName()));
            sslConn.setSSLSocketFactory(this.sslSocketFactory);
        }
    }

    protected String ioLoop(InputStream istream, OutputStream ostream, int sz, long startingPos) throws IOException, InterruptedException {
        log.debug((Object)("ioLoop: using java.io with byte[] buffer size " + sz + " startingPos " + startingPos));
        byte[] buf = new byte[sz];
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException oops) {
            log.warn((Object)("failed to create MessageDigest(MD5): " + oops));
        }
        int nb = 0;
        int nb2 = 0;
        long tot = startingPos;
        boolean n = false;
        if (this.progressListener != null) {
            this.progressListener.update(0L, tot);
        }
        while (nb != -1) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            nb = istream.read(buf, 0, sz);
            if (nb == -1) continue;
            if (nb < sz / 2 && (nb2 = istream.read(buf, nb, sz - nb)) > 0) {
                nb += nb2;
            }
            if (md5 != null) {
                md5.update(buf, 0, nb);
            }
            ostream.write(buf, 0, nb);
            tot += (long)nb;
            if (this.progressListener == null) continue;
            this.progressListener.update(nb, tot);
        }
        if (md5 != null) {
            byte[] md5sum = md5.digest();
            String ret = HexUtil.toHex(md5sum);
            return ret;
        }
        return null;
    }

    protected void nioLoop(InputStream istream, OutputStream ostream, int sz, long startingPos) throws IOException, InterruptedException {
        log.debug((Object)("[Download] nioLoop: using java.nio with ByteBuffer size " + sz));
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException oops) {
            log.warn((Object)("failed to create MessageDigest(MD5): " + oops));
        }
        ReadableByteChannel rbc = Channels.newChannel(istream);
        WritableByteChannel wbc = Channels.newChannel(ostream);
        long tot = startingPos;
        int count = 0;
        ByteBuffer buffer = ByteBuffer.allocate(sz);
        if (this.progressListener != null) {
            this.progressListener.update(count, tot);
        }
        while (count != -1) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            count = rbc.read(buffer);
            if (count == -1) continue;
            wbc.write((ByteBuffer)buffer.flip());
            buffer.flip();
            tot += (long)count;
            if (this.progressListener == null) continue;
            this.progressListener.update(count, tot);
        }
    }

    protected void setRequestSSOCookie(HttpURLConnection conn) {
        AccessControlContext acc = AccessController.getContext();
        Subject subj = Subject.getSubject(acc);
        if (subj != null) {
            Set<SSOCookieCredential> cookieCreds = subj.getPublicCredentials(SSOCookieCredential.class);
            if (cookieCreds != null && cookieCreds.size() > 0) {
                boolean found = false;
                for (SSOCookieCredential cookieCred : cookieCreds) {
                    if (!conn.getURL().getHost().endsWith(cookieCred.getDomain())) continue;
                    String cval = "CADC_SSO=\"" + cookieCred.getSsoCookieValue() + "\"";
                    conn.setRequestProperty("Cookie", cval);
                    log.debug((Object)("setRequestSSOCookie: " + cval));
                    found = true;
                    break;
                }
                if (!found) {
                    log.debug((Object)("setRequestSSOCookie: no cookie for domain: " + conn.getURL().getHost()));
                }
            } else {
                log.debug((Object)"setRequestSSOCookie: no cookie");
            }
        }
    }

    protected void setRequestHeaders(HttpURLConnection conn) {
        log.debug((Object)("custom request properties: " + this.requestProperties.size()));
        for (HttpRequestProperty rp : this.requestProperties) {
            String p = rp.getProperty();
            String v = rp.getValue();
            log.debug((Object)("set request property: " + p + "=" + v));
            conn.setRequestProperty(p, v);
        }
    }

    static {
        String jv = "Java " + System.getProperty("java.version") + ";" + System.getProperty("java.vendor");
        String os = System.getProperty("os.name") + " " + System.getProperty("os.version");
        DEFAULT_USER_AGENT = "OpenCADC/" + HttpTransfer.class.getName() + "/" + jv + "/" + os;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RetryReason {
        NONE(0),
        SERVER(1),
        TRANSIENT(2),
        ALL(3);

        private int value;

        private RetryReason(int val) {
            this.value = val;
        }
    }
}

