/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.ac.client;

import ca.nrc.cadc.ac.Group;
import ca.nrc.cadc.ac.User;
import ca.nrc.cadc.ac.client.GMSClient;
import ca.nrc.cadc.auth.CertCmdArgUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.util.ArgumentMap;
import ca.nrc.cadc.util.Log4jInit;
import java.net.URI;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMSClientMain
implements PrivilegedAction<Object> {
    private static Logger log = Logger.getLogger(GMSClientMain.class);
    public static final String ARG_ADD_MEMBER = "add-member";
    public static final String ARG_DEL_MEMBER = "remove-member";
    public static final String ARG_ADD_ADMIN = "add-admin";
    public static final String ARG_DEL_ADMIN = "remove-admin";
    public static final String ARG_CREATE_GROUP = "create";
    public static final String ARG_GET_GROUP = "get";
    public static final String ARG_DELETE_GROUP = "delete";
    public static final String ARG_USERID = "userid";
    public static final String ARG_GROUP = "group";
    public static final String ARG_HELP = "help";
    public static final String ARG_VERBOSE = "verbose";
    public static final String ARG_DEBUG = "debug";
    public static final String ARG_H = "h";
    public static final String ARG_V = "v";
    public static final String ARG_D = "d";
    private GMSClient client = new GMSClient(URI.create("ivo://cadc.nrc.ca/canfargms"));
    private ArgumentMap argMap;

    private GMSClientMain() {
    }

    public static void main(String[] args) {
        ArgumentMap argMap = new ArgumentMap(args);
        if (argMap.isSet(ARG_HELP) || argMap.isSet(ARG_H)) {
            GMSClientMain.usage();
            System.exit(0);
        }
        if (argMap.isSet(ARG_DEBUG) || argMap.isSet(ARG_D)) {
            Log4jInit.setLevel("ca.nrc.cadc.ac.client", Level.DEBUG);
            Log4jInit.setLevel("ca.nrc.cadc.net", Level.DEBUG);
        } else if (argMap.isSet(ARG_VERBOSE) || argMap.isSet(ARG_V)) {
            Log4jInit.setLevel("ca.nrc.cadc.ac.client", Level.DEBUG);
        } else {
            Log4jInit.setLevel("ca", Level.DEBUG);
        }
        GMSClientMain main = new GMSClientMain();
        main.argMap = argMap;
        Subject subject = CertCmdArgUtil.initSubject(argMap, true);
        Object response = subject != null ? Subject.doAs(subject, main) : main.run();
        log.debug("Response: " + response);
    }

    private String getCommand() {
        if (this.argMap.isSet(ARG_ADD_MEMBER)) {
            return ARG_ADD_MEMBER;
        }
        if (this.argMap.isSet(ARG_CREATE_GROUP)) {
            return ARG_CREATE_GROUP;
        }
        if (this.argMap.isSet(ARG_GET_GROUP)) {
            return ARG_GET_GROUP;
        }
        if (this.argMap.isSet(ARG_DELETE_GROUP)) {
            return ARG_DELETE_GROUP;
        }
        if (this.argMap.isSet(ARG_DEL_MEMBER)) {
            return ARG_DEL_MEMBER;
        }
        if (this.argMap.isSet(ARG_ADD_ADMIN)) {
            return ARG_ADD_ADMIN;
        }
        if (this.argMap.isSet(ARG_DEL_ADMIN)) {
            return ARG_DEL_ADMIN;
        }
        throw new IllegalArgumentException("No valid commands");
    }

    private static void usage() {
        System.out.println("--create --group=<g>");
        System.out.println("--get --group=<g>");
        System.out.println("--delete --group=<g>");
        System.out.println();
        System.out.println("--add-member --group=<g> --userid=<u>");
        System.out.println("--remove-member --group=<g> --userid=<u>");
        System.out.println();
        System.out.println("--add-admin --group=<g> --userid=<u>");
        System.out.println("--remove-admin --group=<g> --userid=<u>");
    }

    @Override
    public Object run() {
        try {
            String command = this.getCommand();
            if (command.equals(ARG_ADD_MEMBER)) {
                String group = this.argMap.getValue(ARG_GROUP);
                String userID = this.argMap.getValue(ARG_USERID);
                if (group == null) {
                    throw new IllegalArgumentException("No group specified");
                }
                if (userID == null) {
                    throw new IllegalArgumentException("No userid specified");
                }
                this.client.addUserMember(group, new HttpPrincipal(userID));
            } else if (command.equals(ARG_DEL_MEMBER)) {
                String group = this.argMap.getValue(ARG_GROUP);
                if (group == null) {
                    throw new IllegalArgumentException("No group specified");
                }
                String member = this.argMap.getValue(ARG_USERID);
                if (member == null) {
                    throw new IllegalArgumentException("No user specified");
                }
                this.client.removeUserMember(group, new HttpPrincipal(member));
            } else if (command.equals(ARG_ADD_ADMIN)) {
                String group = this.argMap.getValue(ARG_GROUP);
                String userID = this.argMap.getValue(ARG_USERID);
                if (group == null) {
                    throw new IllegalArgumentException("No group specified");
                }
                if (userID == null) {
                    throw new IllegalArgumentException("No userid specified");
                }
                HttpPrincipal hp = new HttpPrincipal(userID);
                Group group2 = this.client.getGroup(group);
                boolean update = true;
                block2: for (User<? extends Principal> admin : group2.getUserAdmins()) {
                    for (Principal p : admin.getIdentities()) {
                        HttpPrincipal ahp;
                        if (!(p instanceof HttpPrincipal) || !hp.equals(ahp = (HttpPrincipal)p)) continue;
                        update = false;
                        continue block2;
                    }
                }
                if (update) {
                    group2.getUserAdmins().add(new User<HttpPrincipal>(hp));
                    this.client.updateGroup(group2);
                    log.info("admin added: " + userID);
                } else {
                    log.info("admin found: " + userID);
                }
            } else if (command.equals(ARG_DEL_ADMIN)) {
                String group = this.argMap.getValue(ARG_GROUP);
                if (group == null) {
                    throw new IllegalArgumentException("No group specified");
                }
                String userID = this.argMap.getValue(ARG_USERID);
                if (userID == null) {
                    throw new IllegalArgumentException("No user specified");
                }
                HttpPrincipal hp = new HttpPrincipal(userID);
                Group group3 = this.client.getGroup(group);
                boolean update = false;
                Iterator<User<? extends Principal>> iter = group3.getUserAdmins().iterator();
                block4: while (iter.hasNext()) {
                    User<? extends Principal> admin = iter.next();
                    for (Principal p : admin.getIdentities()) {
                        HttpPrincipal ahp;
                        if (!(p instanceof HttpPrincipal) || !hp.equals(ahp = (HttpPrincipal)p)) continue;
                        iter.remove();
                        update = true;
                        continue block4;
                    }
                }
                if (update) {
                    this.client.updateGroup(group3);
                    log.info("admin removed: " + userID);
                } else {
                    log.info("admin not found: " + userID);
                }
            } else if (command.equals(ARG_CREATE_GROUP)) {
                String group = this.argMap.getValue(ARG_GROUP);
                if (group == null) {
                    throw new IllegalArgumentException("No group specified");
                }
                AccessControlContext accessControlContext = AccessController.getContext();
                Subject subject = Subject.getSubject(accessControlContext);
                Set<X500Principal> set = subject.getPrincipals(X500Principal.class);
                X500Principal p = set.iterator().next();
                Group g = new Group(group, new User<X500Principal>(p));
                g.getUserMembers().add(g.getOwner());
                this.client.createGroup(g);
            } else if (command.equals(ARG_GET_GROUP)) {
                String group = this.argMap.getValue(ARG_GROUP);
                if (group == null) {
                    throw new IllegalArgumentException("No group specified");
                }
                Group g = this.client.getGroup(group);
                System.out.println("found: " + g.getID());
                System.out.println("\t" + g.description);
                System.out.println("owner: " + g.getOwner());
                for (User<? extends Principal> user : g.getUserAdmins()) {
                    System.out.println("admin: " + user);
                }
                for (Group group4 : g.getGroupAdmins()) {
                    System.out.println("admin: " + group4);
                }
                for (User user : g.getUserMembers()) {
                    System.out.println("member: " + user);
                }
                for (Group group5 : g.getGroupMembers()) {
                    System.out.println("member: " + group5);
                }
            } else if (command.equals(ARG_DELETE_GROUP)) {
                String group = this.argMap.getValue(ARG_GROUP);
                if (group == null) {
                    throw new IllegalArgumentException("No group specified");
                }
                this.client.deleteGroup(group);
            }
            return null;
        }
        catch (Throwable t) {
            log.error("ERROR", t);
            return t;
        }
    }
}

