/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.cred;

import ca.nrc.cadc.auth.X509CertificateChain;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.bouncycastle.x509.extension.AuthorityKeyIdentifierStructure;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;

public class CertUtil {
    public static final String DEFAULT_SIGNATURE_ALGORITHM = "SHA256WITHRSA";
    public static final int DEFAULT_KEY_LENGTH = 1024;

    /*
     * WARNING - void declaration
     */
    public static X509Certificate generateCertificate(PKCS10CertificationRequest csr, int lifetime, X509CertificateChain chain) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, CertificateParsingException, CertificateEncodingException, SignatureException, CertificateExpiredException, CertificateNotYetValidException {
        X509Certificate issuerCert = chain.getChain()[0];
        PrivateKey issuerKey = chain.getPrivateKey();
        Security.addProvider((Provider)new BouncyCastleProvider());
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certGen.setIssuerDN(issuerCert.getSubjectX500Principal());
        Random rand = new Random();
        String issuerDN = issuerCert.getSubjectX500Principal().getName("RFC2253");
        String delegDN = String.valueOf(Math.abs(rand.nextInt()));
        String proxyDn = "CN=" + delegDN + "," + issuerDN;
        certGen.setSubjectDN(new X500Principal(proxyDn));
        GregorianCalendar date = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        date.add(12, -65);
        Date beforeDate = date.getTime();
        for (X509Certificate currentCert : chain.getChain()) {
            if (!beforeDate.before(currentCert.getNotBefore())) continue;
            beforeDate = currentCert.getNotBefore();
        }
        certGen.setNotBefore(beforeDate);
        if (lifetime <= 0) {
            void var12_14;
            Date date2 = issuerCert.getNotAfter();
            for (X509Certificate currentCert : chain.getChain()) {
                if (!var12_14.after(currentCert.getNotAfter())) continue;
                Date date3 = currentCert.getNotAfter();
            }
            certGen.setNotAfter((Date)var12_14);
        } else {
            date.add(12, 5);
            date.add(13, lifetime);
            for (X509Certificate currentCert : chain.getChain()) {
                currentCert.checkValidity(date.getTime());
            }
            certGen.setNotAfter(date.getTime());
        }
        certGen.setPublicKey(csr.getPublicKey());
        certGen.setSignatureAlgorithm(DEFAULT_SIGNATURE_ALGORITHM);
        certGen.addExtension(X509Extensions.KeyUsage, true, (DEREncodable)new KeyUsage(160));
        certGen.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)new AuthorityKeyIdentifierStructure(issuerCert));
        certGen.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)new SubjectKeyIdentifierStructure(csr.getPublicKey("BC")));
        certGen.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(false));
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier("1.3.6.1.5.5.7.21.1");
        ASN1EncodableVector policy = new ASN1EncodableVector();
        policy.add((DEREncodable)dERObjectIdentifier);
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((DEREncodable)new DERSequence((DEREncodableVector)policy));
        DERObjectIdentifier OID = new DERObjectIdentifier("1.3.6.1.5.5.7.1.14");
        certGen.addExtension(OID, true, (DEREncodable)new DERSequence((DEREncodableVector)vec));
        return certGen.generate(issuerKey, "BC");
    }

    public static void writePEMCertificateAndKey(X509CertificateChain chain, Writer writer) throws IOException {
        if (chain == null) {
            throw new IllegalArgumentException("Null certificate chain");
        }
        if (writer == null) {
            throw new IllegalArgumentException("Null writer");
        }
        PEMWriter pemWriter = new PEMWriter(writer);
        pemWriter.writeObject((Object)chain.getChain()[0]);
        pemWriter.writeObject((Object)chain.getPrivateKey());
        for (int i = 1; i < chain.getChain().length; ++i) {
            pemWriter.writeObject((Object)chain.getChain()[i]);
        }
        pemWriter.flush();
    }
}

