/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.io;

import ca.nrc.cadc.io.ByteCounter;
import ca.nrc.cadc.io.ByteLimitExceededException;
import java.io.IOException;
import java.io.InputStream;

public class ByteCountInputStream
extends InputStream
implements ByteCounter {
    private InputStream inputStream;
    private long byteCount = 0L;
    private Long byteLimit = null;

    public ByteCountInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public ByteCountInputStream(InputStream inputStream, long byteLimit) {
        this.inputStream = inputStream;
        if (byteLimit > 0L) {
            this.byteLimit = byteLimit;
        }
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public Long getByteLimit() {
        return this.byteLimit;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    public int read() throws IOException {
        if (this.hasReachedLimit()) {
            throw new ByteLimitExceededException(this.byteLimit);
        }
        int value = this.inputStream.read();
        ++this.byteCount;
        return value;
    }

    public int read(byte[] b) throws IOException {
        if (this.hasReachedLimit()) {
            throw new ByteLimitExceededException(this.byteLimit);
        }
        int bytesRead = this.inputStream.read(b);
        if (bytesRead != -1) {
            this.byteCount += (long)bytesRead;
        }
        return bytesRead;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.hasReachedLimit()) {
            throw new ByteLimitExceededException(this.byteLimit);
        }
        int bytesRead = this.inputStream.read(b, off, len);
        if (bytesRead != -1) {
            this.byteCount += (long)bytesRead;
        }
        return bytesRead;
    }

    public void reset() throws IOException {
        this.inputStream.reset();
        this.byteCount = 0L;
    }

    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    private boolean hasReachedLimit() {
        if (this.byteLimit == null) {
            return false;
        }
        return this.byteCount >= this.byteLimit;
    }
}

