/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.net;

import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.OutputStreamWrapper;
import ca.nrc.cadc.net.TransientException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessControlException;
import javax.net.ssl.HttpsURLConnection;
import org.apache.log4j.Logger;

public class HttpUpload
extends HttpTransfer {
    private static Logger log = Logger.getLogger(HttpUpload.class);
    private String contentType;
    private String contentEncoding;
    private String contentMD5;
    private String responseBody;
    private InputStream istream;
    private OutputStreamWrapper wrapper;

    public HttpUpload(File src, URL dest) {
        super(false);
        this.localFile = src;
        this.remoteURL = dest;
        if (this.remoteURL == null) {
            throw new IllegalArgumentException("destination URL cannot be null");
        }
        if (this.localFile == null) {
            throw new IllegalArgumentException("source File cannot be null");
        }
    }

    public HttpUpload(InputStream src, URL dest) {
        super(false);
        this.istream = src;
        this.remoteURL = dest;
        if (this.remoteURL == null) {
            throw new IllegalArgumentException("destination URL cannot be null");
        }
        if (this.istream == null) {
            throw new IllegalArgumentException("source InputStream cannot be null");
        }
    }

    public HttpUpload(OutputStreamWrapper src, URL dest) {
        super(false);
        this.wrapper = src;
        this.remoteURL = dest;
        if (this.remoteURL == null) {
            throw new IllegalArgumentException("destination URL cannot be null");
        }
        if (this.wrapper == null) {
            throw new IllegalArgumentException("source OutputStreamWrapper cannot be null");
        }
    }

    private HttpUpload() {
        super(false);
    }

    public void setFollowRedirects(boolean followRedirects) {
        if (followRedirects) {
            throw new IllegalArgumentException("followRedirects=true not allowed for upload");
        }
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public void setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String toString() {
        return "HttpUpload[" + this.remoteURL + "," + this.localFile + "]";
    }

    public void run() {
        if (this.istream != null || this.wrapper != null) {
            log.debug("input comes from a stream, disabling retries");
            this.maxRetries = 0;
        }
        boolean done = false;
        while (!done) {
            try {
                this.runX();
                done = true;
            }
            catch (TransientException ex) {
                try {
                    long dt = 1000L * (long)ex.getRetryDelay();
                    log.debug("retry " + this.numRetries + " sleeping  for " + dt);
                    this.fireEvent(9);
                    Thread.sleep(dt);
                }
                catch (InterruptedException iex) {
                    log.debug("retry interrupted");
                    this.go = false;
                    done = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void runX() throws TransientException {
        block57: {
            Object object2222;
            boolean throwTE;
            block53: {
                log.debug(this.toString());
                if (!this.go) {
                    return;
                }
                throwTE = false;
                this.thread = Thread.currentThread();
                this.fireEvent(1);
                HttpURLConnection conn = (HttpURLConnection)this.remoteURL.openConnection();
                if (conn instanceof HttpsURLConnection) {
                    HttpsURLConnection sslConn = (HttpsURLConnection)conn;
                    this.initHTTPS(sslConn);
                }
                this.doPut(conn);
                Object var5_7 = null;
                if (this.istream == null) break block53;
                log.debug("closing InputStream");
                try {
                    this.istream.close();
                }
                catch (Exception object2222) {
                    // empty catch block
                }
            }
            object2222 = this;
            synchronized (object2222) {
                if (this.thread != null) {
                    if (Thread.interrupted()) {
                        this.go = false;
                    }
                    this.thread = null;
                }
            }
            if (!this.go) {
                log.debug("cancelled");
                this.fireEvent(6);
            } else if (this.failure != null) {
                log.debug("failed: " + this.failure);
                this.fireEvent(this.failure);
            } else if (!throwTE) {
                log.debug("completed");
                this.fireEvent(5);
            }
            break block57;
            {
                catch (InterruptedException iex) {
                    Object object32222;
                    this.go = false;
                    Object var5_8 = null;
                    if (this.istream != null) {
                        log.debug("closing InputStream");
                        try {
                            this.istream.close();
                        }
                        catch (Exception object32222) {
                            // empty catch block
                        }
                    }
                    object32222 = this;
                    synchronized (object32222) {
                        if (this.thread != null) {
                            if (Thread.interrupted()) {
                                this.go = false;
                            }
                            this.thread = null;
                        }
                    }
                    if (!this.go) {
                        log.debug("cancelled");
                        this.fireEvent(6);
                    } else if (this.failure != null) {
                        log.debug("failed: " + this.failure);
                        this.fireEvent(this.failure);
                    } else if (!throwTE) {
                        log.debug("completed");
                        this.fireEvent(5);
                    }
                    break block57;
                }
                catch (TransientException tex) {
                    log.debug("caught: " + tex);
                    throwTE = true;
                    throw tex;
                }
                catch (Throwable t) {
                    Object object42222;
                    this.failure = t;
                    Object var5_9 = null;
                    if (this.istream != null) {
                        log.debug("closing InputStream");
                        try {
                            this.istream.close();
                        }
                        catch (Exception object42222) {
                            // empty catch block
                        }
                    }
                    object42222 = this;
                    synchronized (object42222) {
                        if (this.thread != null) {
                            if (Thread.interrupted()) {
                                this.go = false;
                            }
                            this.thread = null;
                        }
                    }
                    if (!this.go) {
                        log.debug("cancelled");
                        this.fireEvent(6);
                    } else if (this.failure != null) {
                        log.debug("failed: " + this.failure);
                        this.fireEvent(this.failure);
                    } else if (!throwTE) {
                        log.debug("completed");
                        this.fireEvent(5);
                    }
                }
            }
            catch (Throwable throwable) {
                Object object52222;
                Object var5_10 = null;
                if (this.istream != null) {
                    log.debug("closing InputStream");
                    try {
                        this.istream.close();
                    }
                    catch (Exception object52222) {
                        // empty catch block
                    }
                }
                object52222 = this;
                synchronized (object52222) {
                    if (this.thread != null) {
                        if (Thread.interrupted()) {
                            this.go = false;
                        }
                        this.thread = null;
                    }
                }
                if (!this.go) {
                    log.debug("cancelled");
                    this.fireEvent(6);
                } else if (this.failure != null) {
                    log.debug("failed: " + this.failure);
                    this.fireEvent(this.failure);
                } else if (!throwTE) {
                    log.debug("completed");
                    this.fireEvent(5);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doPut(HttpURLConnection conn) throws IOException, InterruptedException, TransientException {
        IOException ioex;
        block51: {
            OutputStream ostream;
            block49: {
                ostream = null;
                if (this.localFile != null) {
                    try {
                        Method longContentLengthMethod = conn.getClass().getMethod("setFixedLengthStreamingMode", Long.TYPE);
                        longContentLengthMethod.invoke((Object)conn, new Long(this.localFile.length()));
                        log.debug("invoked setFixedLengthStreamingMode(long)");
                    }
                    catch (Exception noCanDo) {
                        if (this.localFile.length() > Integer.MAX_VALUE) {
                            conn.setChunkedStreamingMode(this.bufferSize);
                            conn.setRequestProperty("X-CADC-Content-Length", Long.toString(this.localFile.length()));
                            log.debug("invoked setChunkedStreamingMode");
                            break block49;
                        }
                        conn.setFixedLengthStreamingMode((int)this.localFile.length());
                        log.debug("invoked setFixedLengthStreamingMode(int)");
                    }
                } else {
                    conn.setChunkedStreamingMode(8192);
                    log.debug("invoked setChunkedStreamingMode");
                }
            }
            this.setRequestSSOCookie(conn);
            conn.setRequestMethod("PUT");
            conn.setUseCaches(false);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            if (this.localFile != null) {
                conn.setRequestProperty("Content-Length", Long.toString(this.localFile.length()));
            }
            if (this.contentType != null) {
                log.debug("set Content-Type=" + this.contentType);
                conn.setRequestProperty("Content-Type", this.contentType);
            }
            if (this.contentEncoding != null) {
                conn.setRequestProperty("Content-Encoding", this.contentEncoding);
            }
            if (this.contentMD5 != null) {
                conn.setRequestProperty("Content-MD5", this.contentMD5);
            }
            this.setRequestHeaders(conn);
            int bSize = this.bufferSize;
            if (this.localFile != null && this.localFile.length() < (long)bSize) {
                bSize = (int)this.localFile.length();
            }
            ioex = null;
            FileInputStream fin = null;
            InputStream in = null;
            ostream = conn.getOutputStream();
            if (this.localFile != null) {
                fin = new FileInputStream(this.localFile);
                in = fin;
            } else if (this.istream != null) {
                in = this.istream;
            }
            if (!(ostream instanceof BufferedOutputStream)) {
                log.debug("using BufferedOutputStream");
                ostream = new BufferedOutputStream(ostream, this.bufferSize);
            }
            if (in != null) {
                log.debug("using BufferedInputStream");
                in = new BufferedInputStream(in, this.bufferSize);
            }
            this.fireEvent(3);
            if (in != null) {
                this.ioLoop(in, ostream, 2 * this.bufferSize, 0L);
            } else {
                this.wrapper.write(ostream);
            }
            log.debug("OutputStream.flush");
            ostream.flush();
            log.debug("OutputStream.flush OK");
            Object var9_9 = null;
            try {
                if (ostream != null) {
                    log.debug("OutputStream.close");
                    ostream.close();
                    log.debug("OutputStream.close OK");
                }
            }
            catch (IOException ignore) {
                log.debug("OutputStream.close FAIL", ignore);
            }
            try {
                if (fin != null) {
                    fin.close();
                }
                break block51;
            }
            catch (IOException ignore) {}
            break block51;
            {
                catch (IOException ex) {
                    ioex = ex;
                    var9_9 = null;
                    try {
                        if (ostream != null) {
                            log.debug("OutputStream.close");
                            ostream.close();
                            log.debug("OutputStream.close OK");
                        }
                    }
                    catch (IOException ignore) {
                        log.debug("OutputStream.close FAIL", ignore);
                    }
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                        break block51;
                    }
                    catch (IOException ignore) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (ostream != null) {
                        log.debug("OutputStream.close");
                        ostream.close();
                        log.debug("OutputStream.close OK");
                    }
                }
                catch (IOException ignore) {
                    log.debug("OutputStream.close FAIL", ignore);
                }
                try {
                    if (fin == null) throw throwable;
                    fin.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        int code = conn.getResponseCode();
        log.debug("code: " + code);
        this.responseCode = code;
        if (code != 200) {
            String msg = "(" + code + ") " + conn.getResponseMessage();
            this.checkTransient(code, msg, conn);
            switch (code) {
                case 401: {
                    throw new AccessControlException("authentication failed " + msg);
                }
                case 403: {
                    throw new AccessControlException("authorization failed " + msg);
                }
                case 404: {
                    throw new FileNotFoundException("resource not found " + msg);
                }
                case 413: {
                    throw new IOException("No space left - " + msg);
                }
            }
            throw new IOException(msg);
        }
        if (ioex != null) {
            throw ioex;
        }
        InputStream inputStream = conn.getInputStream();
        if (inputStream == null) return;
        int smallBufferSize = 512;
        ByteArrayOutputStream byteArrayOstream = new ByteArrayOutputStream();
        try {
            if (this.use_nio) {
                this.nioLoop(inputStream, byteArrayOstream, smallBufferSize, 0L);
            } else {
                this.ioLoop(inputStream, byteArrayOstream, smallBufferSize, 0L);
            }
            byteArrayOstream.flush();
            this.responseBody = new String(byteArrayOstream.toByteArray(), "UTF-8");
            Object var12_19 = null;
            if (byteArrayOstream == null) return;
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            if (byteArrayOstream == null) throw throwable;
            try {
                byteArrayOstream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            byteArrayOstream.close();
            return;
        }
        catch (Exception exception) {}
    }
}

