/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.uws.server.JobManager;
import ca.nrc.cadc.uws.server.SyncOutput;
import ca.nrc.cadc.uws.web.InlineContentHandler;
import ca.nrc.cadc.uws.web.JobCreator;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SyncServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(SyncServlet.class);
    private static final long serialVersionUID = 201009291100L;
    private static final String JOB_EXEC = "run";
    private JobManager jobManager;
    private Class inlineContentHandlerClass;
    private boolean execOnGET = false;
    private boolean execOnPOST = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            String str = config.getInitParameter(SyncServlet.class.getName() + ".execOnGET");
            if (str != null) {
                try {
                    this.execOnGET = Boolean.parseBoolean(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((str = config.getInitParameter(SyncServlet.class.getName() + ".execOnPOST")) != null) {
                try {
                    this.execOnPOST = Boolean.parseBoolean(str);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            log.info("execOnGET: " + this.execOnGET);
            log.info("execOnPOST: " + this.execOnPOST);
            this.jobManager = this.createJobManager(config);
            String cname = InlineContentHandler.class.getName();
            String pname = config.getInitParameter(cname);
            if (pname == null) {
                log.info("CONFIGURATION INFO: init-param not found: " + cname + " = <class name of InlineContentHandler implementation>");
            } else {
                try {
                    this.inlineContentHandlerClass = Class.forName(pname);
                    InlineContentHandler ret = (InlineContentHandler)this.inlineContentHandlerClass.newInstance();
                    log.info("created InlineContentHandler: " + ret.getClass().getName());
                }
                catch (Exception e) {
                    log.error("CONFIGURATION ERROR: error loading class: " + cname + " = <class name of InlineContentHandler implementation>", e);
                }
            }
        }
        catch (Exception ex) {
            log.error("failed to init: " + ex);
        }
    }

    public void destroy() {
        if (this.jobManager != null) {
            try {
                this.jobManager.terminate();
            }
            catch (Throwable t) {
                log.error("failed to terminate Jobmanager", t);
            }
        }
    }

    protected JobManager createJobManager(ServletConfig config) {
        String pname = JobManager.class.getName();
        try {
            String cname = config.getInitParameter(pname);
            if (cname != null && cname.trim().length() > 0) {
                Class<?> c = Class.forName(cname);
                JobManager ret = (JobManager)c.newInstance();
                log.info("created JobManager: " + ret.getClass().getName());
                return ret;
            }
            log.error("CONFIGURATION ERROR: required init-param not found: " + pname + " = <class name of JobManager implementation>");
        }
        catch (Exception ex) {
            log.error("failed to create JobManager", ex);
        }
        return null;
    }

    protected JobCreator getJobCreator() {
        return new JobCreator(this.getInlineContentHandler());
    }

    protected InlineContentHandler getInlineContentHandler() {
        InlineContentHandler handler = null;
        if (this.inlineContentHandlerClass != null) {
            try {
                handler = (InlineContentHandler)this.inlineContentHandlerClass.newInstance();
            }
            catch (Throwable t) {
                log.error("Unable to create inline content handler ", t);
            }
        }
        return handler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("doGet - START");
        this.doit(this.execOnGET, request, response);
        log.debug("doGet - DONE");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("doPost - START");
        this.doit(this.execOnPOST, request, response);
        log.debug("doPost - DONE");
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("doHead - START");
        response.setStatus(501);
        log.debug("doHead - DONE");
    }

    private void doit(final boolean execOnCreate, final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        log.debug("doit: execOnCreate=" + execOnCreate);
        if (this.jobManager == null) {
            response.setStatus(500);
            response.setContentType("text/plain");
            PrintWriter w = response.getWriter();
            w.println("servlet is not configured to accept jobs");
            w.close();
            return;
        }
        Subject subject = AuthenticationUtil.getSubject(request);
        if (subject == null) {
            this.processRequest(execOnCreate, request, response);
        } else {
            try {
                Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        try {
                            SyncServlet.this.processRequest(execOnCreate, request, response);
                            return null;
                        }
                        catch (Exception ex) {
                            throw new PrivilegedActionException(ex);
                        }
                    }
                });
            }
            catch (PrivilegedActionException pex) {
                if (pex.getCause() instanceof ServletException) {
                    throw (ServletException)pex.getCause();
                }
                if (pex.getCause() instanceof IOException) {
                    throw (IOException)pex.getCause();
                }
                if (pex.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)pex.getCause();
                }
                throw new RuntimeException(pex.getCause());
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void processRequest(boolean execOnCreate, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 75[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getJobID(HttpServletRequest request) {
        String path = request.getPathInfo();
        log.debug("path: " + path);
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] parts = path.split("/");
        log.debug("path: " + path + " jobID: " + parts[0]);
        return parts[0];
    }

    private String getJobAction(HttpServletRequest request) {
        String path = request.getPathInfo();
        log.debug("path: " + path);
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] parts = path.split("/");
        String ret = null;
        if (parts.length == 2) {
            ret = parts[1];
        }
        log.debug("path: " + path + " jobAction: " + ret);
        return ret;
    }

    private String getJobURL(HttpServletRequest request, String jobID) {
        StringBuffer sb = request.getRequestURL();
        log.debug("request URL: " + sb);
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append("/");
        }
        sb.append(jobID);
        return sb.toString();
    }

    private class SafeOutputStream
    extends FilterOutputStream {
        SafeOutputStream(OutputStream ostream) {
            super(ostream);
        }

        public void close() throws IOException {
        }
    }

    private class SyncOutputImpl
    implements SyncOutput {
        OutputStream ostream;
        HttpServletResponse response;

        SyncOutputImpl(HttpServletResponse response) {
            this.response = response;
        }

        public boolean isOpen() {
            return this.ostream != null;
        }

        public OutputStream getOutputStream() throws IOException {
            if (this.ostream == null) {
                log.debug("opening OutputStream");
                this.ostream = new SafeOutputStream(this.response.getOutputStream());
            }
            return this.ostream;
        }

        public void setResponseCode(int code) {
            if (this.ostream == null) {
                this.response.setStatus(code);
            } else {
                log.warn("setResponseCode: " + code + " AFTER OutputStream opened, ignoring");
            }
        }

        public void setHeader(String key, String value) {
            if (this.ostream == null) {
                this.response.setHeader(key, value);
            } else {
                log.warn("setHeader: " + key + " = " + value + " AFTER OutputStream opened, ignoring");
            }
        }
    }
}

