/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.web.restlet;

import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.uws.web.InlineContentHandler;
import ca.nrc.cadc.uws.web.JobCreator;
import ca.nrc.cadc.uws.web.restlet.WebRepresentationException;
import ca.nrc.cadc.uws.web.restlet.validators.JobFormValidatorImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.log4j.Logger;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.ext.fileupload.RestletFileUpload;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestletJobCreator
extends JobCreator {
    private static final Logger log = Logger.getLogger(RestletJobCreator.class);

    public RestletJobCreator(InlineContentHandler inlineContentHandler) {
        super(inlineContentHandler);
    }

    public Job create(Representation entity) throws FileUploadException, IOException {
        Job job = new Job();
        job.setExecutionPhase(ExecutionPhase.PENDING);
        job.setParameterList(new ArrayList<Parameter>());
        if (entity == null || entity.getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM, true)) {
            Form form = new Form(entity);
            JobFormValidatorImpl validator = new JobFormValidatorImpl(form);
            Map<String, String> errors = validator.validate();
            if (!errors.isEmpty()) {
                String message = this.getErrorMessage(errors);
                log.error(message);
                throw new WebRepresentationException(message);
            }
            Set names = form.getNames();
            for (String name : names) {
                this.processParameter(job, name, form.getValuesArray(name, true));
            }
        } else if (this.inlineContentHandler != null) {
            if (entity.getMediaType().equals((Object)MediaType.MULTIPART_FORM_DATA, true)) {
                RestletFileUpload upload = new RestletFileUpload();
                FileItemIterator itemIterator = upload.getItemIterator(entity);
                this.processMultiPart(job, itemIterator);
            } else {
                this.processStream(null, entity.getMediaType().getName(), entity.getStream());
            }
            this.inlineContentHandler.setParameterList(job.getParameterList());
            job.setParameterList(this.inlineContentHandler.getParameterList());
            job.setJobInfo(this.inlineContentHandler.getJobInfo());
        }
        return job;
    }

    public List<Parameter> getParameterList(Form form) {
        Job job = new Job();
        for (String name : form.getNames()) {
            this.processParameter(job, name, form.getValuesArray(name, true));
        }
        return job.getParameterList();
    }

    private String getErrorMessage(Map<String, String> errors) {
        StringBuilder sb = new StringBuilder();
        sb.append("Errors found during Job Creation: \n");
        for (Map.Entry<String, String> error : errors.entrySet()) {
            sb.append("\n");
            sb.append(error.getKey());
            sb.append(": ");
            sb.append(error.getValue());
        }
        return sb.toString();
    }
}

