/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.web.restlet;

import ca.nrc.cadc.uws.server.JobManager;
import ca.nrc.cadc.uws.web.InlineContentHandler;
import ca.nrc.cadc.uws.web.restlet.UWSStatusService;
import ca.nrc.cadc.uws.web.restlet.resources.AsynchResource;
import ca.nrc.cadc.uws.web.restlet.resources.ErrorResource;
import ca.nrc.cadc.uws.web.restlet.resources.JobAsynchResource;
import ca.nrc.cadc.uws.web.restlet.resources.ParameterListResource;
import ca.nrc.cadc.uws.web.restlet.resources.ResultListResource;
import ca.nrc.cadc.uws.web.restlet.resources.ResultResource;
import org.apache.log4j.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.routing.Router;

public class UWSAsyncApplication
extends Application {
    private static final Logger log = Logger.getLogger(UWSAsyncApplication.class);
    public static final String UWS_JOB_MANAGER = JobManager.class.getName();
    public static final String UWS_INLINE_CONTENT_HANDLER = InlineContentHandler.class.getName();

    public UWSAsyncApplication() {
        this.init();
    }

    public UWSAsyncApplication(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.setStatusService(new UWSStatusService(true));
        this.getMetadataService().addExtension(MediaType.TEXT_XML.getName(), (Metadata)MediaType.TEXT_XML, true);
    }

    public Restlet createInboundRoot() {
        Class<?> c;
        Context ctx = this.getContext();
        String cname = null;
        try {
            cname = this.getContext().getParameters().getFirstValue(UWS_JOB_MANAGER);
            c = Class.forName(cname);
            JobManager jm = (JobManager)c.newInstance();
            ctx.getAttributes().put(UWS_JOB_MANAGER, jm);
            log.info("created " + UWS_JOB_MANAGER + ": " + cname);
        }
        catch (Exception ex) {
            log.error("CONFIGURATION ERROR: failed to instantiate JobManager implementation: " + cname);
        }
        try {
            cname = this.getContext().getParameters().getFirstValue(UWS_INLINE_CONTENT_HANDLER);
            if (cname == null) {
                log.info("CONFIGURATION INFO: " + UWS_INLINE_CONTENT_HANDLER + " not configured in web.xml");
            } else {
                c = Class.forName(cname);
                ctx.getAttributes().put(UWS_INLINE_CONTENT_HANDLER, c);
                log.info("loaded " + UWS_INLINE_CONTENT_HANDLER + ": " + cname);
            }
        }
        catch (Exception ex) {
            log.error("CONFIGURATION ERROR: failed to load InlineContentHandler class: " + cname);
        }
        return new JobRouter(ctx);
    }

    public void stop() throws Exception {
        super.stop();
        JobManager jm = (JobManager)this.getContext().getAttributes().get(UWS_JOB_MANAGER);
        if (jm != null) {
            jm.terminate();
        }
        this.getContext().getAttributes().clear();
    }

    protected class JobRouter
    extends Router {
        public JobRouter(Context context) {
            super(context);
            log.debug("attaching / -> AsynchResource");
            this.attach("", AsynchResource.class);
            log.debug("attaching /{jobID} -> JobAsynchResource");
            this.attach("/{jobID}", JobAsynchResource.class);
            this.attach("/{jobID}/phase", JobAsynchResource.class);
            this.attach("/{jobID}/executionduration", JobAsynchResource.class);
            this.attach("/{jobID}/destruction", JobAsynchResource.class);
            this.attach("/{jobID}/quote", JobAsynchResource.class);
            this.attach("/{jobID}/owner", JobAsynchResource.class);
            this.attach("/{jobID}/parameters", ParameterListResource.class);
            this.attach("/{jobID}/error", ErrorResource.class);
            this.attach("/{jobID}/results", ResultListResource.class);
            this.attach("/{jobID}/results/{resultID}", ResultResource.class);
        }
    }
}

