/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.web.restlet.resources;

import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.net.TransientException;
import ca.nrc.cadc.uws.ExecutionPhase;
import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobAttribute;
import ca.nrc.cadc.uws.JobWriter;
import ca.nrc.cadc.uws.Parameter;
import ca.nrc.cadc.uws.server.JobNotFoundException;
import ca.nrc.cadc.uws.server.JobPersistenceException;
import ca.nrc.cadc.uws.server.JobPhaseException;
import ca.nrc.cadc.uws.web.restlet.InvalidActionException;
import ca.nrc.cadc.uws.web.restlet.RestletJobCreator;
import ca.nrc.cadc.uws.web.restlet.resources.BaseJobResource;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Delete;
import org.restlet.resource.Get;
import org.restlet.resource.Post;

public class JobAsynchResource
extends BaseJobResource {
    private static final Logger LOGGER = Logger.getLogger(JobAsynchResource.class);
    private static final long MAX_WAIT = 60L;
    private static final long[] POLL_INTERVAL = new long[]{1L, 2L, 4L, 8L};
    private static final String RUN = "RUN";
    private static final String ABORT = "ABORT";
    private static final String SHUTDOWN = "SHUTDOWN";
    private DateFormat dateFormat = DateUtil.getDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", DateUtil.UTC);

    @Get
    public Representation represent() {
        Subject subject = this.getSubject();
        if (subject == null) {
            return this.doRepresent();
        }
        return (Representation)Subject.doAs(subject, new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return JobAsynchResource.this.doRepresent();
            }
        });
    }

    private Representation doRepresent() {
        try {
            StringRepresentation representation;
            block24: {
                if (this.job == null) {
                    this.job = this.getJobManager().get(this.jobID);
                    this.job.setProtocol(this.protocol);
                }
                representation = null;
                String pathInfo = this.getRequestPath();
                if (pathInfo.endsWith("phase")) {
                    representation = new StringRepresentation((CharSequence)this.job.getExecutionPhase().toString());
                } else if (pathInfo.endsWith("executionduration")) {
                    representation = new StringRepresentation((CharSequence)Long.toString(this.job.getExecutionDuration()));
                } else if (pathInfo.endsWith("destruction")) {
                    representation = new StringRepresentation((CharSequence)this.dateFormat.format(this.job.getDestructionTime()));
                } else if (pathInfo.endsWith("quote")) {
                    representation = new StringRepresentation((CharSequence)this.dateFormat.format(this.job.getQuote()));
                } else if (pathInfo.endsWith("owner")) {
                    representation = new StringRepresentation((CharSequence)this.job.getOwnerID());
                } else {
                    Form query = this.getQuery();
                    org.restlet.data.Parameter p = query.getFirst("WAIT", true);
                    if (p != null) {
                        String waitStr = p.getValue();
                        try {
                            Long wait = 60L;
                            LOGGER.debug("represent: wait = " + waitStr);
                            if (waitStr != null) {
                                wait = new Long(waitStr);
                            }
                            if (wait > 60L) {
                                wait = 60L;
                            }
                            LOGGER.debug("wait: " + wait);
                            ExecutionPhase ep = this.job.getExecutionPhase();
                            if (!ep.isActive()) break block24;
                            ExecutionPhase cur = ep;
                            int n = 0;
                            long rem = 1000L * wait;
                            while (rem > 0L && ep.equals((Object)cur)) {
                                long dt = 1000L * Math.min(POLL_INTERVAL[n], wait);
                                LOGGER.debug("wait: " + wait + " phase: " + ep.getValue() + " dt(ms): " + dt);
                                long t = Math.min(rem, dt);
                                LOGGER.debug("sleep: " + t);
                                try {
                                    Thread.sleep(t);
                                }
                                catch (InterruptedException ex) {
                                    LOGGER.debug("interrupted: wait at phase " + ep.getValue());
                                }
                                this.job = this.getJobManager().get(this.jobID);
                                cur = this.job.getExecutionPhase();
                                rem -= dt;
                                if (n >= POLL_INTERVAL.length - 1) continue;
                                ++n;
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                            return new StringRepresentation((CharSequence)("invalid WAIT value: " + waitStr));
                        }
                    }
                }
            }
            if (representation != null) {
                return representation;
            }
            return super.represent();
        }
        catch (TransientException t) {
            return this.generateRetryRepresentation(t);
        }
        catch (JobPersistenceException ex) {
            throw new RuntimeException(ex);
        }
        catch (JobNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Delete
    public void delete(final Representation entity) {
        Subject subject = this.getSubject();
        if (subject == null) {
            this.doDelete(entity);
        } else {
            Subject.doAs(subject, new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    JobAsynchResource.this.doDelete(entity);
                    return null;
                }
            });
        }
    }

    private void doDelete(Representation entity) {
        LOGGER.debug("delete() called. for job: " + this.jobID);
        try {
            this.getJobManager().delete(this.jobID);
            this.redirectToJobList();
        }
        catch (TransientException t) {
            this.generateRetryRepresentation(t);
        }
        catch (JobPersistenceException ex) {
            throw new RuntimeException(ex);
        }
        catch (JobNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Post
    public void accept(final Representation entity) {
        final String pathInfo = this.getRequestPath();
        Subject subject = this.getSubject();
        if (subject == null) {
            this.doAccept(pathInfo, entity);
        } else {
            Subject.doAs(subject, new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    JobAsynchResource.this.doAccept(pathInfo, entity);
                    return null;
                }
            });
        }
    }

    private void doAccept(String pathInfo, Representation entity) {
        LOGGER.debug("doAccept: pathInfo=" + pathInfo);
        try {
            RestletJobCreator jobCreator;
            List<Parameter> parameters;
            String str;
            Form form = new Form(entity);
            if (pathInfo.endsWith("phase")) {
                String phase = form.getFirstValue(JobAttribute.EXECUTION_PHASE.getAttributeName().toUpperCase());
                LOGGER.debug("request: PHASE=" + phase);
                if (RUN.equalsIgnoreCase(phase)) {
                    Job job = this.getJobManager().get(this.jobID);
                    job.setProtocol(this.protocol);
                    this.getJobManager().execute(job);
                } else if (ABORT.equalsIgnoreCase(phase)) {
                    this.getJobManager().abort(this.jobID);
                } else if (SHUTDOWN.equalsIgnoreCase(phase)) {
                    this.getJobManager().abort(this.jobID);
                } else {
                    throw new InvalidActionException("invalid phase request: " + phase);
                }
                this.redirectToJob();
                return;
            }
            if (pathInfo.endsWith(this.jobID)) {
                String actionStr = form.getFirstValue("ACTION");
                LOGGER.debug("request: ACTION=" + actionStr);
                if ("DELETE".equals(actionStr)) {
                    LOGGER.debug("DELETE job through POST request. job: " + this.jobID);
                    this.getJobManager().delete(this.jobID);
                    this.redirectToJobList();
                    return;
                }
            }
            Long execDuration = null;
            Date destruction = null;
            Date quote = null;
            if (pathInfo.endsWith("executionduration")) {
                str = form.getFirstValue(JobAttribute.EXECUTION_DURATION.getAttributeName().toUpperCase());
                try {
                    execDuration = Long.parseLong(str);
                }
                catch (NumberFormatException nex) {
                    throw new InvalidActionException("failed to parse " + JobAttribute.EXECUTION_DURATION.getAttributeName() + ": " + str + " (expected an integer)");
                }
            }
            if (pathInfo.endsWith("destruction")) {
                str = form.getFirstValue(JobAttribute.DESTRUCTION_TIME.getAttributeName().toUpperCase());
                try {
                    destruction = this.dateFormat.parse(str);
                }
                catch (ParseException e) {
                    throw new InvalidActionException("failed to parse " + JobAttribute.DESTRUCTION_TIME.getAttributeName() + ": " + str + " (expected format " + "yyyy-MM-dd'T'HH:mm:ss.SSS" + ")");
                }
            }
            if (pathInfo.endsWith("quote")) {
                str = form.getFirstValue(JobAttribute.QUOTE.getAttributeName().toUpperCase());
                try {
                    quote = this.dateFormat.parse(str);
                }
                catch (ParseException e) {
                    throw new InvalidActionException("failed to parse " + JobAttribute.QUOTE.getAttributeName() + ": " + str + " (expected format " + "yyyy-MM-dd'T'HH:mm:ss.SSS" + ")");
                }
            }
            if (destruction != null || execDuration != null || quote != null) {
                LOGGER.debug("update " + this.jobID + ": " + destruction + "," + execDuration + "," + quote);
                this.getJobManager().update(this.jobID, destruction, execDuration, quote);
            }
            if (pathInfo.endsWith(this.jobID) && !(parameters = (jobCreator = new RestletJobCreator(null)).getParameterList(form)).isEmpty()) {
                LOGGER.debug("update " + this.jobID + ": " + parameters.size() + " parameters");
                this.getJobManager().update(this.jobID, parameters);
            }
            this.redirectToJob();
        }
        catch (TransientException t) {
            this.generateRetryRepresentation(t);
        }
        catch (JobPersistenceException ex) {
            throw new RuntimeException(ex);
        }
        catch (JobPhaseException ex) {
            throw new RuntimeException(ex);
        }
        catch (JobNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void buildXML(Document document) throws IOException {
        JobWriter writer = new JobWriter();
        Element root = writer.getRootElement(this.job);
        document.setRootElement(root);
    }
}

