/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos;

import ca.nrc.cadc.vos.Direction;
import ca.nrc.cadc.vos.Protocol;
import ca.nrc.cadc.vos.Transfer;
import ca.nrc.cadc.vos.TransferParsingException;
import ca.nrc.cadc.vos.View;
import ca.nrc.cadc.vos.XmlProcessor;
import ca.nrc.cadc.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferReader
implements XmlProcessor {
    private static Logger log = Logger.getLogger(TransferReader.class);
    protected Map<String, String> schemaMap;

    public TransferReader() {
        this(true);
    }

    public TransferReader(boolean enableSchemaValidation) {
        if (enableSchemaValidation) {
            String vospaceSchemaUrl20 = XmlUtil.getResourceUrlString("VOSpace-2.0.xsd", TransferReader.class);
            if (vospaceSchemaUrl20 == null) {
                throw new RuntimeException("failed to find VOSpace-2.0.xsd in classpath");
            }
            String vospaceSchemaUrl21 = XmlUtil.getResourceUrlString("VOSpace-2.1.xsd", TransferReader.class);
            if (vospaceSchemaUrl21 == null) {
                throw new RuntimeException("failed to find VOSpace-2.1.xsd in classpath");
            }
            this.schemaMap = new HashMap<String, String>();
            this.schemaMap.put("http://www.ivoa.net/xml/VOSpace/v2.0", vospaceSchemaUrl20);
            this.schemaMap.put("http://www.ivoa.net/xml/VOSpace/v2.1", vospaceSchemaUrl21);
            log.debug("schema validation enabled");
        } else {
            log.debug("schema validation disabled");
        }
    }

    public Transfer read(Reader reader, String targetScheme) throws IOException, TransferParsingException {
        try {
            Document doc = XmlUtil.buildDocument(reader, this.schemaMap);
            return this.parseTransfer(doc, targetScheme);
        }
        catch (JDOMException ex) {
            throw new TransferParsingException("failed to parse XML", ex);
        }
        catch (URISyntaxException ex) {
            throw new TransferParsingException("invalid URI in transfer document", ex);
        }
    }

    public Transfer read(InputStream in, String targetScheme) throws IOException, TransferParsingException {
        InputStreamReader reader = new InputStreamReader(in);
        return this.read(reader, targetScheme);
    }

    public Transfer read(String string, String targetScheme) throws IOException, TransferParsingException {
        StringReader reader = new StringReader(string);
        return this.read(reader, targetScheme);
    }

    private Transfer parseTransfer(Document document, String targetScheme) throws URISyntaxException {
        int version;
        Element root = document.getRootElement();
        Namespace vosNS = root.getNamespace();
        if ("http://www.ivoa.net/xml/VOSpace/v2.0".equals(vosNS.getURI())) {
            version = 20;
        } else if ("http://www.ivoa.net/xml/VOSpace/v2.1".equals(vosNS.getURI())) {
            version = 21;
        } else {
            throw new IllegalArgumentException("unexpected VOSpace namespace: " + vosNS.getURI());
        }
        Direction direction = this.parseDirection(root, vosNS);
        URI target = new URI(root.getChildText("target", vosNS));
        if (targetScheme != null && !targetScheme.equalsIgnoreCase(target.getScheme())) {
            throw new IllegalArgumentException("Target scheme must be: " + targetScheme);
        }
        View view = null;
        View.Parameter param = null;
        List<Element> views = root.getChildren("view", vosNS);
        if (views != null && views.size() > 0) {
            Element v = views.get(0);
            view = new View(new URI(v.getAttributeValue("uri")));
            List<Element> params = v.getChildren("param", vosNS);
            if (params != null) {
                Iterator<Element> iterator = params.iterator();
                while (iterator.hasNext()) {
                    Element o;
                    Element p = o = iterator.next();
                    param = new View.Parameter(new URI(p.getAttributeValue("uri")), p.getText());
                    view.getParameters().add(param);
                }
            }
        }
        List<Protocol> protocols = this.parseProtocols(root, vosNS, version);
        String keepBytesStr = root.getChildText("keepBytes", vosNS);
        boolean keepBytes = true;
        if (keepBytesStr != null) {
            keepBytes = keepBytesStr.equalsIgnoreCase("true");
        }
        Transfer ret = new Transfer(target, direction, view, protocols, keepBytes);
        ret.version = version;
        if (version >= 21) {
            List<Element> params = root.getChildren("param", vosNS);
            for (Element pe : params) {
                String uri = pe.getAttributeValue("uri");
                if ("ivo://ivoa.net/vospace/core#length".equals(uri)) {
                    try {
                        ret.setContentLength(new Long(pe.getText()));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("invalid ivo://ivoa.net/vospace/core#length: " + pe.getText());
                    }
                }
                log.debug("skip unknown param: " + uri);
            }
        }
        return ret;
    }

    private Direction parseDirection(Element root, Namespace vosNS) {
        Direction rtn = null;
        String strDirection = root.getChildText("direction", vosNS);
        if (strDirection == null) {
            throw new RuntimeException("Did not find direction element in XML.");
        }
        rtn = strDirection.equalsIgnoreCase(Direction.pullFromVoSpace.getValue()) ? Direction.pullFromVoSpace : (strDirection.equalsIgnoreCase(Direction.pullToVoSpace.getValue()) ? Direction.pullToVoSpace : (strDirection.equalsIgnoreCase(Direction.pushFromVoSpace.getValue()) ? Direction.pushFromVoSpace : (strDirection.equalsIgnoreCase(Direction.pushToVoSpace.getValue()) ? Direction.pushToVoSpace : new Direction(strDirection))));
        return rtn;
    }

    private List<Protocol> parseProtocols(Element root, Namespace vosNS, int version) {
        ArrayList<Protocol> rtn = null;
        List<Element> prots = root.getChildren("protocol", vosNS);
        if (prots != null && prots.size() > 0) {
            rtn = new ArrayList<Protocol>(prots.size());
            Iterator<Element> iterator = prots.iterator();
            while (iterator.hasNext()) {
                Element eSec;
                Element obj;
                Element eProtocol = obj = iterator.next();
                String uri = eProtocol.getAttributeValue("uri");
                Protocol p = new Protocol(uri);
                String endpoint = eProtocol.getChildText("endpoint", vosNS);
                if (endpoint != null) {
                    p.setEndpoint(endpoint);
                }
                if (version >= 21 && (eSec = eProtocol.getChild("securityMethod", vosNS)) != null) {
                    String secVal = eSec.getAttributeValue("uri");
                    try {
                        p.setSecurityMethod(new URI(secVal));
                    }
                    catch (URISyntaxException ex) {
                        throw new IllegalArgumentException("invalid securityMethod: " + secVal, ex);
                    }
                }
                rtn.add(p);
            }
        }
        return rtn;
    }
}

