/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.client;

import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileSizeType {
    BYTE(1L),
    KILOBYTE(BYTE.getSize() * 1024L),
    MEGABYTE(KILOBYTE.getSize() * 1024L),
    GIGABYTE(MEGABYTE.getSize() * 1024L),
    TERRABYTE(GIGABYTE.getSize() * 1024L);

    private static final String DECIMAL_FORMAT = "0.00";
    private long size;

    private FileSizeType(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public static String getHumanReadableSize(long size) {
        DecimalFormat formatter = new DecimalFormat(DECIMAL_FORMAT);
        if (size < KILOBYTE.getSize()) {
            return size + "B";
        }
        if (size < MEGABYTE.getSize()) {
            return formatter.format((double)size / ((double)KILOBYTE.getSize() * 1.0)) + "KB";
        }
        if (size < GIGABYTE.getSize()) {
            return formatter.format((double)size / ((double)MEGABYTE.getSize() * 1.0)) + "MB";
        }
        if (size < TERRABYTE.getSize()) {
            return formatter.format((double)size / ((double)GIGABYTE.getSize() * 1.0)) + "GB";
        }
        return formatter.format((double)size / ((double)TERRABYTE.getSize() * 1.0)) + "TB";
    }
}

