/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.client;

import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.JobWriter;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeNotFoundException;
import ca.nrc.cadc.vos.NodeWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class VOSClientUtil {
    public static String xmlString(Job job) {
        String xml = null;
        StringWriter sw = new StringWriter();
        try {
            JobWriter jobWriter = new JobWriter();
            jobWriter.write(job, sw);
            xml = sw.toString();
            sw.close();
        }
        catch (IOException e) {
            xml = "Error getting XML string from job: " + e.getMessage();
        }
        return xml;
    }

    public static String xmlString(Node node) {
        String xml = null;
        StringWriter sw = new StringWriter();
        try {
            NodeWriter nodeWriter = new NodeWriter();
            nodeWriter.write(node, (Writer)sw);
            xml = sw.toString();
            sw.close();
        }
        catch (IOException e) {
            xml = "Error getting XML string from node: " + e.getMessage();
        }
        return xml;
    }

    public static String xmlString(Document doc) {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        return outputter.outputString(doc);
    }

    public static void checkFailure(Throwable failure) throws NodeNotFoundException, RuntimeException {
        if (failure != null) {
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof FileNotFoundException) {
                throw new NodeNotFoundException("not found.", failure);
            }
            throw new IllegalStateException(failure);
        }
    }
}

