/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.client;

import ca.nrc.cadc.auth.SSLUtil;
import ca.nrc.cadc.net.HttpDownload;
import ca.nrc.cadc.net.HttpPost;
import ca.nrc.cadc.net.HttpTransfer;
import ca.nrc.cadc.net.HttpUpload;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.net.OutputStreamWrapper;
import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.Direction;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeLockedException;
import ca.nrc.cadc.vos.NodeNotFoundException;
import ca.nrc.cadc.vos.NodeParsingException;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.NodeReader;
import ca.nrc.cadc.vos.NodeWriter;
import ca.nrc.cadc.vos.Protocol;
import ca.nrc.cadc.vos.Transfer;
import ca.nrc.cadc.vos.TransferParsingException;
import ca.nrc.cadc.vos.TransferReader;
import ca.nrc.cadc.vos.TransferWriter;
import ca.nrc.cadc.vos.VOSURI;
import ca.nrc.cadc.vos.View;
import ca.nrc.cadc.vos.client.ClientRecursiveSetNode;
import ca.nrc.cadc.vos.client.ClientTransfer;
import ca.nrc.cadc.vos.client.VOSClientUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VOSpaceClient {
    private static Logger log = Logger.getLogger(VOSpaceClient.class);
    public static final String CR = System.getProperty("line.separator");
    public static final String VOSPACE_SYNC_TRANSFER_ENDPOINT = "/synctrans";
    public static final String VOSPACE_ASYNC_TRANSFER_ENDPOINT = "/transfers";
    public static final String VOSPACE_ASYNC_NODEPROPS_ENDPONT = "/nodeprops";
    public static final String VOSPACE_NODE_ENDPOINT = "/nodes";
    protected String baseUrl;
    boolean schemaValidation;
    private SSLSocketFactory sslSocketFactory;

    public VOSpaceClient(String baseUrl) {
        this(baseUrl, true);
    }

    public VOSpaceClient(String baseUrl, boolean enableSchemaValidation) {
        this.baseUrl = baseUrl;
        this.schemaValidation = enableSchemaValidation;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public SSLSocketFactory getSslSocketFactory() {
        this.initHTTPS(null);
        return this.sslSocketFactory;
    }

    public Node createNode(Node node) {
        return this.createNode(node, true);
    }

    public Node createNode(Node node, boolean checkForDuplicate) {
        Node rtnNode = null;
        log.debug("createNode(), node=" + node + ", checkForDuplicate=" + checkForDuplicate);
        try {
            VOSURI parentURI = node.getUri().getParentURI();
            ContainerNode parent = null;
            if (parentURI == null) {
                throw new RuntimeException("parent (root node) not found and cannot create: " + node.getUri());
            }
            try {
                Node p = null;
                p = checkForDuplicate ? this.getNode(parentURI.getPath(), "detail=min&limit=1&uri=" + NetUtil.encode(node.getUri().toString())) : this.getNode(parentURI.getPath(), "detail=min&limit=0");
                log.debug("found parent: " + parentURI);
                if (!(p instanceof ContainerNode)) {
                    throw new IllegalArgumentException("cannot create a child, parent is a " + p.getClass().getSimpleName());
                }
                parent = (ContainerNode)p;
            }
            catch (NodeNotFoundException ex) {
                log.info("creating parent: " + parentURI);
                ContainerNode cn = new ContainerNode(parentURI);
                parent = (ContainerNode)this.createNode(cn, false);
            }
            if (checkForDuplicate) {
                for (Node n : parent.getNodes()) {
                    if (!n.getName().equals(node.getName())) continue;
                    throw new IllegalArgumentException("DuplicateNode: " + node.getUri().getURI().toASCIIString());
                }
            }
            URL url = new URL(this.baseUrl + VOSPACE_NODE_ENDPOINT + node.getUri().getPath());
            log.debug("createNode(), URL=" + url);
            NodeOutputStream out = new NodeOutputStream(node);
            HttpUpload put = new HttpUpload(out, url);
            put.setContentType("text/xml");
            this.runHttpTransfer(put);
            VOSClientUtil.checkFailure(put.getThrowable());
            NodeReader nodeReader = new NodeReader(this.schemaValidation);
            rtnNode = nodeReader.read(put.getResponseBody());
            log.debug("createNode, created node: " + rtnNode);
        }
        catch (IOException e) {
            log.debug("failed to create node", e);
            throw new IllegalStateException("failed to create node", e);
        }
        catch (NodeParsingException e) {
            log.debug("failed to create node", e);
            throw new IllegalStateException("failed to create node", e);
        }
        catch (NodeNotFoundException e) {
            log.debug("failed to create node", e);
            throw new IllegalStateException("Node not found", e);
        }
        return rtnNode;
    }

    public Node getNode(String path) throws NodeNotFoundException {
        return this.getNode(path, null);
    }

    public Node getNode(String path, String query) throws NodeNotFoundException {
        if (path.length() > 0 && !path.startsWith("/")) {
            path = "/" + path;
        }
        if (query != null) {
            path = path + "?" + query;
        }
        Node rtnNode = null;
        try {
            URL url = new URL(this.baseUrl + VOSPACE_NODE_ENDPOINT + path);
            log.debug("getNode(), URL=" + url);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpDownload get = new HttpDownload(url, out);
            this.runHttpTransfer(get);
            VOSClientUtil.checkFailure(get.getThrowable());
            NodeReader nodeReader = new NodeReader(this.schemaValidation);
            rtnNode = nodeReader.read(new String(out.toByteArray(), "UTF-8"));
            log.debug("getNode, returned node: " + rtnNode);
        }
        catch (IOException ex) {
            log.debug("failed to get node", ex);
            throw new IllegalStateException("failed to get node", ex);
        }
        catch (NodeParsingException e) {
            log.debug("failed to get node", e);
            throw new IllegalStateException("failed to get node", e);
        }
        return rtnNode;
    }

    public Node setNode(Node node) {
        Node rtnNode = null;
        try {
            URL url = new URL(this.baseUrl + VOSPACE_NODE_ENDPOINT + node.getUri().getPath());
            log.debug("setNode: " + VOSClientUtil.xmlString(node));
            log.debug("setNode: " + url);
            NodeWriter nodeWriter = new NodeWriter();
            StringBuilder nodeXML = new StringBuilder();
            nodeWriter.write(node, nodeXML);
            HttpPost httpPost = new HttpPost(url, nodeXML.toString(), null, false);
            this.runHttpTransfer(httpPost);
            VOSClientUtil.checkFailure(httpPost.getThrowable());
            String responseBody = httpPost.getResponseBody();
            NodeReader nodeReader = new NodeReader();
            rtnNode = nodeReader.read(responseBody);
        }
        catch (IOException e) {
            throw new IllegalStateException("failed to set node", e);
        }
        catch (NodeParsingException e) {
            throw new IllegalStateException("failed to set node", e);
        }
        catch (NodeNotFoundException e) {
            throw new IllegalStateException("Node not found", e);
        }
        return rtnNode;
    }

    public ClientRecursiveSetNode setNodeRecursive(Node node) {
        try {
            String asyncNodePropsUrl = this.baseUrl + VOSPACE_ASYNC_NODEPROPS_ENDPONT;
            NodeWriter nodeWriter = new NodeWriter();
            StringWriter stringWriter = new StringWriter();
            nodeWriter.write(node, (Writer)stringWriter);
            URL postUrl = new URL(asyncNodePropsUrl);
            HttpPost httpPost = new HttpPost(postUrl, ((Object)stringWriter).toString(), "text/xml", false);
            this.runHttpTransfer(httpPost);
            VOSClientUtil.checkFailure(httpPost.getThrowable());
            URL jobUrl = httpPost.getRedirectURL();
            log.debug("Job URL is: " + jobUrl.toString());
            return new ClientRecursiveSetNode(jobUrl, node, this.schemaValidation);
        }
        catch (MalformedURLException e) {
            log.debug("failed to create transfer", e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.debug("failed to create transfer", e);
            throw new RuntimeException(e);
        }
        catch (NodeNotFoundException e) {
            log.debug("Node not found", e);
            throw new RuntimeException(e);
        }
    }

    public ClientTransfer createTransfer(Transfer trans) {
        if (Direction.pushToVoSpace.equals(trans.getDirection())) {
            return this.createTransferSync(trans);
        }
        if (Direction.pullFromVoSpace.equals(trans.getDirection())) {
            return this.createTransferSync(trans);
        }
        return this.createTransferASync(trans);
    }

    public List<NodeProperty> getProperties() {
        throw new UnsupportedOperationException("Feature under construction.");
    }

    public List<Protocol> getProtocols() {
        throw new UnsupportedOperationException("Feature under construction.");
    }

    public List<View> getViews() {
        throw new UnsupportedOperationException("Feature under construction.");
    }

    public void deleteNode(String path) {
        if (path.length() > 0 && !path.startsWith("/")) {
            path = "/" + path;
        }
        try {
            URL url = new URL(this.baseUrl + VOSPACE_NODE_ENDPOINT + path);
            log.debug(url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection sslConn = (HttpsURLConnection)connection;
                this.initHTTPS(sslConn);
            }
            connection.setDoOutput(true);
            connection.setRequestMethod("DELETE");
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(false);
            String responseMessage = connection.getResponseMessage();
            String errorBody = NetUtil.getErrorBody(connection);
            if (StringUtil.hasText(errorBody)) {
                responseMessage = responseMessage + ": " + errorBody;
            }
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: {
                    break;
                }
                case 500: {
                    throw new RuntimeException(responseMessage);
                }
                case 401: {
                    String msg = responseMessage;
                    if (msg == null) {
                        msg = "permission denied";
                    }
                    throw new AccessControlException(msg);
                }
                case 404: {
                    throw new IllegalArgumentException(responseMessage);
                }
                case 423: {
                    throw new NodeLockedException(responseMessage);
                }
                default: {
                    log.error(responseMessage + ". HTTP Code: " + responseCode);
                    throw new RuntimeException("unexpected failure mode: " + responseMessage + "(" + responseCode + ")");
                }
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("failed to delete node", ex);
        }
    }

    public String getBaseURL() {
        return this.baseUrl;
    }

    private ClientTransfer createTransferASync(Transfer transfer) {
        try {
            String asyncTransUrl = this.baseUrl + VOSPACE_ASYNC_TRANSFER_ENDPOINT;
            TransferWriter transferWriter = new TransferWriter();
            StringWriter stringWriter = new StringWriter();
            transferWriter.write(transfer, (Writer)stringWriter);
            URL postUrl = new URL(asyncTransUrl);
            HttpPost httpPost = new HttpPost(postUrl, ((Object)stringWriter).toString(), "text/xml", false);
            this.runHttpTransfer(httpPost);
            if (httpPost.getThrowable() != null) {
                log.debug("Unable to post transfer because ", httpPost.getThrowable());
                throw new RuntimeException("Unable to post transfer because " + httpPost.getThrowable().getMessage());
            }
            URL jobUrl = httpPost.getRedirectURL();
            log.debug("Job URL is: " + jobUrl.toString());
            return new ClientTransfer(jobUrl, transfer, this.schemaValidation);
        }
        catch (MalformedURLException e) {
            log.debug("failed to create transfer", e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.debug("failed to create transfer", e);
            throw new RuntimeException(e);
        }
    }

    private ClientTransfer createTransferSync(Transfer transfer) {
        try {
            URL postUrl = new URL(this.baseUrl + VOSPACE_SYNC_TRANSFER_ENDPOINT);
            HttpPost httpPost = null;
            if (transfer.isQuickTransfer()) {
                HashMap<String, Object> form = new HashMap<String, Object>();
                form.put("TARGET", transfer.getTarget());
                form.put("DIRECTION", transfer.getDirection().getValue());
                form.put("PROTOCOL", transfer.getProtocols().iterator().next().getUri());
                httpPost = new HttpPost(postUrl, form, false);
            } else {
                TransferWriter writer = new TransferWriter();
                StringWriter sw = new StringWriter();
                writer.write(transfer, (Writer)sw);
                httpPost = new HttpPost(postUrl, sw.toString(), "text/xml", false);
            }
            this.runHttpTransfer(httpPost);
            if (httpPost.getThrowable() != null) {
                log.debug("Unable to post transfer because ", httpPost.getThrowable());
                throw new RuntimeException("Unable to post transfer because " + httpPost.getThrowable().getMessage());
            }
            URL redirectURL = httpPost.getRedirectURL();
            if (redirectURL == null) {
                throw new RuntimeException("Redirect not received from UWS.");
            }
            if (transfer.isQuickTransfer()) {
                log.debug("Quick transfer URL: " + redirectURL);
                ArrayList<Protocol> prots = new ArrayList<Protocol>();
                prots.add(new Protocol(transfer.getProtocols().iterator().next().getUri(), redirectURL.toString(), null));
                Transfer trf = new Transfer(transfer.getTarget(), transfer.getDirection(), prots);
                return new ClientTransfer(null, trf, false);
            }
            log.debug("POST: transfer jobURL: " + redirectURL);
            log.debug("GET - opening connection: " + redirectURL.toString());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            HttpDownload get = new HttpDownload(redirectURL, out);
            this.runHttpTransfer(get);
            if (get.getThrowable() != null) {
                log.debug("Unable to run the job", get.getThrowable());
                throw new RuntimeException("Unable to run the job because " + get.getThrowable().getMessage());
            }
            String transDoc = new String(out.toByteArray(), "UTF-8");
            log.debug("transfer response: " + transDoc);
            TransferReader txfReader = new TransferReader(this.schemaValidation);
            log.debug("GET - reading content: " + redirectURL);
            Transfer trans = txfReader.read(transDoc, "vos");
            log.debug("GET - done: " + redirectURL);
            log.debug("negotiated transfer: " + trans);
            URL jobURL = this.extractJobURL(this.baseUrl, redirectURL);
            return new ClientTransfer(jobURL, trans, this.schemaValidation);
        }
        catch (MalformedURLException e) {
            log.debug("failed to create transfer", e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.debug("failed to create transfer", e);
            throw new RuntimeException(e);
        }
        catch (TransferParsingException e) {
            log.debug("got invalid XML from service", e);
            throw new RuntimeException(e);
        }
    }

    private URL extractJobURL(String baseURL, URL transferDetailsURL) throws MalformedURLException {
        URL u = new URL(baseURL);
        String bp = u.getPath();
        String tu = transferDetailsURL.toExternalForm();
        int i = tu.indexOf(bp);
        String jp = tu.substring(i + bp.length() + 1);
        String[] parts = jp.split("/");
        String jobList = parts[0];
        String jobID = parts[1];
        return new URL(baseURL + "/" + jobList + "/" + jobID);
    }

    private void initHTTPS(HttpsURLConnection sslConn) {
        if (this.sslSocketFactory == null) {
            log.debug("initHTTPS: lazy init");
            AccessControlContext ac = AccessController.getContext();
            Subject s = Subject.getSubject(ac);
            this.sslSocketFactory = SSLUtil.getSocketFactory(s);
        }
        if (this.sslSocketFactory != null && sslConn != null) {
            log.debug("setting SSLSocketFactory on " + sslConn.getClass().getName());
            sslConn.setSSLSocketFactory(this.sslSocketFactory);
        }
    }

    private void runHttpTransfer(HttpTransfer transfer) {
        if (this.sslSocketFactory != null) {
            transfer.setSSLSocketFactory(this.sslSocketFactory);
        }
        transfer.run();
        if (transfer.getSSLSocketFactory() != null) {
            this.sslSocketFactory = transfer.getSSLSocketFactory();
        }
    }

    private class NodeOutputStream
    implements OutputStreamWrapper {
        private Node node;

        public NodeOutputStream(Node node) {
            this.node = node;
        }

        public void write(OutputStream out) throws IOException {
            NodeWriter writer = new NodeWriter();
            writer.write(this.node, out);
        }
    }
}

