/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.web.representation;

import ca.nrc.cadc.io.ByteCountInputStream;
import ca.nrc.cadc.io.ByteLimitExceededException;
import ca.nrc.cadc.vos.Node;
import ca.nrc.cadc.vos.NodeParsingException;
import ca.nrc.cadc.vos.NodeReader;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.restlet.representation.Representation;

public class NodeInputRepresentation {
    protected static Logger log = Logger.getLogger(NodeInputRepresentation.class);
    private static final long DOCUMENT_SIZE_MAX = 12288L;
    private Representation xmlValue;
    private String expectedPath;

    public NodeInputRepresentation(Representation xmlValue, String expectedPath) {
        this.xmlValue = xmlValue;
        this.expectedPath = expectedPath;
    }

    public Node getNode() throws IOException, NodeParsingException, URISyntaxException, ByteLimitExceededException {
        ByteCountInputStream sizeLimitInputStream = new ByteCountInputStream(this.xmlValue.getStream(), 12288L);
        Node node = new NodeReader().read(sizeLimitInputStream);
        log.debug("Node input representation read " + sizeLimitInputStream.getByteCount() + " bytes.");
        if (!node.getUri().getPath().equals(this.expectedPath)) {
            throw new NodeParsingException("Node path in URI XML (" + node.getUri().getPath() + ") not equal to node path in URL (" + this.expectedPath + ")");
        }
        return node;
    }
}

