/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos.server.web.restlet.resource;

import ca.nrc.cadc.auth.AuthenticationUtil;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.util.StringUtil;
import ca.nrc.cadc.uws.web.restlet.RestletPrincipalExtractor;
import ca.nrc.cadc.vos.NodeFault;
import ca.nrc.cadc.vos.server.NodePersistence;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.resource.ServerResource;

public abstract class BaseResource
extends ServerResource {
    private static Logger log = Logger.getLogger(BaseResource.class);
    private static final String CERTIFICATE_REQUEST_ATTRIBUTE_NAME = "org.restlet.https.clientCertificates";
    private String vosUriPrefix;
    private NodePersistence nodePersistence;
    private String stylesheetReference;
    private Subject subject;

    protected BaseResource() {
        ConcurrentMap attributes = this.getApplication().getContext().getAttributes();
        this.vosUriPrefix = (String)attributes.get("ivoa.vos.uri");
        this.nodePersistence = (NodePersistence)attributes.get("ca.nrc.cadc.vos.NodePersistence");
        this.stylesheetReference = (String)attributes.get("VOSpaceStylesheetReference");
    }

    public void doInit() {
        CopyOnWriteArraySet<Method> allowedMethods = new CopyOnWriteArraySet<Method>();
        allowedMethods.add(Method.GET);
        allowedMethods.add(Method.PUT);
        allowedMethods.add(Method.DELETE);
        allowedMethods.add(Method.POST);
        this.setAllowedMethods(allowedMethods);
        this.subject = AuthenticationUtil.getSubject(new RestletPrincipalExtractor(this.getRequest()));
        log.debug(this.subject);
    }

    protected String getRequestMethod() {
        return this.getRequest().getMethod().getName().toUpperCase();
    }

    protected String getPath() {
        return this.getRequest().getResourceRef().getPath();
    }

    protected String getRemoteAddr() {
        return this.getRequest().getClientInfo().getAddress();
    }

    protected String getErrorMessage(NodeFault nodeFault) {
        if (nodeFault != null && nodeFault.getStatus() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(nodeFault.getStatus().getName());
            sb.append(" (");
            sb.append(nodeFault.getStatus().getCode());
            sb.append(")");
            if (StringUtil.hasText(nodeFault.getMessage())) {
                sb.append(": ");
                sb.append(nodeFault.getMessage());
            }
            return sb.toString();
        }
        return "";
    }

    protected String getUser() {
        Set<Principal> principals;
        Subject subject = this.getSubject();
        if (subject != null && !(principals = subject.getPrincipals()).isEmpty()) {
            Principal userPrincipal = null;
            for (Principal nextPrincipal : principals) {
                if (userPrincipal instanceof HttpPrincipal) continue;
                userPrincipal = nextPrincipal;
            }
            return userPrincipal.getName();
        }
        return "anonUser";
    }

    public Form getQueryForm() {
        return this.getRequest().getResourceRef().getQueryAsForm();
    }

    public final String getVosUriPrefix() {
        return this.vosUriPrefix;
    }

    public final NodePersistence getNodePersistence() {
        return this.nodePersistence;
    }

    public final String getStylesheetReference() {
        return this.stylesheetReference;
    }

    public final Subject getSubject() {
        return this.subject;
    }
}

