/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.log4j.Logger;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.DefaultSAXHandlerFactory;
import org.jdom2.input.sax.XMLReaderSAX2Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    private static Logger log = Logger.getLogger(XmlUtil.class);
    public static final String PARSER = "org.apache.xerces.parsers.SAXParser";
    private static final String GRAMMAR_POOL = "org.apache.xerces.parsers.XMLGrammarCachingConfiguration";
    public static final Namespace XSI_NS = Namespace.getNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");

    public static Document validateXML(Reader reader) throws JDOMException, IOException {
        return XmlUtil.buildDocument(reader, null);
    }

    public static Document validateXML(Reader reader, Map<String, String> schemaMap) throws JDOMException, IOException {
        return XmlUtil.buildDocument(reader, schemaMap);
    }

    public static Document buildDocument(String xml) throws JDOMException, IOException {
        return XmlUtil.buildDocument(new StringReader(xml));
    }

    public static Document buildDocument(String xml, String schemaNamespace, String schemaResourceFileName) throws IOException, JDOMException {
        if (schemaNamespace == null || schemaResourceFileName == null) {
            throw new IllegalArgumentException("schemaNamespace and schemaResourceFileName cannot be null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(schemaNamespace, XmlUtil.getResourceUrlString(schemaResourceFileName, XmlUtil.class));
        return XmlUtil.buildDocument(new StringReader(xml), map);
    }

    public static Document buildDocument(InputStream istream) throws JDOMException, IOException {
        return XmlUtil.buildDocument(new InputStreamReader(istream), null);
    }

    public static Document buildDocument(Reader reader) throws JDOMException, IOException {
        return XmlUtil.buildDocument(reader, null);
    }

    public static Document buildDocument(InputStream istream, Map<String, String> schemaMap) throws JDOMException, IOException {
        return XmlUtil.buildDocument(new InputStreamReader(istream), schemaMap);
    }

    public static Document buildDocument(Reader reader, Map<String, String> schemaMap) throws IOException, JDOMException {
        SAXBuilder sb = XmlUtil.createBuilder(schemaMap);
        return sb.build(reader);
    }

    public static SAXBuilder createBuilder(Map<String, String> schemaMap) {
        boolean validate = schemaMap != null && !schemaMap.isEmpty();
        XMLReaderSAX2Factory rf = new XMLReaderSAX2Factory(validate, PARSER);
        DefaultSAXHandlerFactory sh = new DefaultSAXHandlerFactory();
        DefaultJDOMFactory jf = new DefaultJDOMFactory();
        boolean schemaVal = schemaMap != null;
        String space = " ";
        StringBuilder sbSchemaLocations = new StringBuilder();
        if (schemaVal) {
            log.debug("schemaMap.size(): " + schemaMap.size());
            for (String schemaNSKey : schemaMap.keySet()) {
                String schemaResource = schemaMap.get(schemaNSKey);
                sbSchemaLocations.append(schemaNSKey).append(space).append(schemaResource).append(space);
            }
            System.setProperty("org.apache.xerces.xni.parser.XMLParserConfiguration", GRAMMAR_POOL);
        }
        SAXBuilder builder = new SAXBuilder(rf, sh, jf);
        if (schemaVal) {
            builder.setFeature("http://xml.org/sax/features/validation", true);
            builder.setFeature("http://apache.org/xml/features/validation/schema", true);
            if (schemaMap.size() > 0) {
                builder.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", sbSchemaLocations.toString());
            }
        }
        return builder;
    }

    public static String getResourceUrlString(String resourceFileName, Class runningClass) {
        String rtn = null;
        URL url = runningClass.getClassLoader().getResource(resourceFileName);
        if (url == null) {
            throw new MissingResourceException("Resource not found: " + resourceFileName, runningClass.getName(), resourceFileName);
        }
        rtn = url.toString();
        return rtn;
    }
}

