/**_____________________________________________________________________________
 *
 *                                 OATS - INAF
 *  Osservatorio Astronomico di Tireste - Istituto Nazionale di Astrofisica
 *  Astronomical Observatory of Trieste - National Institute for Astrophysics
 * ____________________________________________________________________________
 *
 * Copyright (C) 20016  Istituto Nazionale di Astrofisica
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * _____________________________________________________________________________
 **/
package it.inaf.oats.vospacebackend.implementation;

import java.util.HashMap;


public class FileRecord {
    
    private static final String stored_file_name   = "stored_file_name";
    private static final String md5_checksum       = "md5_checksum"; 
    private static final String relative_path      = "relative_path";  
    private static final String nodeID             = "nodeID";       
    
    private HashMap content = new HashMap<String, String>();
    
    public FileRecord() {
        
        content.put(stored_file_name, "");
        content.put(md5_checksum, "");
        content.put(relative_path, "");
        content.put(nodeID, "");
        
    }
    
    public FileRecord(String stored_f_name, String md5Checksum, String relativePath) {
        
        content.put(stored_file_name, stored_f_name);
        content.put(md5_checksum, md5Checksum);
        content.put(relative_path, relativePath);
        
    }
    
    public FileRecord(String stored_f_name, String md5Checksum, String relativePath, String nodeIDStr) {

        content.put(stored_file_name, stored_f_name);
        content.put(md5_checksum, md5Checksum);
        content.put(relative_path, relativePath);
        content.put(nodeID, nodeIDStr);
        
    }
    
    public HashMap getFileRecord() {
        
        return content;
        
    }
    
    public void setFileRecord(String stored_f_name, String md5Checksum, String relativePath) {

        content.put(stored_file_name, stored_f_name);
        content.put(md5_checksum, md5Checksum);
        content.put(relative_path, relativePath);
        
    }
    
}

