/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.inaf.oats.vospacebackend.implementation;

import ca.nrc.cadc.uws.server.JobExecutor;
import ca.nrc.cadc.uws.server.SimpleJobManager;
import ca.nrc.cadc.uws.server.ThreadPoolExecutor;
import ca.nrc.cadc.vos.server.transfers.TransferRunner;

/**
 *
 * @author bertocco
 */
public class TransferJobManager extends SimpleJobManager {
    
    public TransferJobManager() {
        
        super();
        Long MAX_EXEC_DURATION = new Long(600L);;
        Long MAX_DESTRUCTION = new Long(1L+MAX_EXEC_DURATION);
        Long MAX_QUOTE = new Long(600L);
        
        DatabaseJobPersistenceImpl jobPersist = new DatabaseJobPersistenceImpl();
        //this.config = jobPersist.getJobSchema();
        
        // exec jobs in in new thread using our custom TransferRunner
        JobExecutor jobExec = new ThreadPoolExecutor(jobPersist, TransferRunner.class, 6);

        super.setJobPersistence(jobPersist);
        super.setJobExecutor(jobExec);
        super.setMaxExecDuration(MAX_EXEC_DURATION);
        super.setMaxDestruction(MAX_DESTRUCTION);
        super.setMaxQuote(MAX_QUOTE);
    }
}
