/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import ca.nrc.cadc.net.NetUtil;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger log = Logger.getLogger(FileUtil.class);

    public static boolean delete(File f, boolean recursive) throws IOException {
        if (!f.exists()) {
            return false;
        }
        if (recursive && f.isDirectory()) {
            File[] children;
            for (File c : children = f.listFiles()) {
                if (FileUtil.delete(c, true)) continue;
                return false;
            }
        }
        return f.delete();
    }

    public static boolean compare(File file1, File file2) throws IOException {
        long cs2;
        long cs1 = FileUtil.checksum(file1);
        return cs1 == (cs2 = FileUtil.checksum(file2));
    }

    public static long checksum(File file) throws IOException {
        FileInputStream fInStream = new FileInputStream(file);
        CheckedInputStream cInStream = new CheckedInputStream(fInStream, new CRC32());
        BufferedInputStream bInStream = new BufferedInputStream(cInStream);
        while (bInStream.read() != -1) {
        }
        return cInStream.getChecksum().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFile(File f) throws IOException {
        byte[] byArray;
        block5: {
            DataInputStream dis = null;
            try {
                dis = new DataInputStream(new FileInputStream(f));
                byte[] ret = new byte[(int)f.length()];
                dis.readFully(ret);
                dis.close();
                byArray = ret;
                Object var5_4 = null;
                if (dis == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (dis == null) break block6;
                    try {
                        dis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                dis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    public static File getFileFromResource(String resourceFileName, Class runningClass) {
        URL url = runningClass.getClassLoader().getResource(resourceFileName);
        BasicConfigurator.configure();
        if (url == null) {
            throw new MissingResourceException("Resource not found: " + resourceFileName, runningClass.getName(), resourceFileName);
        }
        System.out.println("SBE :Getting file from URL = " + url.toString());
        log.debug((Object)("SBE :Getting file from URL = " + url.toString()));
        return FileUtil.getFileFromURL(url);
    }

    public static File getFileFromURL(URL url) {
        log.debug((Object)("getFileFromURL: " + url));
        String path = url.getPath();
        File found = new File(URI.create(url.toExternalForm()));
        File f = found.exists() ? found : new File(NetUtil.decode(path));
        return f;
    }
}

