/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.util;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.LevelRangeFilter;

public class Log4jInit {
    private static boolean consoleAppendersCreated = false;
    private static final String SHORT_FORMAT = "%-4r [%t] %-5p %c{1} %x - %m\n";
    private static final String LONG_FORMAT = "%d{yyyy-MM-dd HH:mm:ss.SSS} [%t] %-5p %c{1} %x - %m\n";
    private static List<Writer> logWriters = new ArrayList<Writer>();

    public static synchronized void setLevel(String pkg, Level level) {
        Log4jInit.setLevel(null, pkg, level);
    }

    public static synchronized void setLevel(String appName, String pkg, Level level) {
        Log4jInit.createLog4jConsoleAppenders(appName);
        Logger.getLogger((String)pkg).setLevel(level);
    }

    public static synchronized void setLevel(String pkg, Level level, Writer dest) {
        Log4jInit.createLog4jWriterAppender(dest);
        Logger.getLogger((String)pkg).setLevel(level);
    }

    private static synchronized void createLog4jConsoleAppenders(String appName) {
        if (!consoleAppendersCreated) {
            BasicConfigurator.resetConfiguration();
            Logger.getRootLogger().setLevel(Level.ERROR);
            String errorLogFormat = LONG_FORMAT;
            String infoLogFormat = LONG_FORMAT;
            String debugLogFormat = SHORT_FORMAT;
            if (appName != null) {
                errorLogFormat = "%d{yyyy-MM-dd HH:mm:ss.SSS} " + appName + " [%t] %-5p %c{1} %x - %m\n";
                infoLogFormat = "%d{yyyy-MM-dd HH:mm:ss.SSS} " + appName + " [%t] %-5p %c{1} %x - %m\n";
                debugLogFormat = "%-4r " + appName + " [%t] %-5p %c{1} %x - %m\n";
            }
            ConsoleAppender conAppenderHigh = new ConsoleAppender((Layout)new PatternLayout(errorLogFormat));
            LevelRangeFilter errorFilter = new LevelRangeFilter();
            errorFilter.setLevelMax(Level.FATAL);
            errorFilter.setLevelMin(Level.WARN);
            errorFilter.setAcceptOnMatch(true);
            conAppenderHigh.clearFilters();
            conAppenderHigh.addFilter((Filter)errorFilter);
            BasicConfigurator.configure((Appender)conAppenderHigh);
            ConsoleAppender conAppenderInfo = new ConsoleAppender((Layout)new PatternLayout(infoLogFormat));
            LevelRangeFilter infoFilter = new LevelRangeFilter();
            infoFilter.setLevelMax(Level.INFO);
            infoFilter.setLevelMin(Level.INFO);
            infoFilter.setAcceptOnMatch(true);
            conAppenderInfo.clearFilters();
            conAppenderInfo.addFilter((Filter)infoFilter);
            BasicConfigurator.configure((Appender)conAppenderInfo);
            ConsoleAppender conAppenderDebug = new ConsoleAppender((Layout)new PatternLayout(debugLogFormat));
            LevelRangeFilter debugFilter = new LevelRangeFilter();
            debugFilter.setLevelMax(Level.DEBUG);
            debugFilter.setLevelMin(Level.TRACE);
            debugFilter.setAcceptOnMatch(true);
            conAppenderDebug.clearFilters();
            conAppenderDebug.addFilter((Filter)debugFilter);
            BasicConfigurator.configure((Appender)conAppenderDebug);
            consoleAppendersCreated = true;
        }
    }

    private static synchronized void createLog4jWriterAppender(Writer writer) {
        if (writer != null && !logWriters.contains(writer)) {
            WriterAppender app = new WriterAppender((Layout)new PatternLayout(LONG_FORMAT), writer);
            LevelRangeFilter filter = new LevelRangeFilter();
            filter.setLevelMax(Level.FATAL);
            filter.setLevelMin(Level.DEBUG);
            filter.setAcceptOnMatch(true);
            app.clearFilters();
            app.addFilter((Filter)filter);
            BasicConfigurator.configure((Appender)app);
            logWriters.add(writer);
        }
    }

    static {
        Logger.getRootLogger().setLevel(Level.ERROR);
    }
}

