/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.AuthMethod;
import ca.nrc.cadc.auth.Authenticator;
import ca.nrc.cadc.auth.CookiePrincipal;
import ca.nrc.cadc.auth.DelegationToken;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.IdentityType;
import ca.nrc.cadc.auth.NumericPrincipal;
import ca.nrc.cadc.auth.PrincipalExtractor;
import ca.nrc.cadc.auth.SSOCookieCredential;
import ca.nrc.cadc.auth.ServletPrincipalExtractor;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.date.DateUtil;
import ca.nrc.cadc.net.NetUtil;
import java.lang.reflect.Constructor;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationUtil {
    public static final String AUTH_HEADER = "X-CADC-DelegationToken";
    private static final String[] ORDERED_RDN_KEYS = new String[]{"DC", "CN", "OU", "O", "STREET", "L", "ST", "C", "UID"};
    private static final String DEFAULT_AUTH = Authenticator.class.getName() + "Impl";
    private static Logger log = Logger.getLogger(AuthenticationUtil.class);

    private static Authenticator getAuthenticator() {
        String cname = System.getProperty(Authenticator.class.getName());
        Class<?> c = null;
        if (cname == null) {
            cname = DEFAULT_AUTH;
        }
        try {
            c = Class.forName(cname);
            Object o = c.newInstance();
            Authenticator ret = (Authenticator)o;
            log.debug("Authenticator: " + cname);
            return ret;
        }
        catch (Throwable t) {
            if (!DEFAULT_AUTH.equals(cname) || c != null) {
                log.error("failed to load Authenticator: " + cname, t);
            }
            log.debug("failed to load Authenticator: " + cname, t);
            log.debug("Authenticator: null");
            return null;
        }
    }

    private static Subject augmentSubject(Subject s) {
        Authenticator auth = AuthenticationUtil.getAuthenticator();
        if (auth != null) {
            return auth.getSubject(s);
        }
        return s;
    }

    public static Subject getAnonSubject() {
        Subject ret = new Subject();
        AuthenticationUtil.setAuthMethod(ret, AuthMethod.ANON);
        return ret;
    }

    public static AuthMethod getAuthMethod(Subject s) {
        if (s == null) {
            return null;
        }
        Set<AuthMethod> m = s.getPublicCredentials(AuthMethod.class);
        if (m.isEmpty()) {
            return null;
        }
        return m.iterator().next();
    }

    private static void setAuthMethod(Subject s, AuthMethod am) {
        if (s == null || am == null) {
            return;
        }
        s.getPublicCredentials().add((Object)am);
    }

    public static Subject getSubject(PrincipalExtractor principalExtractor) {
        if (principalExtractor == null) {
            throw new IllegalArgumentException("principalExtractor cannot be null");
        }
        Set<Principal> principals = principalExtractor.getPrincipals();
        X509CertificateChain chain = principalExtractor.getCertificateChain();
        DelegationToken token = principalExtractor.getDelegationToken();
        SSOCookieCredential cookie = principalExtractor.getSSOCookieCredential();
        AuthMethod am = null;
        HashSet<Object> publicCred = new HashSet<Object>();
        HashSet privateCred = new HashSet();
        if (principals.isEmpty()) {
            am = AuthMethod.ANON;
        } else if (chain != null) {
            publicCred.add(chain);
            am = AuthMethod.CERT;
        } else if (token != null) {
            publicCred.add(token);
            am = AuthMethod.TOKEN;
        } else if (cookie != null) {
            publicCred.add(cookie);
            am = AuthMethod.COOKIE;
        } else {
            for (Principal o : principals) {
                if (!(o instanceof HttpPrincipal)) continue;
                am = AuthMethod.PASSWORD;
                break;
            }
        }
        Subject subject = new Subject(false, principals, publicCred, privateCred);
        AuthenticationUtil.setAuthMethod(subject, am);
        return AuthenticationUtil.augmentSubject(subject);
    }

    public static Subject getSubject(HttpServletRequest request) {
        return AuthenticationUtil.getSubject(new ServletPrincipalExtractor(request));
    }

    public static Subject getSubject(X509Certificate[] certs, PrivateKey key) {
        X509CertificateChain chain = new X509CertificateChain(certs, key);
        return AuthenticationUtil.getSubject(chain);
    }

    public static Subject getSubject(X509CertificateChain chain) {
        HashSet<X500Principal> principals = new HashSet<X500Principal>();
        HashSet<X509CertificateChain> publicCred = new HashSet<X509CertificateChain>();
        HashSet privateCred = new HashSet();
        if (chain != null) {
            principals.add(chain.getX500Principal());
            publicCred.add(chain);
        }
        Subject subject = new Subject(false, principals, publicCred, privateCred);
        return subject;
    }

    public static String encodeSubject(Subject subject) {
        if (subject == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Principal principal : subject.getPrincipals()) {
            sb.append(principal.getClass().getName());
            sb.append("[");
            sb.append(NetUtil.encode(principal.getName()));
            sb.append("]");
        }
        return sb.toString();
    }

    public static Set<String> getUseridsFromSubject() {
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        HashSet<String> userids = new HashSet<String>();
        if (subject != null) {
            Set<HttpPrincipal> httpPrincipals = subject.getPrincipals(HttpPrincipal.class);
            Set<CookiePrincipal> cookiePrincipals = subject.getPrincipals(CookiePrincipal.class);
            for (HttpPrincipal principal : httpPrincipals) {
                String userId = principal.getName();
                userids.add(userId);
            }
        }
        return userids;
    }

    public static Subject decodeSubject(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        Subject subject = null;
        int pStart = 0;
        int nameStart = s.indexOf("[", pStart);
        try {
            while (nameStart != -1) {
                int nameEnd = s.indexOf("]", nameStart);
                if (nameEnd == -1) {
                    log.error("Invalid Principal encoding: " + s);
                    return null;
                }
                Class<?> c = Class.forName(s.substring(pStart, nameStart));
                Class[] args = new Class[]{String.class};
                Constructor<?> constructor = c.getDeclaredConstructor(args);
                String name = NetUtil.decode(s.substring(nameStart + 1, nameEnd));
                Principal principal = (Principal)constructor.newInstance(name);
                if (subject == null) {
                    subject = new Subject();
                }
                subject.getPrincipals().add(principal);
                pStart = nameEnd + 1;
                nameStart = s.indexOf("[", pStart);
            }
        }
        catch (IndexOutOfBoundsException ioe) {
            log.error(ioe.getMessage(), ioe);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return subject;
    }

    public static X500Principal getOrderedForm(X500Principal p) {
        try {
            X500Principal ret = p;
            String up = p.getName("RFC2253");
            LdapName dn = new LdapName(up);
            List<Rdn> rdns = dn.getRdns();
            Rdn left = rdns.get(rdns.size() - 1);
            Rdn right = rdns.get(0);
            boolean cOnleft = "C".equalsIgnoreCase(left.getType());
            boolean cnOnRight = "CN".equalsIgnoreCase(right.getType());
            boolean flip = cnOnRight || cOnleft;
            StringBuilder sb = new StringBuilder();
            if (flip) {
                for (Rdn r : rdns) {
                    sb.append(r.toString());
                    sb.append(",");
                }
            } else {
                for (int i = rdns.size() - 1; i >= 0; --i) {
                    sb.append(rdns.get(i));
                    sb.append(",");
                }
            }
            ret = new X500Principal(sb.substring(0, sb.length() - 1));
            log.debug("ordered form of " + up + " is " + ret);
            X500Principal x500Principal = ret;
            return x500Principal;
        }
        catch (InvalidNameException ex) {
            throw new IllegalArgumentException("invalid DN: " + p.getName(), ex);
        }
    }

    public static <T extends Principal> Map<Class<T>, Collection<String>> groupPrincipalsByType() {
        HashMap<Class<T>, Collection<String>> groupedPrincipals = new HashMap<Class<T>, Collection<String>>();
        for (Principal p : AuthenticationUtil.getCurrentSubject().getPrincipals()) {
            Class<?> nextPrincipalClass = p.getClass();
            if (!groupedPrincipals.containsKey(p.getClass())) {
                groupedPrincipals.put(nextPrincipalClass, new HashSet());
            }
            ((Collection)groupedPrincipals.get(nextPrincipalClass)).add(p.getName());
        }
        return groupedPrincipals;
    }

    public static boolean equals(Principal p1, Principal p2) {
        if (p1 == null && p2 == null) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        if (p1 instanceof X500Principal) {
            if (p2 instanceof X500Principal) {
                String converted1 = AuthenticationUtil.canonizeDistinguishedName(p1.getName());
                String converted2 = AuthenticationUtil.canonizeDistinguishedName(p2.getName());
                return converted1.equals(converted2);
            }
            return false;
        }
        return !(p2 instanceof X500Principal) && p1.equals(p2);
    }

    public static String canonizeDistinguishedName(String dnSrc) {
        try {
            X500Principal x = new X500Principal(dnSrc);
            x = AuthenticationUtil.getOrderedForm(x);
            String ret = x.getName().trim().toLowerCase();
            log.debug(dnSrc + " converted to " + ret);
            return ret;
        }
        catch (Exception e) {
            log.debug("Invalid dn", e);
            throw new IllegalArgumentException("Invalid DN: " + dnSrc, e);
        }
    }

    public static X500Principal getX500Principal(Subject subject) {
        X500Principal x500Principal = null;
        Set<Principal> principals = subject.getPrincipals();
        for (Principal principal : principals) {
            if (!(principal instanceof X500Principal)) continue;
            x500Principal = (X500Principal)principal;
        }
        return x500Principal;
    }

    public static void checkCertificates(Subject subject) throws CertificateException, CertificateNotYetValidException, CertificateExpiredException {
        if (subject != null) {
            Set<X509CertificateChain> certs = subject.getPublicCredentials(X509CertificateChain.class);
            if (certs.isEmpty()) {
                throw new CertificateException("No certificates associated with the subject");
            }
            DateFormat df = DateUtil.getDateFormat("yyyy-MM-dd HH:mm:ss.SSS", DateUtil.LOCAL);
            X509CertificateChain chain = certs.iterator().next();
            Date start = null;
            Date end = null;
            for (X509Certificate c : chain.getChain()) {
                try {
                    start = c.getNotBefore();
                    end = c.getNotAfter();
                    c.checkValidity();
                }
                catch (CertificateExpiredException exp) {
                    String msg = "certificate has expired (valid from " + df.format(start) + " to " + df.format(end) + ")";
                    throw new CertificateExpiredException(msg);
                }
                catch (CertificateNotYetValidException exp) {
                    String msg = "certificate not yet valid (valid from " + df.format(start) + " to " + df.format(end) + ")";
                    throw new CertificateNotYetValidException(msg);
                }
            }
        } else {
            throw new CertificateException("No certificates (Null subject)");
        }
    }

    public static Subject getCurrentSubject() {
        AccessControlContext accessControlContext = AccessController.getContext();
        return Subject.getSubject(accessControlContext);
    }

    public static Principal createPrincipal(String userID, String idType) {
        if (IdentityType.X500.getValue().equalsIgnoreCase(idType)) {
            return new X500Principal(AuthenticationUtil.canonizeDistinguishedName(userID));
        }
        if (IdentityType.USERNAME.getValue().equalsIgnoreCase(idType)) {
            return new HttpPrincipal(userID);
        }
        if (IdentityType.CADC.getValue().equalsIgnoreCase(idType)) {
            try {
                Integer name = new Integer(userID);
                return new NumericPrincipal(name);
            }
            catch (NumberFormatException e) {
                log.warn("CADCPrincipal is non-numeric: " + userID);
            }
        }
        return null;
    }

    public static String getPrincipalType(Principal userID) {
        if (userID instanceof X500Principal) {
            return IdentityType.X500.getValue().toLowerCase();
        }
        if (userID instanceof HttpPrincipal) {
            return IdentityType.USERNAME.getValue().toLowerCase();
        }
        if (userID instanceof NumericPrincipal) {
            return IdentityType.CADC.getValue().toLowerCase();
        }
        return null;
    }
}

