/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.auth;

import ca.nrc.cadc.auth.DelegationToken;
import ca.nrc.cadc.auth.HttpPrincipal;
import ca.nrc.cadc.auth.InvalidDelegationTokenException;
import ca.nrc.cadc.auth.PrincipalExtractor;
import ca.nrc.cadc.auth.SSOCookieCredential;
import ca.nrc.cadc.auth.SSOCookieManager;
import ca.nrc.cadc.auth.X509CertificateChain;
import ca.nrc.cadc.net.NetUtil;
import ca.nrc.cadc.util.ArrayUtil;
import ca.nrc.cadc.util.StringUtil;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletPrincipalExtractor
implements PrincipalExtractor {
    private static final Logger log = Logger.getLogger(ServletPrincipalExtractor.class);
    public static final String CERT_REQUEST_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    private final HttpServletRequest request;
    private X509CertificateChain chain;
    private DelegationToken token;
    private SSOCookieCredential cookieCredential;
    private Principal cookiePrincipal;

    private ServletPrincipalExtractor() {
        this.request = null;
    }

    public ServletPrincipalExtractor(HttpServletRequest req) {
        Cookie[] cookies;
        this.request = req;
        X509Certificate[] ca = (X509Certificate[])this.request.getAttribute(CERT_REQUEST_ATTRIBUTE);
        if (!ArrayUtil.isEmpty(ca)) {
            log.debug("SB: X509Certificate[] ca = (X509Certificate[]) request.getAttribute(CERT_REQUEST_ATTRIBUTE)\nArrayUtil.isEmpty(ca) is false");
            for (int i = 0; i < ca.length; ++i) {
                log.debug("SB: " + i + " X509Certificate read from request");
                X500Principal certPrinc = ca[i].getSubjectX500Principal();
                log.debug("SB Subject = " + certPrinc.getName());
            }
            this.chain = new X509CertificateChain(Arrays.asList(ca));
        } else {
            log.debug("SB: X509Certificate[] ca = (X509Certificate[]) request.getAttribute(CERT_REQUEST_ATTRIBUTE)\nArrayUtil.isEmpty(ca) is true");
        }
        String tokenValue = this.request.getHeader("X-CADC-DelegationToken");
        if (StringUtil.hasText(tokenValue)) {
            try {
                this.token = DelegationToken.parse(tokenValue, this.request.getRequestURI());
                log.debug("SB: delegation token taken");
            }
            catch (InvalidDelegationTokenException ex) {
                log.debug("invalid DelegationToken: " + tokenValue, ex);
                throw new AccessControlException("invalid delegation token");
            }
            catch (RuntimeException ex) {
                log.debug("invalid DelegationToken: " + tokenValue, ex);
                throw new AccessControlException("invalid delegation token");
            }
        }
        if ((cookies = this.request.getCookies()) == null || ArrayUtil.isEmpty(cookies)) {
            return;
        }
        for (Cookie ssoCookie : cookies) {
            if (!"CADC_SSO".equals(ssoCookie.getName()) || !StringUtil.hasText(ssoCookie.getValue())) continue;
            SSOCookieManager ssoCookieManager = new SSOCookieManager();
            try {
                this.cookiePrincipal = ssoCookieManager.parse(ssoCookie.getValue());
                this.cookieCredential = new SSOCookieCredential(ssoCookie.getValue(), NetUtil.getDomainName(this.request.getServerName()));
            }
            catch (IOException e) {
                log.info("Cannot use SSO Cookie. Reason: " + e.getMessage());
            }
            catch (InvalidDelegationTokenException e) {
                log.info("Cannot use SSO Cookie. Reason: " + e.getMessage());
            }
        }
    }

    @Override
    public Set<Principal> getPrincipals() {
        HashSet<Principal> principals = new HashSet<Principal>();
        this.addPrincipals(principals);
        return principals;
    }

    @Override
    public X509CertificateChain getCertificateChain() {
        return this.chain;
    }

    @Override
    public DelegationToken getDelegationToken() {
        return this.token;
    }

    @Override
    public SSOCookieCredential getSSOCookieCredential() {
        return this.cookieCredential;
    }

    protected void addPrincipals(Set<Principal> principals) {
        this.addHTTPPrincipal(principals);
        this.addX500Principal(principals);
    }

    protected void addHTTPPrincipal(Set<Principal> principals) {
        String httpUser = this.request.getRemoteUser();
        if (StringUtil.hasText(httpUser)) {
            principals.add(new HttpPrincipal(httpUser));
        } else if (this.cookiePrincipal != null) {
            principals.add(this.cookiePrincipal);
        } else if (this.token != null) {
            principals.add(this.token.getUser());
        }
    }

    protected void addX500Principal(Set<Principal> principals) {
        if (this.chain != null) {
            principals.add(this.chain.getPrincipal());
        }
    }
}

