/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.date;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String ISO_DATE_FORMAT_TZ = "yyyy-MM-dd HH:mm:ss.SSSZ";
    public static final String IVOA_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String ISO8601_DATE_FORMAT_Z = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String ISO8601_DATE_FORMAT_MSZ = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String ISO8601_DATE_FORMAT_LOCAL = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String ISO8601_DATE_FORMAT_MSLOCAL = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final TimeZone LOCAL = TimeZone.getDefault();
    private static int[] mtab = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static DateFormat getDateFormat(String format, TimeZone tz) {
        if (format == null) {
            format = ISO_DATE_FORMAT;
        }
        if (format.equals(ISO8601_DATE_FORMAT_Z) || format.equals(ISO8601_DATE_FORMAT_MSZ)) {
            if (tz == null) {
                tz = UTC;
            } else if (!UTC.equals(tz)) {
                throw new IllegalArgumentException("Cannot use format " + format + " with non-UTC timezone");
            }
        }
        SimpleDateFormat ret = new SimpleDateFormat(format);
        ret.setLenient(false);
        if (tz != null) {
            ret.setTimeZone(tz);
        }
        return ret;
    }

    public static Date flexToDate(String s, DateFormat fmt) throws ParseException {
        ParseException orig = null;
        NumberFormatException origN = null;
        try {
            return fmt.parse(s);
        }
        catch (ParseException pex) {
            orig = pex;
        }
        catch (NumberFormatException nex) {
            origN = nex;
        }
        try {
            return fmt.parse(s + ".0");
        }
        catch (ParseException parseException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            return fmt.parse(s + "T0:0:0.0");
        }
        catch (ParseException parseException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            return fmt.parse(s + " 0:0:0.0");
        }
        catch (ParseException parseException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (orig != null) {
            throw orig;
        }
        throw new ParseException("failed to parse '" + s + "': " + origN, 0);
    }

    public static Date toDate(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Timestamp) {
            Timestamp ts = (Timestamp)date;
            long millis = ts.getTime();
            return new Date(millis);
        }
        if (date instanceof java.sql.Date) {
            java.sql.Date sd = (java.sql.Date)date;
            return new Date(sd.getTime());
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        throw new UnsupportedOperationException("failed to convert " + date.getClass().getName() + " to java.util.Date");
    }

    public static double toModifiedJulianDate(Date date) {
        return DateUtil.toModifiedJulianDate(date, UTC);
    }

    public static double toModifiedJulianDate(Date date, TimeZone timezone) {
        Calendar cal = Calendar.getInstance(timezone);
        cal.clear();
        cal.setTime(date);
        int yr = cal.get(1);
        int mo = cal.get(2) + 1;
        int dy = cal.get(5);
        double days = DateUtil.slaCldj(yr, mo, dy);
        int hh = cal.get(11);
        int mm = cal.get(12);
        int ss = cal.get(13);
        int ms = cal.get(14);
        double seconds = (double)hh * 3600.0 + (double)mm * 60.0 + (double)ss + (double)ms / 1000.0;
        return days + seconds / 86400.0;
    }

    public static Date toDate(double mjd) {
        int[] ymd = DateUtil.slaDjcl(mjd);
        double frac = mjd - (double)((long)mjd);
        int hh = (int)(frac * 24.0);
        frac = frac * 24.0 - (double)hh;
        int mm = (int)(frac * 60.0);
        frac = frac * 60.0 - (double)mm;
        int ss = (int)(frac * 60.0);
        frac = frac * 60.0 - (double)ss;
        int ms = (int)(frac * 1000.0);
        Calendar cal = Calendar.getInstance(UTC);
        cal.set(1, ymd[0]);
        cal.set(2, ymd[1] - 1);
        cal.set(5, ymd[2]);
        cal.set(11, hh);
        cal.set(12, mm);
        cal.set(13, ss);
        cal.set(14, ms);
        return cal.getTime();
    }

    private static double slaCldj(int iy, int im, int id) {
        if (iy < -4699) {
            throw new IllegalArgumentException("bad year");
        }
        if (im < 1 || im > 12) {
            throw new IllegalArgumentException("bad month");
        }
        int n = DateUtil.mtab[1] = iy % 4 == 0 && (iy % 100 != 0 || iy % 400 == 0) ? 29 : 28;
        if (id < 1 || id > mtab[im - 1]) {
            throw new IllegalArgumentException("bad day");
        }
        long iyL = iy;
        long imL = im;
        return 1461L * (iyL - (12L - imL) / 10L + 4712L) / 4L + (306L * ((imL + 9L) % 12L) + 5L) / 10L - 3L * ((iyL - (12L - imL) / 10L + 4900L) / 100L) / 4L + (long)id - 2399904L;
    }

    private static int[] slaDjcl(double djm) {
        if (djm <= -2395520.0 || djm >= 1.0E9) {
            throw new IllegalArgumentException("MJD out of valid range");
        }
        long ld = (long)djm;
        long jd = ld + 2400001L;
        long n4 = 4L * (jd + (6L * ((4L * jd - 17918L) / 146097L) / 4L + 1L) / 2L - 37L);
        long nd10 = 10L * ((n4 - 237L) % 1461L / 4L) + 5L;
        int[] ret = new int[]{(int)(n4 / 1461L - 4712L), (int)((nd10 / 306L + 2L) % 12L + 1L), (int)(nd10 % 306L / 10L + 1L)};
        return ret;
    }

    public static Date toDate(long dmfSeconds) {
        return new Date(dmfSeconds * 1000L + DateUtil.getDMFEpoch().getTime());
    }

    public static Date getDMFEpoch() {
        Calendar cal = Calendar.getInstance(UTC);
        cal.set(1980, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        return cal.getTime();
    }
}

