/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws;

import ca.nrc.cadc.uws.JobAttribute;
import ca.nrc.cadc.uws.JobRef;
import ca.nrc.cadc.uws.UWS;
import ca.nrc.cadc.xml.ContentConverter;
import ca.nrc.cadc.xml.IterableContent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobListWriter {
    private static Logger log = Logger.getLogger(JobListWriter.class);

    protected void writeDocument(Element root, Writer writer) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document(root);
        outputter.output(document, writer);
    }

    public void write(Iterator<JobRef> jobs, OutputStream out) throws IOException {
        this.write(jobs, new OutputStreamWriter(out));
    }

    public void write(Iterator<JobRef> jobs, Writer writer) throws IOException {
        Element root = this.getRootElement(jobs);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        Document document = new Document(root);
        outputter.output(document, writer);
    }

    public Element getRootElement(Iterator<JobRef> jobs) {
        ContentConverter<Element, JobRef> contentConverter = new ContentConverter<Element, JobRef>(){

            @Override
            public Element convert(JobRef jobRef) {
                return JobListWriter.this.getShortJobDescription(jobRef);
            }
        };
        IterableContent<Element, JobRef> root = new IterableContent<Element, JobRef>(JobAttribute.JOBS.getAttributeName(), UWS.NS, jobs, contentConverter);
        root.addNamespaceDeclaration(UWS.NS);
        root.addNamespaceDeclaration(UWS.XLINK_NS);
        return root;
    }

    public Element getShortJobDescription(JobRef jobRef) {
        Element shortJobDescription = new Element(JobAttribute.JOB_REF.getAttributeName(), UWS.NS);
        shortJobDescription.setAttribute("id", jobRef.getJobID());
        shortJobDescription.addContent(this.getPhase(jobRef));
        return shortJobDescription;
    }

    private Element getPhase(JobRef jobRef) {
        Element element = new Element(JobAttribute.EXECUTION_PHASE.getAttributeName(), UWS.NS);
        element.addContent(jobRef.getExecutionPhase().toString());
        return element;
    }
}

