/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.uws.server;

import ca.nrc.cadc.uws.Job;
import ca.nrc.cadc.uws.server.AbstractExecutor;
import ca.nrc.cadc.uws.server.JobRunner;
import ca.nrc.cadc.uws.server.JobUpdater;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ThreadExecutor
extends AbstractExecutor {
    private static final Logger log = Logger.getLogger(ThreadExecutor.class);
    private final Map<String, Thread> currentJobs = new HashMap<String, Thread>();
    private String threadBaseName;
    private int num = 0;

    public ThreadExecutor(JobUpdater jobUpdater, Class jobRunnerClass) {
        this(jobUpdater, jobRunnerClass, ThreadExecutor.class.getSimpleName());
    }

    public ThreadExecutor(JobUpdater jobUpdater, Class jobRunnerClass, String threadBaseName) {
        super(jobUpdater, jobRunnerClass);
        if (threadBaseName == null) {
            throw new IllegalArgumentException("threadBaseName cannot be null");
        }
        this.threadBaseName = threadBaseName + "-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abortJob(String jobID) {
        Map<String, Thread> map = this.currentJobs;
        synchronized (map) {
            Thread t = this.currentJobs.remove(jobID);
            if (t != null && t.isAlive()) {
                t.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAsync(final Job job, final JobRunner jobRunner) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                jobRunner.run();
                Map map = ThreadExecutor.this.currentJobs;
                synchronized (map) {
                    ThreadExecutor.this.currentJobs.remove(job.getID());
                }
            }
        };
        Thread t = new Thread(r);
        t.setName(this.threadBaseName + Integer.toString(this.num++));
        t.setDaemon(true);
        t.start();
        Map<String, Thread> map = this.currentJobs;
        synchronized (map) {
            this.currentJobs.put(job.getID(), t);
        }
    }
}

