/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.vos;

import ca.nrc.cadc.vos.ContainerNode;
import ca.nrc.cadc.vos.NodeProperty;
import ca.nrc.cadc.vos.VOSURI;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements Comparable<Object> {
    private static Logger log = Logger.getLogger(Node.class);
    public int version = 20;
    protected VOSURI uri;
    protected String name;
    protected ContainerNode parent;
    protected List<NodeProperty> properties;
    protected boolean isPublic;
    protected boolean isLocked;
    public transient Object appData;
    protected List<URI> accepts;
    protected List<URI> provides;

    private Node() {
    }

    public Node(VOSURI uri) {
        this(uri, new ArrayList<NodeProperty>());
    }

    public Node(VOSURI uri, List<NodeProperty> properties) {
        this.uri = uri;
        this.properties = properties;
        this.name = uri.getName();
        log.debug("uri: " + uri + " -> name: " + this.name);
        this.accepts = new ArrayList<URI>();
        this.provides = new ArrayList<URI>();
    }

    public String toString() {
        String parentStr = null;
        if (this.parent != null) {
            parentStr = this.parent.uri.toString() + " " + this.parent.appData;
        }
        return this.getClass().getSimpleName() + " [appData=" + this.appData + ", uri=" + this.uri.toString() + ", parent=" + parentStr + ", properties=" + this.properties + "]";
    }

    @Override
    public int compareTo(Object o1) {
        if (o1 == null) {
            return -1;
        }
        if (!(o1 instanceof Node)) {
            throw new ClassCastException("compareTo requires a Node, got: " + o1.getClass().getName());
        }
        Node rhs = (Node)o1;
        String s1 = this.getUri().getURI().toASCIIString();
        String s2 = rhs.getUri().getURI().toASCIIString();
        return s1.compareTo(s2);
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public abstract boolean isStructured();

    public List<URI> accepts() {
        return this.accepts;
    }

    public List<URI> provides() {
        return this.provides;
    }

    public void setAccepts(List<URI> accepts) {
        this.accepts = accepts;
    }

    public void setProvides(List<URI> provides) {
        this.provides = provides;
    }

    public VOSURI getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContainerNode getParent() {
        return this.parent;
    }

    public void setParent(ContainerNode parent) {
        this.parent = parent;
    }

    public List<NodeProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<NodeProperty> properties) {
        this.properties = properties;
    }

    public boolean isPublic() {
        String val = this.getPropertyValue("ivo://ivoa.net/vospace/core#ispublic");
        return "true".equals(val);
    }

    public boolean isLocked() {
        String val = this.getPropertyValue("ivo://cadc.nrc.ca/vospace/core#islocked");
        return "true".equals(val);
    }

    public NodeProperty findProperty(String propertyURI) {
        for (NodeProperty prop : this.properties) {
            if (!prop.getPropertyURI().equalsIgnoreCase(propertyURI)) continue;
            return prop;
        }
        return null;
    }

    public String getPropertyValue(String propertyURI) {
        NodeProperty prop = this.findProperty(propertyURI);
        if (prop != null) {
            return prop.getPropertyValue();
        }
        return null;
    }

    public static LinkedList<Node> getNodeList(Node leaf) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Node cur = leaf; cur != null; cur = cur.getParent()) {
            nodes.add(cur);
        }
        return nodes;
    }
}

